/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch.bluetooth;

import android.os.Handler;
import androidx.annotation.VisibleForTesting;
import com.twilio.audioswitch.android.Logger;
import com.twilio.audioswitch.android.SystemClockWrapper;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\b\u0010\u0014\u001a\u00020\u0012H$J\b\u0010\u0015\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\b\u0018\u00010\nR\u00020\u00008\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob;", "", "logger", "Lcom/twilio/audioswitch/android/Logger;", "bluetoothScoHandler", "Landroid/os/Handler;", "systemClockWrapper", "Lcom/twilio/audioswitch/android/SystemClockWrapper;", "(Lcom/twilio/audioswitch/android/Logger;Landroid/os/Handler;Lcom/twilio/audioswitch/android/SystemClockWrapper;)V", "bluetoothScoRunnable", "Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob$BluetoothScoRunnable;", "getBluetoothScoRunnable$annotations", "()V", "getBluetoothScoRunnable", "()Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob$BluetoothScoRunnable;", "setBluetoothScoRunnable", "(Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob$BluetoothScoRunnable;)V", "cancelBluetoothScoJob", "", "executeBluetoothScoJob", "scoAction", "scoTimeOutAction", "BluetoothScoRunnable", "audioswitch_release"})
@SourceDebugExtension(value={"SMAP\nBluetoothScoJob.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BluetoothScoJob.kt\ncom/twilio/audioswitch/bluetooth/BluetoothScoJob\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public abstract class BluetoothScoJob {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Handler bluetoothScoHandler;
    @NotNull
    private final SystemClockWrapper systemClockWrapper;
    @Nullable
    private BluetoothScoRunnable bluetoothScoRunnable;

    public BluetoothScoJob(@NotNull Logger logger, @NotNull Handler bluetoothScoHandler, @NotNull SystemClockWrapper systemClockWrapper) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)bluetoothScoHandler, (String)"bluetoothScoHandler");
        Intrinsics.checkNotNullParameter((Object)systemClockWrapper, (String)"systemClockWrapper");
        this.logger = logger;
        this.bluetoothScoHandler = bluetoothScoHandler;
        this.systemClockWrapper = systemClockWrapper;
    }

    @Nullable
    public final BluetoothScoRunnable getBluetoothScoRunnable() {
        return this.bluetoothScoRunnable;
    }

    public final void setBluetoothScoRunnable(@Nullable BluetoothScoRunnable bluetoothScoRunnable) {
        this.bluetoothScoRunnable = bluetoothScoRunnable;
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getBluetoothScoRunnable$annotations() {
    }

    protected abstract void scoAction();

    public void scoTimeOutAction() {
    }

    public final void executeBluetoothScoJob() {
        BluetoothScoRunnable bluetoothScoRunnable;
        BluetoothScoRunnable bluetoothScoRunnable2 = this.bluetoothScoRunnable;
        if (bluetoothScoRunnable2 != null) {
            BluetoothScoRunnable it = bluetoothScoRunnable2;
            boolean bl = false;
            this.bluetoothScoHandler.removeCallbacks((Runnable)it);
        }
        BluetoothScoRunnable $this$executeBluetoothScoJob_u24lambda_u241 = bluetoothScoRunnable = new BluetoothScoRunnable();
        boolean bl = false;
        this.bluetoothScoRunnable = $this$executeBluetoothScoJob_u24lambda_u241;
        this.bluetoothScoHandler.post((Runnable)$this$executeBluetoothScoJob_u24lambda_u241);
        this.logger.d("BluetoothScoJob", "Scheduled bluetooth sco job");
    }

    public final void cancelBluetoothScoJob() {
        block0: {
            BluetoothScoRunnable bluetoothScoRunnable = this.bluetoothScoRunnable;
            if (bluetoothScoRunnable == null) break block0;
            BluetoothScoRunnable it = bluetoothScoRunnable;
            boolean bl = false;
            this.bluetoothScoHandler.removeCallbacks((Runnable)it);
            this.bluetoothScoRunnable = null;
            this.logger.d("BluetoothScoJob", "Canceled bluetooth sco job");
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob$BluetoothScoRunnable;", "Ljava/lang/Runnable;", "(Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob;)V", "elapsedTime", "", "startTime", "run", "", "audioswitch_release"})
    public final class BluetoothScoRunnable
    implements Runnable {
        private final long startTime;
        private long elapsedTime;

        public BluetoothScoRunnable() {
            this.startTime = BluetoothScoJob.this.systemClockWrapper.elapsedRealtime();
        }

        @Override
        public void run() {
            if (this.elapsedTime < 5000L) {
                BluetoothScoJob.this.scoAction();
                this.elapsedTime = BluetoothScoJob.this.systemClockWrapper.elapsedRealtime() - this.startTime;
                BluetoothScoJob.this.bluetoothScoHandler.postDelayed((Runnable)this, 500L);
            } else {
                BluetoothScoJob.this.logger.e("BluetoothScoJob", "Bluetooth sco job timed out", new TimeoutException());
                BluetoothScoJob.this.scoTimeOutAction();
                BluetoothScoJob.this.cancelBluetoothScoJob();
            }
        }
    }
}

