/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch;

import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.media.AudioManager;
import androidx.annotation.VisibleForTesting;
import com.twilio.audioswitch.AudioDevice;
import com.twilio.audioswitch.AudioDeviceManager;
import com.twilio.audioswitch.AudioSwitch;
import com.twilio.audioswitch.AudioSwitch$WhenMappings;
import com.twilio.audioswitch.android.Logger;
import com.twilio.audioswitch.android.ProductionLogger;
import com.twilio.audioswitch.bluetooth.BluetoothHeadsetConnectionListener;
import com.twilio.audioswitch.bluetooth.BluetoothHeadsetManager;
import com.twilio.audioswitch.wired.WiredDeviceConnectionListener;
import com.twilio.audioswitch.wired.WiredHeadsetReceiver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u000f\u0018\u0000 R2\u00020\u0001:\u0003QRSB;\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\t\u00a2\u0006\u0002\u0010\fBU\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\t\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010A\u001a\u00020\u001cJ\u0010\u0010A\u001a\u00020\u001c2\u0006\u0010B\u001a\u00020\u000bH\u0002J\u0012\u0010C\u001a\u00020\u001c2\b\u0010D\u001a\u0004\u0018\u00010EH\u0002J\b\u0010F\u001a\u00020\u001cH\u0002J\u0006\u0010G\u001a\u00020\u001cJ\u0014\u0010H\u001a\u00020\u001c2\n\b\u0002\u0010D\u001a\u0004\u0018\u00010EH\u0002J,\u0010I\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\t2\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tH\u0002J\u001e\u0010J\u001a\u00020\u00052\u0014\u0010K\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tH\u0002J\u0010\u0010L\u001a\u00020\u001c2\b\u0010B\u001a\u0004\u0018\u00010\u000bJJ\u0010M\u001a\u00020\u001c2B\u0010N\u001a>\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0015\u0012\u0013\u0018\u00010\u000b\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u001c0\u0017j\u0002`\u001dJ\u0006\u0010O\u001a\u00020\u001cJ\u0016\u0010P\u001a\u00020\u00052\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\tH\u0002RZ\u0010\u0016\u001aB\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0015\u0012\u0013\u0018\u00010\u000b\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u0017j\u0004\u0018\u0001`\u001dX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0010\u0010)\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001e\u0010/\u001a\u0012\u0012\u0004\u0012\u00020\u000b00j\b\u0012\u0004\u0012\u00020\u000b`1X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0010\u00104\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00105\u001a\u000206X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u0010\u0010;\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010<\u001a\u00020=X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u000e\u0010@\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/twilio/audioswitch/AudioSwitch;", "", "context", "Landroid/content/Context;", "loggingEnabled", "", "audioFocusChangeListener", "Landroid/media/AudioManager$OnAudioFocusChangeListener;", "preferredDeviceList", "", "Ljava/lang/Class;", "Lcom/twilio/audioswitch/AudioDevice;", "(Landroid/content/Context;ZLandroid/media/AudioManager$OnAudioFocusChangeListener;Ljava/util/List;)V", "logger", "Lcom/twilio/audioswitch/android/Logger;", "audioDeviceManager", "Lcom/twilio/audioswitch/AudioDeviceManager;", "wiredHeadsetReceiver", "Lcom/twilio/audioswitch/wired/WiredHeadsetReceiver;", "headsetManager", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager;", "(Landroid/content/Context;Lcom/twilio/audioswitch/android/Logger;Landroid/media/AudioManager$OnAudioFocusChangeListener;Ljava/util/List;Lcom/twilio/audioswitch/AudioDeviceManager;Lcom/twilio/audioswitch/wired/WiredHeadsetReceiver;Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager;)V", "audioDeviceChangeListener", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "audioDevices", "selectedAudioDevice", "", "Lcom/twilio/audioswitch/AudioDeviceChangeListener;", "getAudioDeviceChangeListener$audioswitch_release", "()Lkotlin/jvm/functions/Function2;", "setAudioDeviceChangeListener$audioswitch_release", "(Lkotlin/jvm/functions/Function2;)V", "availableAudioDevices", "getAvailableAudioDevices", "()Ljava/util/List;", "bluetoothDeviceConnectionListener", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetConnectionListener;", "getBluetoothDeviceConnectionListener$audioswitch_release", "()Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetConnectionListener;", "bluetoothHeadsetManager", "value", "getLoggingEnabled", "()Z", "setLoggingEnabled", "(Z)V", "mutableAudioDevices", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getSelectedAudioDevice", "()Lcom/twilio/audioswitch/AudioDevice;", "selectedDevice", "state", "Lcom/twilio/audioswitch/AudioSwitch$State;", "getState$audioswitch_release", "()Lcom/twilio/audioswitch/AudioSwitch$State;", "setState$audioswitch_release", "(Lcom/twilio/audioswitch/AudioSwitch$State;)V", "userSelectedDevice", "wiredDeviceConnectionListener", "Lcom/twilio/audioswitch/wired/WiredDeviceConnectionListener;", "getWiredDeviceConnectionListener$audioswitch_release", "()Lcom/twilio/audioswitch/wired/WiredDeviceConnectionListener;", "wiredHeadsetAvailable", "activate", "audioDevice", "addAvailableAudioDevices", "bluetoothHeadsetName", "", "closeListeners", "deactivate", "enumerateDevices", "getPreferredDeviceList", "hasNoDuplicates", "list", "selectDevice", "start", "listener", "stop", "userSelectedDevicePresent", "AudioDeviceState", "Companion", "State", "audioswitch_release"})
public final class AudioSwitch {
    private Logger logger;
    private final AudioDeviceManager audioDeviceManager;
    private final WiredHeadsetReceiver wiredHeadsetReceiver;
    @Nullable
    private Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> audioDeviceChangeListener;
    private AudioDevice selectedDevice;
    private AudioDevice userSelectedDevice;
    private boolean wiredHeadsetAvailable;
    private final ArrayList<AudioDevice> mutableAudioDevices;
    private BluetoothHeadsetManager bluetoothHeadsetManager;
    private final List<Class<? extends AudioDevice>> preferredDeviceList;
    @NotNull
    private State state;
    @NotNull
    private final BluetoothHeadsetConnectionListener bluetoothDeviceConnectionListener;
    @NotNull
    private final WiredDeviceConnectionListener wiredDeviceConnectionListener;
    @NotNull
    private final List<AudioDevice> availableAudioDevices;
    @NotNull
    public static final String VERSION = "1.1.6";
    private static final Lazy defaultPreferredDeviceList$delegate;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final Function2<List<? extends AudioDevice>, AudioDevice, Unit> getAudioDeviceChangeListener$audioswitch_release() {
        return this.audioDeviceChangeListener;
    }

    public final void setAudioDeviceChangeListener$audioswitch_release(@Nullable Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> function2) {
        this.audioDeviceChangeListener = function2;
    }

    @NotNull
    public final State getState$audioswitch_release() {
        return this.state;
    }

    public final void setState$audioswitch_release(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        this.state = state;
    }

    @NotNull
    public final BluetoothHeadsetConnectionListener getBluetoothDeviceConnectionListener$audioswitch_release() {
        return this.bluetoothDeviceConnectionListener;
    }

    @NotNull
    public final WiredDeviceConnectionListener getWiredDeviceConnectionListener$audioswitch_release() {
        return this.wiredDeviceConnectionListener;
    }

    public final boolean getLoggingEnabled() {
        return this.logger.getLoggingEnabled();
    }

    public final void setLoggingEnabled(boolean value) {
        this.logger.setLoggingEnabled(value);
    }

    @Nullable
    public final AudioDevice getSelectedAudioDevice() {
        return this.selectedDevice;
    }

    @NotNull
    public final List<AudioDevice> getAvailableAudioDevices() {
        return this.availableAudioDevices;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Class<? extends AudioDevice>> getPreferredDeviceList(List<? extends Class<? extends AudioDevice>> preferredDeviceList) {
        List list;
        boolean bl = this.hasNoDuplicates(preferredDeviceList);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (preferredDeviceList.isEmpty() || Intrinsics.areEqual(preferredDeviceList, (Object)AudioSwitch.Companion.getDefaultPreferredDeviceList())) {
            list = AudioSwitch.Companion.getDefaultPreferredDeviceList();
        } else {
            void var2_3;
            List result = CollectionsKt.toMutableList((Collection)AudioSwitch.Companion.getDefaultPreferredDeviceList());
            result.removeAll((Collection)preferredDeviceList);
            Iterable $this$forEachIndexed$iv = preferredDeviceList;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void device;
                int n = index$iv++;
                boolean bl6 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Class clazz = (Class)item$iv;
                int index = n;
                boolean bl7 = false;
                result.add(index, device);
            }
            list = var2_3;
        }
        return list;
    }

    public final void start(@NotNull Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.audioDeviceChangeListener = listener;
        switch (AudioSwitch$WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                AudioSwitch.enumerateDevices$default(this, null, 1, null);
                BluetoothHeadsetManager bluetoothHeadsetManager = this.bluetoothHeadsetManager;
                if (bluetoothHeadsetManager != null) {
                    bluetoothHeadsetManager.start(this.bluetoothDeviceConnectionListener);
                }
                this.wiredHeadsetReceiver.start(this.wiredDeviceConnectionListener);
                this.state = State.STARTED;
                break;
            }
            default: {
                this.logger.d("AudioSwitch", "Redundant start() invocation while already in the started or activated state");
            }
        }
    }

    public final void stop() {
        switch (AudioSwitch$WhenMappings.$EnumSwitchMapping$1[this.state.ordinal()]) {
            case 1: {
                this.deactivate();
                this.closeListeners();
                break;
            }
            case 2: {
                this.closeListeners();
                break;
            }
            case 3: {
                this.logger.d("AudioSwitch", "Redundant stop() invocation while already in the stopped state");
                break;
            }
        }
    }

    public final void activate() {
        switch (AudioSwitch$WhenMappings.$EnumSwitchMapping$2[this.state.ordinal()]) {
            case 1: {
                this.audioDeviceManager.cacheAudioState();
                this.audioDeviceManager.mute(false);
                this.audioDeviceManager.setAudioFocus();
                AudioDevice audioDevice = this.selectedDevice;
                if (audioDevice != null) {
                    AudioDevice audioDevice2 = audioDevice;
                    boolean bl = false;
                    boolean bl2 = false;
                    AudioDevice it = audioDevice2;
                    boolean bl3 = false;
                    this.activate(it);
                }
                this.state = State.ACTIVATED;
                break;
            }
            case 2: {
                AudioDevice audioDevice = this.selectedDevice;
                if (audioDevice != null) {
                    AudioDevice audioDevice3 = audioDevice;
                    boolean bl = false;
                    boolean bl4 = false;
                    AudioDevice it = audioDevice3;
                    boolean bl5 = false;
                    this.activate(it);
                }
                break;
            }
            case 3: {
                throw (Throwable)new IllegalStateException();
            }
        }
    }

    public final void deactivate() {
        switch (AudioSwitch$WhenMappings.$EnumSwitchMapping$3[this.state.ordinal()]) {
            case 1: {
                BluetoothHeadsetManager bluetoothHeadsetManager = this.bluetoothHeadsetManager;
                if (bluetoothHeadsetManager != null) {
                    bluetoothHeadsetManager.deactivate();
                }
                this.audioDeviceManager.restoreAudioState();
                this.state = State.STARTED;
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
    }

    public final void selectDevice(@Nullable AudioDevice audioDevice) {
        if (Intrinsics.areEqual((Object)this.selectedDevice, (Object)audioDevice) ^ true) {
            this.logger.d("AudioSwitch", "Selected AudioDevice = " + audioDevice);
            this.userSelectedDevice = audioDevice;
            AudioSwitch.enumerateDevices$default(this, null, 1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasNoDuplicates(List<? extends Class<? extends AudioDevice>> list) {
        void $this$filterTo$iv$iv;
        Iterable $this$groupingBy$iv = list;
        boolean $i$f$groupingBy = false;
        Map $this$filter$iv = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<Class<? extends AudioDevice>, Class<? extends AudioDevice>>($this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            @NotNull
            public Iterator<Class<? extends AudioDevice>> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element) {
                void var2_2;
                Class it = (Class)element;
                boolean bl = false;
                return var2_2;
            }
        }));
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var7_7 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_7.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (!(((Number)it.getValue()).intValue() > 1)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv.isEmpty();
    }

    private final void activate(AudioDevice audioDevice) {
        block2: {
            AudioDevice audioDevice2;
            block3: {
                block1: {
                    audioDevice2 = audioDevice;
                    if (!(audioDevice2 instanceof AudioDevice.BluetoothHeadset)) break block1;
                    this.audioDeviceManager.enableSpeakerphone(false);
                    BluetoothHeadsetManager bluetoothHeadsetManager = this.bluetoothHeadsetManager;
                    if (bluetoothHeadsetManager == null) break block2;
                    bluetoothHeadsetManager.activate();
                    break block2;
                }
                if (!(audioDevice2 instanceof AudioDevice.Earpiece) && !(audioDevice2 instanceof AudioDevice.WiredHeadset)) break block3;
                this.audioDeviceManager.enableSpeakerphone(false);
                BluetoothHeadsetManager bluetoothHeadsetManager = this.bluetoothHeadsetManager;
                if (bluetoothHeadsetManager == null) break block2;
                bluetoothHeadsetManager.deactivate();
                break block2;
            }
            if (!(audioDevice2 instanceof AudioDevice.Speakerphone)) break block2;
            this.audioDeviceManager.enableSpeakerphone(true);
            BluetoothHeadsetManager bluetoothHeadsetManager = this.bluetoothHeadsetManager;
            if (bluetoothHeadsetManager != null) {
                bluetoothHeadsetManager.deactivate();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void enumerateDevices(String bluetoothHeadsetName) {
        block9: {
            block7: {
                block8: {
                    block6: {
                        $this$map$iv = this.mutableAudioDevices;
                        $i$f$map = false;
                        var5_4 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var10_9 = (AudioDevice)item$iv$iv;
                            var14_11 = destination$iv$iv;
                            $i$a$-map-AudioSwitch$enumerateDevices$oldAudioDeviceState$1 = false;
                            var15_12 = it;
                            var14_11.add(var15_12);
                        }
                        var14_11 = (List)destination$iv$iv;
                        var16_13 = this.selectedDevice;
                        var17_14 = var14_11;
                        oldAudioDeviceState = new AudioDeviceState(var17_14, var16_13);
                        this.addAvailableAudioDevices(bluetoothHeadsetName);
                        if (!this.userSelectedDevicePresent((List<? extends AudioDevice>)this.mutableAudioDevices)) {
                            this.userSelectedDevice = null;
                        }
                        this.logger.d("AudioSwitch", "Current user selected AudioDevice = " + this.userSelectedDevice);
                        if (this.userSelectedDevice == null) break block6;
                        v0 = this.userSelectedDevice;
                        break block7;
                    }
                    if (this.mutableAudioDevices.size() <= 0) break block8;
                    v1 = this.mutableAudioDevices.get(0);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"mutableAudioDevices[0]");
                    firstAudioDevice = v1;
                    if (!(firstAudioDevice instanceof AudioDevice.BluetoothHeadset)) ** GOTO lbl-1000
                    v2 = this.bluetoothHeadsetManager;
                    if (v2 == null) ** GOTO lbl-1000
                    if (v2.hasActivationError()) {
                        v0 = this.mutableAudioDevices.get(1);
                    } else lbl-1000:
                    // 3 sources

                    {
                        v0 = firstAudioDevice;
                    }
                    break block7;
                }
                v0 = this.selectedDevice = null;
            }
            if (this.state == State.ACTIVATED) {
                this.activate();
            }
            if (!(Intrinsics.areEqual((Object)(newAudioDeviceState = new AudioDeviceState((List<? extends AudioDevice>)this.mutableAudioDevices, this.selectedDevice)), (Object)oldAudioDeviceState) ^ true)) break block9;
            v3 = this.audioDeviceChangeListener;
            if (v3 != null) {
                (Unit)v3.invoke(this.mutableAudioDevices, (Object)this.selectedDevice);
            }
        }
    }

    static /* synthetic */ void enumerateDevices$default(AudioSwitch audioSwitch, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        audioSwitch.enumerateDevices(string);
    }

    private final void addAvailableAudioDevices(String bluetoothHeadsetName) {
        this.mutableAudioDevices.clear();
        Iterable $this$forEach$iv = this.preferredDeviceList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class audioDevice = (Class)element$iv;
            boolean bl = false;
            Class clazz = audioDevice;
            if (Intrinsics.areEqual((Object)clazz, AudioDevice.BluetoothHeadset.class)) {
                Object object = this.bluetoothHeadsetManager;
                if (object != null && (object = object.getHeadset(bluetoothHeadsetName)) != null) {
                    Object object2 = object;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Object it = object2;
                    boolean bl4 = false;
                    this.mutableAudioDevices.add((AudioDevice)it);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)clazz, AudioDevice.WiredHeadset.class)) {
                if (!this.wiredHeadsetAvailable) continue;
                this.mutableAudioDevices.add(new AudioDevice.WiredHeadset(null, 1, null));
                continue;
            }
            if (Intrinsics.areEqual((Object)clazz, AudioDevice.Earpiece.class)) {
                if (!this.audioDeviceManager.hasEarpiece() || this.wiredHeadsetAvailable) continue;
                this.mutableAudioDevices.add(new AudioDevice.Earpiece(null, 1, null));
                continue;
            }
            if (!Intrinsics.areEqual((Object)clazz, AudioDevice.Speakerphone.class) || !this.audioDeviceManager.hasSpeakerphone()) continue;
            this.mutableAudioDevices.add(new AudioDevice.Speakerphone(null, 1, null));
        }
        this.logger.d("AudioSwitch", "Available AudioDevice list updated: " + this.availableAudioDevices);
    }

    private final boolean userSelectedDevicePresent(List<? extends AudioDevice> audioDevices) {
        boolean bl;
        AudioDevice audioDevice = this.userSelectedDevice;
        if (audioDevice != null) {
            AudioDevice audioDevice2 = audioDevice;
            boolean bl2 = false;
            boolean bl3 = false;
            AudioDevice selectedDevice = audioDevice2;
            boolean bl4 = false;
            if (selectedDevice instanceof AudioDevice.BluetoothHeadset) {
                Object v1;
                boolean bl5;
                Object object;
                block7: {
                    object = audioDevices;
                    bl5 = false;
                    Iterable iterable = object;
                    boolean bl6 = false;
                    for (Object t : iterable) {
                        AudioDevice it = (AudioDevice)t;
                        boolean bl7 = false;
                        if (!(it instanceof AudioDevice.BluetoothHeadset)) continue;
                        v1 = t;
                        break block7;
                    }
                    v1 = null;
                }
                AudioDevice audioDevice3 = v1;
                if (audioDevice3 != null) {
                    object = audioDevice3;
                    bl5 = false;
                    boolean bl8 = false;
                    Object newHeadset = object;
                    boolean bl9 = false;
                    this.userSelectedDevice = newHeadset;
                    bl = true;
                } else {
                    bl = false;
                }
            } else {
                bl = audioDevices.contains(selectedDevice);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private final void closeListeners() {
        BluetoothHeadsetManager bluetoothHeadsetManager = this.bluetoothHeadsetManager;
        if (bluetoothHeadsetManager != null) {
            bluetoothHeadsetManager.stop();
        }
        this.wiredHeadsetReceiver.stop();
        this.audioDeviceChangeListener = null;
        this.state = State.STOPPED;
    }

    @JvmOverloads
    public AudioSwitch(@NotNull Context context, boolean loggingEnabled, @NotNull AudioManager.OnAudioFocusChangeListener audioFocusChangeListener, @NotNull List<? extends Class<? extends AudioDevice>> preferredDeviceList) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)audioFocusChangeListener, (String)"audioFocusChangeListener");
        Intrinsics.checkNotNullParameter(preferredDeviceList, (String)"preferredDeviceList");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this(context2, new ProductionLogger(loggingEnabled), audioFocusChangeListener, preferredDeviceList, null, null, null, 112, null);
    }

    public /* synthetic */ AudioSwitch(Context context, boolean bl, AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            onAudioFocusChangeListener = 1.INSTANCE;
        }
        if ((n & 8) != 0) {
            list = AudioSwitch.Companion.getDefaultPreferredDeviceList();
        }
        this(context, bl, onAudioFocusChangeListener, list);
    }

    @JvmOverloads
    public AudioSwitch(@NotNull Context context, boolean loggingEnabled, @NotNull AudioManager.OnAudioFocusChangeListener audioFocusChangeListener) {
        this(context, loggingEnabled, audioFocusChangeListener, null, 8, null);
    }

    @JvmOverloads
    public AudioSwitch(@NotNull Context context, boolean loggingEnabled) {
        this(context, loggingEnabled, null, null, 12, null);
    }

    @JvmOverloads
    public AudioSwitch(@NotNull Context context) {
        this(context, false, null, null, 14, null);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting(otherwise=2)
    public AudioSwitch(@NotNull Context context, @NotNull Logger logger, @NotNull AudioManager.OnAudioFocusChangeListener audioFocusChangeListener, @NotNull List<? extends Class<? extends AudioDevice>> preferredDeviceList, @NotNull AudioDeviceManager audioDeviceManager, @NotNull WiredHeadsetReceiver wiredHeadsetReceiver, @Nullable BluetoothHeadsetManager headsetManager) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)audioFocusChangeListener, (String)"audioFocusChangeListener");
        Intrinsics.checkNotNullParameter(preferredDeviceList, (String)"preferredDeviceList");
        Intrinsics.checkNotNullParameter((Object)audioDeviceManager, (String)"audioDeviceManager");
        Intrinsics.checkNotNullParameter((Object)((Object)wiredHeadsetReceiver), (String)"wiredHeadsetReceiver");
        this.logger = new ProductionLogger(false, 1, null);
        this.mutableAudioDevices = new ArrayList();
        this.state = State.STOPPED;
        this.bluetoothDeviceConnectionListener = new BluetoothHeadsetConnectionListener(this){
            final /* synthetic */ AudioSwitch this$0;

            public void onBluetoothHeadsetStateChanged(@Nullable String headsetName) {
                AudioSwitch.access$enumerateDevices(this.this$0, headsetName);
            }

            public void onBluetoothHeadsetActivationError() {
                if (AudioSwitch.access$getUserSelectedDevice$p(this.this$0) instanceof AudioDevice.BluetoothHeadset) {
                    AudioSwitch.access$setUserSelectedDevice$p(this.this$0, null);
                }
                AudioSwitch.enumerateDevices$default(this.this$0, null, 1, null);
            }
            {
                this.this$0 = this$0;
            }
        };
        this.wiredDeviceConnectionListener = new WiredDeviceConnectionListener(this){
            final /* synthetic */ AudioSwitch this$0;

            public void onDeviceConnected() {
                AudioSwitch.access$setWiredHeadsetAvailable$p(this.this$0, true);
                AudioSwitch.enumerateDevices$default(this.this$0, null, 1, null);
            }

            public void onDeviceDisconnected() {
                AudioSwitch.access$setWiredHeadsetAvailable$p(this.this$0, false);
                AudioSwitch.enumerateDevices$default(this.this$0, null, 1, null);
            }
            {
                this.this$0 = this$0;
            }
        };
        this.availableAudioDevices = this.mutableAudioDevices;
        this.logger = logger;
        this.audioDeviceManager = audioDeviceManager;
        this.wiredHeadsetReceiver = wiredHeadsetReceiver;
        this.bluetoothHeadsetManager = headsetManager;
        this.preferredDeviceList = this.getPreferredDeviceList(preferredDeviceList);
        logger.d("AudioSwitch", "AudioSwitch(1.1.6)");
        Iterable iterable = this.preferredDeviceList;
        StringBuilder stringBuilder = new StringBuilder().append("Preferred device list = ");
        String string = "AudioSwitch";
        Logger logger2 = logger;
        boolean $i$f$map = false;
        void var10_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Class clazz = (Class)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getSimpleName();
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        logger2.d(string, stringBuilder.append(collection).toString());
    }

    public /* synthetic */ AudioSwitch(Context context, Logger logger, AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener, List list, AudioDeviceManager audioDeviceManager, WiredHeadsetReceiver wiredHeadsetReceiver, BluetoothHeadsetManager bluetoothHeadsetManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            Object object = context.getSystemService("audio");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.media.AudioManager");
            }
            audioDeviceManager = new AudioDeviceManager(context, logger, (AudioManager)object, null, null, onAudioFocusChangeListener, 24, null);
        }
        if ((n & 0x20) != 0) {
            wiredHeadsetReceiver = new WiredHeadsetReceiver(context, logger);
        }
        if ((n & 0x40) != 0) {
            bluetoothHeadsetManager = BluetoothHeadsetManager.Companion.newInstance$audioswitch_release(context, logger, BluetoothAdapter.getDefaultAdapter(), audioDeviceManager);
        }
        this(context, logger, onAudioFocusChangeListener, list, audioDeviceManager, wiredHeadsetReceiver, bluetoothHeadsetManager);
    }

    static {
        Companion = new Companion(null);
        defaultPreferredDeviceList$delegate = LazyKt.lazy((Function0)Companion.defaultPreferredDeviceList.2.INSTANCE);
    }

    public static final /* synthetic */ void access$enumerateDevices(AudioSwitch $this, String bluetoothHeadsetName) {
        $this.enumerateDevices(bluetoothHeadsetName);
    }

    public static final /* synthetic */ AudioDevice access$getUserSelectedDevice$p(AudioSwitch $this) {
        return $this.userSelectedDevice;
    }

    public static final /* synthetic */ void access$setUserSelectedDevice$p(AudioSwitch $this, AudioDevice audioDevice) {
        $this.userSelectedDevice = audioDevice;
    }

    public static final /* synthetic */ boolean access$getWiredHeadsetAvailable$p(AudioSwitch $this) {
        return $this.wiredHeadsetAvailable;
    }

    public static final /* synthetic */ void access$setWiredHeadsetAvailable$p(AudioSwitch $this, boolean bl) {
        $this.wiredHeadsetAvailable = bl;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/twilio/audioswitch/AudioSwitch$State;", "", "(Ljava/lang/String;I)V", "STARTED", "ACTIVATED", "STOPPED", "audioswitch_release"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State STARTED;
        public static final /* enum */ State ACTIVATED;
        public static final /* enum */ State STOPPED;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = STARTED = new State();
            stateArray[1] = ACTIVATED = new State();
            stateArray[2] = STOPPED = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J%\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/twilio/audioswitch/AudioSwitch$AudioDeviceState;", "", "audioDeviceList", "", "Lcom/twilio/audioswitch/AudioDevice;", "selectedAudioDevice", "(Ljava/util/List;Lcom/twilio/audioswitch/AudioDevice;)V", "getAudioDeviceList", "()Ljava/util/List;", "getSelectedAudioDevice", "()Lcom/twilio/audioswitch/AudioDevice;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "audioswitch_release"})
    public static final class AudioDeviceState {
        @NotNull
        private final List<AudioDevice> audioDeviceList;
        @Nullable
        private final AudioDevice selectedAudioDevice;

        @NotNull
        public final List<AudioDevice> getAudioDeviceList() {
            return this.audioDeviceList;
        }

        @Nullable
        public final AudioDevice getSelectedAudioDevice() {
            return this.selectedAudioDevice;
        }

        public AudioDeviceState(@NotNull List<? extends AudioDevice> audioDeviceList, @Nullable AudioDevice selectedAudioDevice) {
            Intrinsics.checkNotNullParameter(audioDeviceList, (String)"audioDeviceList");
            this.audioDeviceList = audioDeviceList;
            this.selectedAudioDevice = selectedAudioDevice;
        }

        @NotNull
        public final List<AudioDevice> component1() {
            return this.audioDeviceList;
        }

        @Nullable
        public final AudioDevice component2() {
            return this.selectedAudioDevice;
        }

        @NotNull
        public final AudioDeviceState copy(@NotNull List<? extends AudioDevice> audioDeviceList, @Nullable AudioDevice selectedAudioDevice) {
            Intrinsics.checkNotNullParameter(audioDeviceList, (String)"audioDeviceList");
            return new AudioDeviceState(audioDeviceList, selectedAudioDevice);
        }

        public static /* synthetic */ AudioDeviceState copy$default(AudioDeviceState audioDeviceState, List list, AudioDevice audioDevice, int n, Object object) {
            if ((n & 1) != 0) {
                list = audioDeviceState.audioDeviceList;
            }
            if ((n & 2) != 0) {
                audioDevice = audioDeviceState.selectedAudioDevice;
            }
            return audioDeviceState.copy(list, audioDevice);
        }

        @NotNull
        public String toString() {
            return "AudioDeviceState(audioDeviceList=" + this.audioDeviceList + ", selectedAudioDevice=" + this.selectedAudioDevice + ")";
        }

        public int hashCode() {
            List<AudioDevice> list = this.audioDeviceList;
            AudioDevice audioDevice = this.selectedAudioDevice;
            return (list != null ? ((Object)list).hashCode() : 0) * 31 + (audioDevice != null ? audioDevice.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof AudioDeviceState)) break block3;
                    AudioDeviceState audioDeviceState = (AudioDeviceState)object;
                    if (!Intrinsics.areEqual(this.audioDeviceList, audioDeviceState.audioDeviceList) || !Intrinsics.areEqual((Object)this.selectedAudioDevice, (Object)audioDeviceState.selectedAudioDevice)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R)\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/twilio/audioswitch/AudioSwitch$Companion;", "", "()V", "VERSION", "", "defaultPreferredDeviceList", "", "Ljava/lang/Class;", "Lcom/twilio/audioswitch/AudioDevice;", "getDefaultPreferredDeviceList", "()Ljava/util/List;", "defaultPreferredDeviceList$delegate", "Lkotlin/Lazy;", "audioswitch_release"})
    public static final class Companion {
        private final List<Class<? extends AudioDevice>> getDefaultPreferredDeviceList() {
            Lazy lazy = defaultPreferredDeviceList$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (List)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

