/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.VisibleForTesting;
import com.twilio.audioswitch.AudioDevice;
import com.twilio.audioswitch.AudioDeviceManager;
import com.twilio.audioswitch.android.BluetoothDeviceWrapper;
import com.twilio.audioswitch.android.BluetoothIntentProcessor;
import com.twilio.audioswitch.android.BluetoothIntentProcessorImpl;
import com.twilio.audioswitch.android.Logger;
import com.twilio.audioswitch.android.SystemClockWrapper;
import com.twilio.audioswitch.bluetooth.BluetoothHeadsetConnectionListener;
import com.twilio.audioswitch.bluetooth.BluetoothScoJob;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 M2\u00020\u00012\u00020\u0002:\u0004MNOPB]\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010-\u001a\u00020.J\b\u0010/\u001a\u00020.H\u0002J\u0006\u00100\u001a\u00020.J\b\u00101\u001a\u00020.H\u0002J\u0012\u00102\u001a\u0004\u0018\u0001032\b\u00104\u001a\u0004\u0018\u000105J\n\u00106\u001a\u0004\u0018\u000105H\u0002J\u0006\u00107\u001a\u000208J\b\u00109\u001a\u000208H\u0002J\b\u0010:\u001a\u000208H\u0002J\b\u0010;\u001a\u000208H\u0002J\u0012\u0010<\u001a\u0002082\b\u0010=\u001a\u0004\u0018\u000105H\u0002J\u0010\u0010>\u001a\u0002082\u0006\u0010?\u001a\u00020@H\u0002J\u0018\u0010A\u001a\u00020.2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010B\u001a\u00020CH\u0016J\u0018\u0010D\u001a\u00020.2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020.2\u0006\u0010E\u001a\u00020FH\u0016J\u000e\u0010J\u001a\u00020.2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010K\u001a\u00020.J\u000e\u0010L\u001a\u0004\u0018\u00010@*\u00020CH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u00060\u0017R\u00020\u00008\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR \u0010\u001c\u001a\u00060\u001dR\u00020\u00008\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001e\u0010\u0019\u001a\u0004\b\u001f\u0010 R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010'\u001a\u00020&2\u0006\u0010%\u001a\u00020&8\u0000@@X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b(\u0010\u0019\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager;", "Landroid/bluetooth/BluetoothProfile$ServiceListener;", "Landroid/content/BroadcastReceiver;", "context", "Landroid/content/Context;", "logger", "Lcom/twilio/audioswitch/android/Logger;", "bluetoothAdapter", "Landroid/bluetooth/BluetoothAdapter;", "audioDeviceManager", "Lcom/twilio/audioswitch/AudioDeviceManager;", "headsetListener", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetConnectionListener;", "bluetoothScoHandler", "Landroid/os/Handler;", "systemClockWrapper", "Lcom/twilio/audioswitch/android/SystemClockWrapper;", "bluetoothIntentProcessor", "Lcom/twilio/audioswitch/android/BluetoothIntentProcessor;", "headsetProxy", "Landroid/bluetooth/BluetoothHeadset;", "(Landroid/content/Context;Lcom/twilio/audioswitch/android/Logger;Landroid/bluetooth/BluetoothAdapter;Lcom/twilio/audioswitch/AudioDeviceManager;Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetConnectionListener;Landroid/os/Handler;Lcom/twilio/audioswitch/android/SystemClockWrapper;Lcom/twilio/audioswitch/android/BluetoothIntentProcessor;Landroid/bluetooth/BluetoothHeadset;)V", "disableBluetoothScoJob", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$DisableBluetoothScoJob;", "getDisableBluetoothScoJob$audioswitch_release$annotations", "()V", "getDisableBluetoothScoJob$audioswitch_release", "()Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$DisableBluetoothScoJob;", "enableBluetoothScoJob", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$EnableBluetoothScoJob;", "getEnableBluetoothScoJob$audioswitch_release$annotations", "getEnableBluetoothScoJob$audioswitch_release", "()Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$EnableBluetoothScoJob;", "getHeadsetListener", "()Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetConnectionListener;", "setHeadsetListener", "(Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetConnectionListener;)V", "value", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState;", "headsetState", "getHeadsetState$audioswitch_release$annotations", "getHeadsetState$audioswitch_release", "()Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState;", "setHeadsetState$audioswitch_release", "(Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState;)V", "activate", "", "connect", "deactivate", "disconnect", "getHeadset", "Lcom/twilio/audioswitch/AudioDevice$BluetoothHeadset;", "bluetoothHeadsetName", "", "getHeadsetName", "hasActivationError", "", "hasActiveHeadset", "hasActiveHeadsetChanged", "hasConnectedDevice", "isCorrectIntentAction", "intentAction", "isHeadsetDevice", "deviceWrapper", "Lcom/twilio/audioswitch/android/BluetoothDeviceWrapper;", "onReceive", "intent", "Landroid/content/Intent;", "onServiceConnected", "profile", "", "bluetoothProfile", "Landroid/bluetooth/BluetoothProfile;", "onServiceDisconnected", "start", "stop", "getHeadsetDevice", "Companion", "DisableBluetoothScoJob", "EnableBluetoothScoJob", "HeadsetState", "audioswitch_release"})
public final class BluetoothHeadsetManager
extends BroadcastReceiver
implements BluetoothProfile.ServiceListener {
    @NotNull
    private HeadsetState headsetState;
    @NotNull
    private final EnableBluetoothScoJob enableBluetoothScoJob;
    @NotNull
    private final DisableBluetoothScoJob disableBluetoothScoJob;
    private final Context context;
    private final Logger logger;
    private final BluetoothAdapter bluetoothAdapter;
    @Nullable
    private BluetoothHeadsetConnectionListener headsetListener;
    private final BluetoothIntentProcessor bluetoothIntentProcessor;
    private BluetoothHeadset headsetProxy;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getHeadsetState$audioswitch_release$annotations() {
    }

    @NotNull
    public final HeadsetState getHeadsetState$audioswitch_release() {
        return this.headsetState;
    }

    public final void setHeadsetState$audioswitch_release(@NotNull HeadsetState value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (Intrinsics.areEqual((Object)this.headsetState, (Object)value) ^ true) {
            this.headsetState = value;
            this.logger.d("BluetoothHeadsetManager", "Headset state changed to " + Reflection.getOrCreateKotlinClass(this.headsetState.getClass()).getSimpleName());
            if (Intrinsics.areEqual((Object)value, (Object)HeadsetState.Disconnected.INSTANCE)) {
                this.enableBluetoothScoJob.cancelBluetoothScoJob();
            }
        }
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getEnableBluetoothScoJob$audioswitch_release$annotations() {
    }

    @NotNull
    public final EnableBluetoothScoJob getEnableBluetoothScoJob$audioswitch_release() {
        return this.enableBluetoothScoJob;
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getDisableBluetoothScoJob$audioswitch_release$annotations() {
    }

    @NotNull
    public final DisableBluetoothScoJob getDisableBluetoothScoJob$audioswitch_release() {
        return this.disableBluetoothScoJob;
    }

    public void onServiceConnected(int profile, @NotNull BluetoothProfile bluetoothProfile) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)bluetoothProfile, (String)"bluetoothProfile");
            this.headsetProxy = (BluetoothHeadset)bluetoothProfile;
            List list = ((BluetoothHeadset)bluetoothProfile).getConnectedDevices();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"bluetoothProfile.connectedDevices");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BluetoothDevice device = (BluetoothDevice)element$iv;
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder().append("Bluetooth ");
                BluetoothDevice bluetoothDevice = device;
                Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"device");
                this.logger.d("BluetoothHeadsetManager", stringBuilder.append(bluetoothDevice.getName()).append(" connected").toString());
            }
            if (!this.hasConnectedDevice()) break block2;
            this.connect();
            BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener = this.headsetListener;
            if (bluetoothHeadsetConnectionListener != null) {
                bluetoothHeadsetConnectionListener.onBluetoothHeadsetStateChanged(this.getHeadsetName());
            }
        }
    }

    public void onServiceDisconnected(int profile) {
        block0: {
            this.logger.d("BluetoothHeadsetManager", "Bluetooth disconnected");
            this.setHeadsetState$audioswitch_release(HeadsetState.Disconnected.INSTANCE);
            BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener = this.headsetListener;
            if (bluetoothHeadsetConnectionListener == null) break block0;
            BluetoothHeadsetConnectionListener.DefaultImpls.onBluetoothHeadsetStateChanged$default(bluetoothHeadsetConnectionListener, null, 1, null);
        }
    }

    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        block11: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            if (!this.isCorrectIntentAction(intent.getAction())) break block11;
            BluetoothDeviceWrapper bluetoothDeviceWrapper = this.getHeadsetDevice(intent);
            if (bluetoothDeviceWrapper == null) break block11;
            BluetoothDeviceWrapper bluetoothDeviceWrapper2 = bluetoothDeviceWrapper;
            boolean bl = false;
            boolean bl2 = false;
            BluetoothDeviceWrapper bluetoothDevice = bluetoothDeviceWrapper2;
            boolean bl3 = false;
            int n = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
            boolean bl4 = false;
            boolean bl5 = false;
            int state = n;
            boolean bl6 = false;
            switch (state) {
                case 2: {
                    this.logger.d("BluetoothHeadsetManager", "Bluetooth headset " + bluetoothDevice + " connected");
                    this.connect();
                    BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener = this.headsetListener;
                    if (bluetoothHeadsetConnectionListener != null) {
                        bluetoothHeadsetConnectionListener.onBluetoothHeadsetStateChanged(bluetoothDevice.getName());
                    }
                    break;
                }
                case 0: {
                    this.logger.d("BluetoothHeadsetManager", "Bluetooth headset " + bluetoothDevice + " disconnected");
                    this.disconnect();
                    BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener = this.headsetListener;
                    if (bluetoothHeadsetConnectionListener != null) {
                        BluetoothHeadsetConnectionListener.DefaultImpls.onBluetoothHeadsetStateChanged$default(bluetoothHeadsetConnectionListener, null, 1, null);
                    }
                    break;
                }
                case 12: {
                    this.logger.d("BluetoothHeadsetManager", "Bluetooth audio connected on device " + bluetoothDevice);
                    this.enableBluetoothScoJob.cancelBluetoothScoJob();
                    this.setHeadsetState$audioswitch_release(HeadsetState.AudioActivated.INSTANCE);
                    BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener = this.headsetListener;
                    if (bluetoothHeadsetConnectionListener != null) {
                        BluetoothHeadsetConnectionListener.DefaultImpls.onBluetoothHeadsetStateChanged$default(bluetoothHeadsetConnectionListener, null, 1, null);
                    }
                    break;
                }
                case 10: {
                    this.logger.d("BluetoothHeadsetManager", "Bluetooth audio disconnected on device " + bluetoothDevice);
                    this.disableBluetoothScoJob.cancelBluetoothScoJob();
                    if (this.hasActiveHeadsetChanged()) {
                        this.enableBluetoothScoJob.executeBluetoothScoJob();
                    }
                    BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener = this.headsetListener;
                    if (bluetoothHeadsetConnectionListener != null) {
                        BluetoothHeadsetConnectionListener.DefaultImpls.onBluetoothHeadsetStateChanged$default(bluetoothHeadsetConnectionListener, null, 1, null);
                    }
                    break;
                }
                default: {
                }
            }
        }
    }

    public final void start(@NotNull BluetoothHeadsetConnectionListener headsetListener) {
        Intrinsics.checkNotNullParameter((Object)headsetListener, (String)"headsetListener");
        this.headsetListener = headsetListener;
        this.bluetoothAdapter.getProfileProxy(this.context, (BluetoothProfile.ServiceListener)this, 1);
        this.context.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED"));
        this.context.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED"));
    }

    public final void stop() {
        this.headsetListener = null;
        this.bluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)this.headsetProxy);
        this.context.unregisterReceiver((BroadcastReceiver)this);
    }

    public final void activate() {
        if (Intrinsics.areEqual((Object)this.headsetState, (Object)HeadsetState.Connected.INSTANCE) || Intrinsics.areEqual((Object)this.headsetState, (Object)HeadsetState.AudioActivationError.INSTANCE)) {
            this.enableBluetoothScoJob.executeBluetoothScoJob();
        } else {
            this.logger.w("BluetoothHeadsetManager", "Cannot activate when in the " + Reflection.getOrCreateKotlinClass(this.headsetState.getClass()).getSimpleName() + " state");
        }
    }

    public final void deactivate() {
        if (Intrinsics.areEqual((Object)this.headsetState, (Object)HeadsetState.AudioActivated.INSTANCE)) {
            this.disableBluetoothScoJob.executeBluetoothScoJob();
        } else {
            this.logger.w("BluetoothHeadsetManager", "Cannot deactivate when in the " + Reflection.getOrCreateKotlinClass(this.headsetState.getClass()).getSimpleName() + " state");
        }
    }

    public final boolean hasActivationError() {
        return Intrinsics.areEqual((Object)this.headsetState, (Object)HeadsetState.AudioActivationError.INSTANCE);
    }

    @Nullable
    public final AudioDevice.BluetoothHeadset getHeadset(@Nullable String bluetoothHeadsetName) {
        AudioDevice.BluetoothHeadset bluetoothHeadset;
        if (Intrinsics.areEqual((Object)this.headsetState, (Object)HeadsetState.Disconnected.INSTANCE) ^ true) {
            String headsetName;
            String string = bluetoothHeadsetName;
            if (string == null) {
                string = this.getHeadsetName();
            }
            String string2 = headsetName = string;
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                bluetoothHeadset = new AudioDevice.BluetoothHeadset(it);
            } else {
                bluetoothHeadset = new AudioDevice.BluetoothHeadset(null, 1, null);
            }
        } else {
            bluetoothHeadset = null;
        }
        return bluetoothHeadset;
    }

    private final boolean isCorrectIntentAction(String intentAction) {
        return Intrinsics.areEqual((Object)intentAction, (Object)"android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED") || Intrinsics.areEqual((Object)intentAction, (Object)"android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
    }

    private final void connect() {
        if (!this.hasActiveHeadset()) {
            this.setHeadsetState$audioswitch_release(HeadsetState.Connected.INSTANCE);
        }
    }

    private final void disconnect() {
        this.setHeadsetState$audioswitch_release(this.hasActiveHeadset() ? (HeadsetState)HeadsetState.AudioActivated.INSTANCE : (this.hasConnectedDevice() ? (HeadsetState)HeadsetState.Connected.INSTANCE : (HeadsetState)HeadsetState.Disconnected.INSTANCE));
    }

    private final boolean hasActiveHeadsetChanged() {
        return Intrinsics.areEqual((Object)this.headsetState, (Object)HeadsetState.AudioActivated.INSTANCE) && this.hasConnectedDevice() && !this.hasActiveHeadset();
    }

    private final String getHeadsetName() {
        String string;
        BluetoothHeadset bluetoothHeadset = this.headsetProxy;
        if (bluetoothHeadset != null) {
            BluetoothHeadset bluetoothHeadset2 = bluetoothHeadset;
            boolean bl = false;
            boolean bl2 = false;
            BluetoothHeadset proxy = bluetoothHeadset2;
            boolean bl3 = false;
            List list = proxy.getConnectedDevices();
            if (list != null) {
                List list2 = list;
                boolean bl4 = false;
                boolean bl5 = false;
                List devices = list2;
                boolean bl6 = false;
                if (devices.size() > 1 && this.hasActiveHeadset()) {
                    Object v2;
                    block9: {
                        Iterable iterable = devices;
                        boolean bl7 = false;
                        Iterable iterable2 = iterable;
                        boolean bl8 = false;
                        for (Object t : iterable2) {
                            BluetoothDevice it = (BluetoothDevice)t;
                            boolean bl9 = false;
                            if (!proxy.isAudioConnected(it)) continue;
                            v2 = t;
                            break block9;
                        }
                        v2 = null;
                    }
                    BluetoothDevice bluetoothDevice = v2;
                    String device = bluetoothDevice != null ? bluetoothDevice.getName() : null;
                    this.logger.d("BluetoothHeadsetManager", "Device size > 1 with device name: " + device);
                    string = device;
                } else if (devices.size() == 1) {
                    Object object = CollectionsKt.first((List)devices);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"devices.first()");
                    String device = ((BluetoothDevice)object).getName();
                    this.logger.d("BluetoothHeadsetManager", "Device size 1 with device name: " + device);
                    string = device;
                } else {
                    this.logger.d("BluetoothHeadsetManager", "Device size 0");
                    string = null;
                }
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasActiveHeadset() {
        boolean bl;
        BluetoothHeadset bluetoothHeadset;
        block3: {
            BluetoothHeadset bluetoothHeadset2 = this.headsetProxy;
            bluetoothHeadset = bluetoothHeadset2;
            if (bluetoothHeadset2 == null) return false;
            BluetoothHeadset bluetoothHeadset3 = bluetoothHeadset;
            boolean bl2 = false;
            boolean bl3 = false;
            BluetoothHeadset proxy = bluetoothHeadset3;
            boolean bl4 = false;
            List list = proxy.getConnectedDevices();
            if (list == null) return false;
            List list2 = list;
            boolean bl5 = false;
            boolean bl6 = false;
            List devices = list2;
            boolean bl7 = false;
            Iterable $this$any$iv = devices;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BluetoothDevice it = (BluetoothDevice)element$iv;
                    boolean bl8 = false;
                    if (!proxy.isAudioConnected(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        Boolean bl9 = bl;
        bluetoothHeadset = bl9;
        if (bl9 == null) return false;
        boolean bl10 = bluetoothHeadset.booleanValue();
        return bl10;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasConnectedDevice() {
        BluetoothHeadset bluetoothHeadset = this.headsetProxy;
        BluetoothHeadset bluetoothHeadset2 = bluetoothHeadset;
        if (bluetoothHeadset == null) return false;
        BluetoothHeadset bluetoothHeadset3 = bluetoothHeadset2;
        boolean bl = false;
        boolean bl2 = false;
        BluetoothHeadset proxy = bluetoothHeadset3;
        boolean bl3 = false;
        List list = proxy.getConnectedDevices();
        if (list == null) return false;
        List list2 = list;
        boolean bl4 = false;
        boolean bl5 = false;
        List devices = list2;
        boolean bl6 = false;
        Collection collection = devices;
        boolean bl7 = false;
        Boolean bl8 = !collection.isEmpty();
        bluetoothHeadset2 = bl8;
        if (bl8 == null) return false;
        boolean bl9 = bluetoothHeadset2.booleanValue();
        return bl9;
    }

    private final BluetoothDeviceWrapper getHeadsetDevice(Intent $this$getHeadsetDevice) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper;
        BluetoothDeviceWrapper bluetoothDeviceWrapper2 = this.bluetoothIntentProcessor.getBluetoothDevice($this$getHeadsetDevice);
        if (bluetoothDeviceWrapper2 != null) {
            BluetoothDeviceWrapper bluetoothDeviceWrapper3 = bluetoothDeviceWrapper2;
            boolean bl = false;
            boolean bl2 = false;
            BluetoothDeviceWrapper device = bluetoothDeviceWrapper3;
            boolean bl3 = false;
            bluetoothDeviceWrapper = this.isHeadsetDevice(device) ? device : null;
        } else {
            bluetoothDeviceWrapper = null;
        }
        return bluetoothDeviceWrapper;
    }

    private final boolean isHeadsetDevice(BluetoothDeviceWrapper deviceWrapper) {
        boolean bl;
        Integer n = deviceWrapper.getDeviceClass();
        if (n != null) {
            Integer n2 = n;
            boolean bl2 = false;
            boolean bl3 = false;
            int deviceClass = ((Number)n2).intValue();
            boolean bl4 = false;
            bl = deviceClass == 1032 || deviceClass == 1028 || deviceClass == 1056 || deviceClass == 1048 || deviceClass == 7936;
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final BluetoothHeadsetConnectionListener getHeadsetListener() {
        return this.headsetListener;
    }

    public final void setHeadsetListener(@Nullable BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener) {
        this.headsetListener = bluetoothHeadsetConnectionListener;
    }

    @VisibleForTesting(otherwise=2)
    public BluetoothHeadsetManager(@NotNull Context context, @NotNull Logger logger, @NotNull BluetoothAdapter bluetoothAdapter, @NotNull AudioDeviceManager audioDeviceManager, @Nullable BluetoothHeadsetConnectionListener headsetListener, @NotNull Handler bluetoothScoHandler, @NotNull SystemClockWrapper systemClockWrapper, @NotNull BluetoothIntentProcessor bluetoothIntentProcessor, @Nullable BluetoothHeadset headsetProxy) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)bluetoothAdapter, (String)"bluetoothAdapter");
        Intrinsics.checkNotNullParameter((Object)audioDeviceManager, (String)"audioDeviceManager");
        Intrinsics.checkNotNullParameter((Object)bluetoothScoHandler, (String)"bluetoothScoHandler");
        Intrinsics.checkNotNullParameter((Object)systemClockWrapper, (String)"systemClockWrapper");
        Intrinsics.checkNotNullParameter((Object)bluetoothIntentProcessor, (String)"bluetoothIntentProcessor");
        this.context = context;
        this.logger = logger;
        this.bluetoothAdapter = bluetoothAdapter;
        this.headsetListener = headsetListener;
        this.bluetoothIntentProcessor = bluetoothIntentProcessor;
        this.headsetProxy = headsetProxy;
        this.headsetState = HeadsetState.Disconnected.INSTANCE;
        this.enableBluetoothScoJob = new EnableBluetoothScoJob(this.logger, audioDeviceManager, bluetoothScoHandler, systemClockWrapper);
        this.disableBluetoothScoJob = new DisableBluetoothScoJob(this.logger, audioDeviceManager, bluetoothScoHandler, systemClockWrapper);
    }

    public /* synthetic */ BluetoothHeadsetManager(Context context, Logger logger, BluetoothAdapter bluetoothAdapter, AudioDeviceManager audioDeviceManager, BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener, Handler handler, SystemClockWrapper systemClockWrapper, BluetoothIntentProcessor bluetoothIntentProcessor, BluetoothHeadset bluetoothHeadset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bluetoothHeadsetConnectionListener = null;
        }
        if ((n & 0x20) != 0) {
            handler = new Handler(Looper.getMainLooper());
        }
        if ((n & 0x40) != 0) {
            systemClockWrapper = new SystemClockWrapper();
        }
        if ((n & 0x80) != 0) {
            bluetoothIntentProcessor = new BluetoothIntentProcessorImpl();
        }
        if ((n & 0x100) != 0) {
            bluetoothHeadset = null;
        }
        this(context, logger, bluetoothAdapter, audioDeviceManager, bluetoothHeadsetConnectionListener, handler, systemClockWrapper, bluetoothIntentProcessor, bluetoothHeadset);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b1\u0018\u00002\u00020\u0001:\u0005\u0003\u0004\u0005\u0006\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0005\b\t\n\u000b\f\u00a8\u0006\r"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState;", "", "()V", "AudioActivated", "AudioActivating", "AudioActivationError", "Connected", "Disconnected", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState$Disconnected;", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState$Connected;", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState$AudioActivating;", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState$AudioActivationError;", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState$AudioActivated;", "audioswitch_release"})
    @VisibleForTesting(otherwise=2)
    public static abstract class HeadsetState {
        private HeadsetState() {
        }

        public /* synthetic */ HeadsetState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState$Disconnected;", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState;", "()V", "audioswitch_release"})
        public static final class Disconnected
        extends HeadsetState {
            @NotNull
            public static final Disconnected INSTANCE;

            private Disconnected() {
                super(null);
            }

            static {
                Disconnected disconnected;
                INSTANCE = disconnected = new Disconnected();
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState$Connected;", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState;", "()V", "audioswitch_release"})
        public static final class Connected
        extends HeadsetState {
            @NotNull
            public static final Connected INSTANCE;

            private Connected() {
                super(null);
            }

            static {
                Connected connected;
                INSTANCE = connected = new Connected();
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState$AudioActivating;", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState;", "()V", "audioswitch_release"})
        public static final class AudioActivating
        extends HeadsetState {
            @NotNull
            public static final AudioActivating INSTANCE;

            private AudioActivating() {
                super(null);
            }

            static {
                AudioActivating audioActivating;
                INSTANCE = audioActivating = new AudioActivating();
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState$AudioActivationError;", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState;", "()V", "audioswitch_release"})
        public static final class AudioActivationError
        extends HeadsetState {
            @NotNull
            public static final AudioActivationError INSTANCE;

            private AudioActivationError() {
                super(null);
            }

            static {
                AudioActivationError audioActivationError;
                INSTANCE = audioActivationError = new AudioActivationError();
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState$AudioActivated;", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$HeadsetState;", "()V", "audioswitch_release"})
        public static final class AudioActivated
        extends HeadsetState {
            @NotNull
            public static final AudioActivated INSTANCE;

            private AudioActivated() {
                super(null);
            }

            static {
                AudioActivated audioActivated;
                INSTANCE = audioActivated = new AudioActivated();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0081\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$EnableBluetoothScoJob;", "Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob;", "logger", "Lcom/twilio/audioswitch/android/Logger;", "audioDeviceManager", "Lcom/twilio/audioswitch/AudioDeviceManager;", "bluetoothScoHandler", "Landroid/os/Handler;", "systemClockWrapper", "Lcom/twilio/audioswitch/android/SystemClockWrapper;", "(Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager;Lcom/twilio/audioswitch/android/Logger;Lcom/twilio/audioswitch/AudioDeviceManager;Landroid/os/Handler;Lcom/twilio/audioswitch/android/SystemClockWrapper;)V", "scoAction", "", "scoTimeOutAction", "audioswitch_release"})
    @VisibleForTesting(otherwise=2)
    public final class EnableBluetoothScoJob
    extends BluetoothScoJob {
        private final Logger logger;
        private final AudioDeviceManager audioDeviceManager;

        @Override
        protected void scoAction() {
            this.logger.d("BluetoothHeadsetManager", "Attempting to enable bluetooth SCO");
            this.audioDeviceManager.enableBluetoothSco(true);
            BluetoothHeadsetManager.this.setHeadsetState$audioswitch_release(HeadsetState.AudioActivating.INSTANCE);
        }

        @Override
        public void scoTimeOutAction() {
            block0: {
                BluetoothHeadsetManager.this.setHeadsetState$audioswitch_release(HeadsetState.AudioActivationError.INSTANCE);
                BluetoothHeadsetConnectionListener bluetoothHeadsetConnectionListener = BluetoothHeadsetManager.this.getHeadsetListener();
                if (bluetoothHeadsetConnectionListener == null) break block0;
                bluetoothHeadsetConnectionListener.onBluetoothHeadsetActivationError();
            }
        }

        public EnableBluetoothScoJob(@NotNull Logger logger, @NotNull AudioDeviceManager audioDeviceManager, @NotNull Handler bluetoothScoHandler, SystemClockWrapper systemClockWrapper) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)audioDeviceManager, (String)"audioDeviceManager");
            Intrinsics.checkNotNullParameter((Object)bluetoothScoHandler, (String)"bluetoothScoHandler");
            Intrinsics.checkNotNullParameter((Object)systemClockWrapper, (String)"systemClockWrapper");
            super(logger, bluetoothScoHandler, systemClockWrapper);
            this.logger = logger;
            this.audioDeviceManager = audioDeviceManager;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0081\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$DisableBluetoothScoJob;", "Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob;", "logger", "Lcom/twilio/audioswitch/android/Logger;", "audioDeviceManager", "Lcom/twilio/audioswitch/AudioDeviceManager;", "bluetoothScoHandler", "Landroid/os/Handler;", "systemClockWrapper", "Lcom/twilio/audioswitch/android/SystemClockWrapper;", "(Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager;Lcom/twilio/audioswitch/android/Logger;Lcom/twilio/audioswitch/AudioDeviceManager;Landroid/os/Handler;Lcom/twilio/audioswitch/android/SystemClockWrapper;)V", "scoAction", "", "scoTimeOutAction", "audioswitch_release"})
    @VisibleForTesting(otherwise=2)
    public final class DisableBluetoothScoJob
    extends BluetoothScoJob {
        private final Logger logger;
        private final AudioDeviceManager audioDeviceManager;

        @Override
        protected void scoAction() {
            this.logger.d("BluetoothHeadsetManager", "Attempting to disable bluetooth SCO");
            this.audioDeviceManager.enableBluetoothSco(false);
            BluetoothHeadsetManager.this.setHeadsetState$audioswitch_release(HeadsetState.Connected.INSTANCE);
        }

        @Override
        public void scoTimeOutAction() {
            BluetoothHeadsetManager.this.setHeadsetState$audioswitch_release(HeadsetState.AudioActivationError.INSTANCE);
        }

        public DisableBluetoothScoJob(@NotNull Logger logger, @NotNull AudioDeviceManager audioDeviceManager, @NotNull Handler bluetoothScoHandler, SystemClockWrapper systemClockWrapper) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)audioDeviceManager, (String)"audioDeviceManager");
            Intrinsics.checkNotNullParameter((Object)bluetoothScoHandler, (String)"bluetoothScoHandler");
            Intrinsics.checkNotNullParameter((Object)systemClockWrapper, (String)"systemClockWrapper");
            super(logger, bluetoothScoHandler, systemClockWrapper);
            this.logger = logger;
            this.audioDeviceManager = audioDeviceManager;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager$Companion;", "", "()V", "newInstance", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager;", "context", "Landroid/content/Context;", "logger", "Lcom/twilio/audioswitch/android/Logger;", "bluetoothAdapter", "Landroid/bluetooth/BluetoothAdapter;", "audioDeviceManager", "Lcom/twilio/audioswitch/AudioDeviceManager;", "newInstance$audioswitch_release", "audioswitch_release"})
    public static final class Companion {
        @Nullable
        public final BluetoothHeadsetManager newInstance$audioswitch_release(@NotNull Context context, @NotNull Logger logger, @Nullable BluetoothAdapter bluetoothAdapter, @NotNull AudioDeviceManager audioDeviceManager) {
            BluetoothHeadsetManager bluetoothHeadsetManager;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)audioDeviceManager, (String)"audioDeviceManager");
            BluetoothAdapter bluetoothAdapter2 = bluetoothAdapter;
            if (bluetoothAdapter2 != null) {
                BluetoothAdapter bluetoothAdapter3 = bluetoothAdapter2;
                boolean bl = false;
                boolean bl2 = false;
                BluetoothAdapter adapter = bluetoothAdapter3;
                boolean bl3 = false;
                bluetoothHeadsetManager = new BluetoothHeadsetManager(context, logger, adapter, audioDeviceManager, null, null, null, null, null, 496, null);
            } else {
                Companion companion = this;
                boolean bl = false;
                boolean bl4 = false;
                Companion $this$run = companion;
                boolean bl5 = false;
                logger.d("BluetoothHeadsetManager", "Bluetooth is not supported on this device");
                bluetoothHeadsetManager = null;
            }
            return bluetoothHeadsetManager;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

