/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch.selection;

import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.media.AudioManager;
import com.twilio.audioswitch.android.BuildWrapper;
import com.twilio.audioswitch.android.LogWrapper;
import com.twilio.audioswitch.bluetooth.BluetoothHeadsetConnectionListener;
import com.twilio.audioswitch.bluetooth.BluetoothHeadsetManager;
import com.twilio.audioswitch.selection.AudioDevice;
import com.twilio.audioswitch.selection.AudioDeviceManager;
import com.twilio.audioswitch.selection.AudioDeviceSelector$WhenMappings;
import com.twilio.audioswitch.selection.AudioFocusRequestWrapper;
import com.twilio.audioswitch.wired.WiredDeviceConnectionListener;
import com.twilio.audioswitch.wired.WiredHeadsetReceiver;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001CB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B)\b\u0010\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0006\u00107\u001a\u00020\u0016J\u0010\u00107\u001a\u00020\u00162\u0006\u00108\u001a\u00020\u0011H\u0002J\b\u00109\u001a\u00020\u0016H\u0002J\u0006\u0010:\u001a\u00020\u0016J\u0014\u0010;\u001a\u00020\u00162\n\b\u0002\u0010<\u001a\u0004\u0018\u00010=H\u0002J\u0010\u0010>\u001a\u00020\u00162\b\u00108\u001a\u0004\u0018\u00010\u0011JJ\u0010?\u001a\u00020\u00162B\u0010@\u001a>\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0015\u0012\u0013\u0018\u00010\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u000fj\u0002`\u0017J\u0006\u0010A\u001a\u00020\u0016J\u0016\u0010B\u001a\u0002062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002RZ\u0010\u000e\u001aB\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0015\u0012\u0013\u0018\u00010\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u000fj\u0004\u0018\u0001`\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0010\u0010#\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u00110%j\b\u0012\u0004\u0012\u00020\u0011`&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0010\u0010)\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\u00020+X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0010\u00100\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\u000202X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u000e\u00105\u001a\u000206X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/twilio/audioswitch/selection/AudioDeviceSelector;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "logger", "Lcom/twilio/audioswitch/android/LogWrapper;", "audioDeviceManager", "Lcom/twilio/audioswitch/selection/AudioDeviceManager;", "wiredHeadsetReceiver", "Lcom/twilio/audioswitch/wired/WiredHeadsetReceiver;", "headsetManager", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager;", "(Lcom/twilio/audioswitch/android/LogWrapper;Lcom/twilio/audioswitch/selection/AudioDeviceManager;Lcom/twilio/audioswitch/wired/WiredHeadsetReceiver;Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager;)V", "audioDeviceChangeListener", "Lkotlin/Function2;", "", "Lcom/twilio/audioswitch/selection/AudioDevice;", "Lkotlin/ParameterName;", "name", "audioDevices", "selectedAudioDevice", "", "Lcom/twilio/audioswitch/selection/AudioDeviceChangeListener;", "getAudioDeviceChangeListener$audioswitch_release", "()Lkotlin/jvm/functions/Function2;", "setAudioDeviceChangeListener$audioswitch_release", "(Lkotlin/jvm/functions/Function2;)V", "availableAudioDevices", "getAvailableAudioDevices", "()Ljava/util/List;", "bluetoothDeviceConnectionListener", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetConnectionListener;", "getBluetoothDeviceConnectionListener$audioswitch_release", "()Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetConnectionListener;", "bluetoothHeadsetManager", "mutableAudioDevices", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getSelectedAudioDevice", "()Lcom/twilio/audioswitch/selection/AudioDevice;", "selectedDevice", "state", "Lcom/twilio/audioswitch/selection/AudioDeviceSelector$State;", "getState$audioswitch_release", "()Lcom/twilio/audioswitch/selection/AudioDeviceSelector$State;", "setState$audioswitch_release", "(Lcom/twilio/audioswitch/selection/AudioDeviceSelector$State;)V", "userSelectedDevice", "wiredDeviceConnectionListener", "Lcom/twilio/audioswitch/wired/WiredDeviceConnectionListener;", "getWiredDeviceConnectionListener$audioswitch_release", "()Lcom/twilio/audioswitch/wired/WiredDeviceConnectionListener;", "wiredHeadsetAvailable", "", "activate", "audioDevice", "closeListeners", "deactivate", "enumerateDevices", "bluetoothHeadsetName", "", "selectDevice", "start", "listener", "stop", "userSelectedDevicePresent", "State", "audioswitch_release"})
public final class AudioDeviceSelector {
    private LogWrapper logger;
    private final AudioDeviceManager audioDeviceManager;
    private final WiredHeadsetReceiver wiredHeadsetReceiver;
    @Nullable
    private Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> audioDeviceChangeListener;
    private AudioDevice selectedDevice;
    private AudioDevice userSelectedDevice;
    private boolean wiredHeadsetAvailable;
    private final ArrayList<AudioDevice> mutableAudioDevices;
    private BluetoothHeadsetManager bluetoothHeadsetManager;
    @NotNull
    private State state;
    @NotNull
    private final BluetoothHeadsetConnectionListener bluetoothDeviceConnectionListener;
    @NotNull
    private final WiredDeviceConnectionListener wiredDeviceConnectionListener;
    @NotNull
    private final List<AudioDevice> availableAudioDevices;

    @Nullable
    public final Function2<List<? extends AudioDevice>, AudioDevice, Unit> getAudioDeviceChangeListener$audioswitch_release() {
        return this.audioDeviceChangeListener;
    }

    public final void setAudioDeviceChangeListener$audioswitch_release(@Nullable Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> function2) {
        this.audioDeviceChangeListener = function2;
    }

    @NotNull
    public final State getState$audioswitch_release() {
        return this.state;
    }

    public final void setState$audioswitch_release(@NotNull State state) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"<set-?>");
        this.state = state;
    }

    @NotNull
    public final BluetoothHeadsetConnectionListener getBluetoothDeviceConnectionListener$audioswitch_release() {
        return this.bluetoothDeviceConnectionListener;
    }

    @NotNull
    public final WiredDeviceConnectionListener getWiredDeviceConnectionListener$audioswitch_release() {
        return this.wiredDeviceConnectionListener;
    }

    public final void start(@NotNull Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        this.audioDeviceChangeListener = listener;
        switch (AudioDeviceSelector$WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                BluetoothHeadsetManager bluetoothHeadsetManager = this.bluetoothHeadsetManager;
                if (bluetoothHeadsetManager != null) {
                    bluetoothHeadsetManager.start(this.bluetoothDeviceConnectionListener);
                }
                this.wiredHeadsetReceiver.start(this.wiredDeviceConnectionListener);
                AudioDeviceSelector.enumerateDevices$default(this, null, 1, null);
                this.state = State.STARTED;
                break;
            }
            default: {
                this.logger.d("AudioDeviceSelector", "Redundant start() invocation while already in the started or activated state");
            }
        }
    }

    public final void stop() {
        switch (AudioDeviceSelector$WhenMappings.$EnumSwitchMapping$1[this.state.ordinal()]) {
            case 1: {
                this.deactivate();
                this.closeListeners();
                break;
            }
            case 2: {
                this.closeListeners();
                break;
            }
            case 3: {
                this.logger.d("AudioDeviceSelector", "Redundant stop() invocation while already in the stopped state");
                break;
            }
        }
    }

    public final void activate() {
        switch (AudioDeviceSelector$WhenMappings.$EnumSwitchMapping$2[this.state.ordinal()]) {
            case 1: {
                this.audioDeviceManager.cacheAudioState();
                this.audioDeviceManager.mute(false);
                this.audioDeviceManager.setAudioFocus();
                AudioDevice audioDevice = this.selectedDevice;
                if (audioDevice != null) {
                    AudioDevice audioDevice2 = audioDevice;
                    boolean bl = false;
                    boolean bl2 = false;
                    AudioDevice it = audioDevice2;
                    boolean bl3 = false;
                    this.activate(it);
                }
                this.state = State.ACTIVATED;
                break;
            }
            case 2: {
                AudioDevice audioDevice = this.selectedDevice;
                if (audioDevice != null) {
                    AudioDevice audioDevice3 = audioDevice;
                    boolean bl = false;
                    boolean bl4 = false;
                    AudioDevice it = audioDevice3;
                    boolean bl5 = false;
                    this.activate(it);
                }
                break;
            }
            case 3: {
                throw (Throwable)new IllegalStateException();
            }
        }
    }

    private final void activate(AudioDevice audioDevice) {
        block2: {
            AudioDevice audioDevice2;
            block3: {
                block1: {
                    audioDevice2 = audioDevice;
                    if (!(audioDevice2 instanceof AudioDevice.BluetoothHeadset)) break block1;
                    this.audioDeviceManager.enableSpeakerphone(false);
                    BluetoothHeadsetManager bluetoothHeadsetManager = this.bluetoothHeadsetManager;
                    if (bluetoothHeadsetManager == null) break block2;
                    bluetoothHeadsetManager.activate();
                    break block2;
                }
                if (!(audioDevice2 instanceof AudioDevice.Earpiece) && !(audioDevice2 instanceof AudioDevice.WiredHeadset)) break block3;
                this.audioDeviceManager.enableSpeakerphone(false);
                BluetoothHeadsetManager bluetoothHeadsetManager = this.bluetoothHeadsetManager;
                if (bluetoothHeadsetManager == null) break block2;
                bluetoothHeadsetManager.deactivate();
                break block2;
            }
            if (!(audioDevice2 instanceof AudioDevice.Speakerphone)) break block2;
            this.audioDeviceManager.enableSpeakerphone(true);
            BluetoothHeadsetManager bluetoothHeadsetManager = this.bluetoothHeadsetManager;
            if (bluetoothHeadsetManager != null) {
                bluetoothHeadsetManager.deactivate();
            }
        }
    }

    public final void deactivate() {
        switch (AudioDeviceSelector$WhenMappings.$EnumSwitchMapping$3[this.state.ordinal()]) {
            case 1: {
                BluetoothHeadsetManager bluetoothHeadsetManager = this.bluetoothHeadsetManager;
                if (bluetoothHeadsetManager != null) {
                    bluetoothHeadsetManager.deactivate();
                }
                this.audioDeviceManager.restoreAudioState();
                this.state = State.STARTED;
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
    }

    public final void selectDevice(@Nullable AudioDevice audioDevice) {
        if (Intrinsics.areEqual((Object)this.selectedDevice, (Object)audioDevice) ^ true) {
            this.userSelectedDevice = audioDevice;
            AudioDeviceSelector.enumerateDevices$default(this, null, 1, null);
        }
    }

    @Nullable
    public final AudioDevice getSelectedAudioDevice() {
        return this.selectedDevice;
    }

    @NotNull
    public final List<AudioDevice> getAvailableAudioDevices() {
        return this.availableAudioDevices;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void enumerateDevices(String bluetoothHeadsetName) {
        block13: {
            block11: {
                block12: {
                    block10: {
                        this.mutableAudioDevices.clear();
                        v0 /* !! */  = this.bluetoothHeadsetManager;
                        if (v0 /* !! */  != null && (v0 /* !! */  = v0 /* !! */ .getHeadset(bluetoothHeadsetName)) != null) {
                            var2_2 = v0 /* !! */ ;
                            var3_3 = false;
                            var4_4 = false;
                            it /* !! */  = var2_2;
                            $i$a$-let-AudioDeviceSelector$enumerateDevices$1 = false;
                            this.mutableAudioDevices.add((AudioDevice)it /* !! */ );
                        }
                        if (this.wiredHeadsetAvailable) {
                            this.mutableAudioDevices.add(new AudioDevice.WiredHeadset(null, 1, null));
                        }
                        if (this.audioDeviceManager.hasEarpiece() && !this.wiredHeadsetAvailable) {
                            this.mutableAudioDevices.add(new AudioDevice.Earpiece(null, 1, null));
                        }
                        if (this.audioDeviceManager.hasSpeakerphone()) {
                            this.mutableAudioDevices.add(new AudioDevice.Speakerphone(null, 1, null));
                        }
                        this.logger.d("AudioDeviceSelector", "Available AudioDevice list updated: " + this.availableAudioDevices);
                        if (!this.userSelectedDevicePresent((List<? extends AudioDevice>)this.mutableAudioDevices)) {
                            this.userSelectedDevice = null;
                        }
                        if (this.userSelectedDevice == null || !this.userSelectedDevicePresent((List<? extends AudioDevice>)this.mutableAudioDevices)) break block10;
                        v1 /* !! */  = this.userSelectedDevice;
                        break block11;
                    }
                    if (this.mutableAudioDevices.size() <= 0) break block12;
                    v2 = this.mutableAudioDevices.get(0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"mutableAudioDevices[0]");
                    firstAudioDevice = v2;
                    if (!(firstAudioDevice instanceof AudioDevice.BluetoothHeadset)) ** GOTO lbl-1000
                    v3 = this.bluetoothHeadsetManager;
                    if (v3 == null) ** GOTO lbl-1000
                    if (v3.hasActivationError()) {
                        v1 /* !! */  = this.mutableAudioDevices.get(1);
                    } else lbl-1000:
                    // 3 sources

                    {
                        v1 /* !! */  = var2_2;
                    }
                    break block11;
                }
                v1 /* !! */  = this.selectedDevice = null;
            }
            if (this.state == State.ACTIVATED) {
                this.activate();
            }
            v4 = this.audioDeviceChangeListener;
            if (v4 == null) break block13;
            var2_2 = v4;
            var3_3 = false;
            var4_4 = false;
            listener = var2_2;
            $i$a$-let-AudioDeviceSelector$enumerateDevices$2 = false;
            v5 = this.selectedDevice;
            if (v5 != null) {
                var7_7 = v5;
                var8_9 = false;
                var9_11 = false;
                selectedDevice = var7_7;
                $i$a$-let-AudioDeviceSelector$enumerateDevices$2$1 = false;
                listener.invoke(this.mutableAudioDevices, (Object)selectedDevice);
            } else {
                var7_8 = this;
                var8_10 = false;
                var9_12 = false;
                $this$run = var7_8;
                $i$a$-run-AudioDeviceSelector$enumerateDevices$2$2 = false;
                listener.invoke($this$run.mutableAudioDevices, null);
            }
        }
    }

    static /* synthetic */ void enumerateDevices$default(AudioDeviceSelector audioDeviceSelector, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        audioDeviceSelector.enumerateDevices(string);
    }

    private final boolean userSelectedDevicePresent(List<? extends AudioDevice> audioDevices) {
        for (AudioDevice audioDevice : audioDevices) {
            if (!Intrinsics.areEqual((Object)audioDevice, (Object)this.userSelectedDevice)) continue;
            return true;
        }
        return false;
    }

    private final void closeListeners() {
        BluetoothHeadsetManager bluetoothHeadsetManager = this.bluetoothHeadsetManager;
        if (bluetoothHeadsetManager != null) {
            bluetoothHeadsetManager.stop();
        }
        this.wiredHeadsetReceiver.stop();
        this.audioDeviceChangeListener = null;
        this.state = State.STOPPED;
    }

    public AudioDeviceSelector(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.logger = new LogWrapper();
        this.mutableAudioDevices = new ArrayList();
        this.state = State.STOPPED;
        this.bluetoothDeviceConnectionListener = new BluetoothHeadsetConnectionListener(this){
            final /* synthetic */ AudioDeviceSelector this$0;

            public void onBluetoothHeadsetStateChanged(@Nullable String headsetName) {
                AudioDeviceSelector.access$enumerateDevices(this.this$0, headsetName);
            }

            public void onBluetoothHeadsetActivationError() {
                if (AudioDeviceSelector.access$getUserSelectedDevice$p(this.this$0) instanceof AudioDevice.BluetoothHeadset) {
                    AudioDeviceSelector.access$setUserSelectedDevice$p(this.this$0, null);
                }
                AudioDeviceSelector.enumerateDevices$default(this.this$0, null, 1, null);
            }
            {
                this.this$0 = $outer;
            }
        };
        this.wiredDeviceConnectionListener = new WiredDeviceConnectionListener(this){
            final /* synthetic */ AudioDeviceSelector this$0;

            public void onDeviceConnected() {
                AudioDeviceSelector.access$setWiredHeadsetAvailable$p(this.this$0, true);
                AudioDeviceSelector.access$getLogger$p(this.this$0).d("AudioDeviceSelector", "Wired Headset available");
                if (this.this$0.getState$audioswitch_release() == State.ACTIVATED) {
                    AudioDeviceSelector.access$setUserSelectedDevice$p(this.this$0, new AudioDevice.WiredHeadset(null, 1, null));
                }
                AudioDeviceSelector.enumerateDevices$default(this.this$0, null, 1, null);
            }

            public void onDeviceDisconnected() {
                AudioDeviceSelector.access$setWiredHeadsetAvailable$p(this.this$0, false);
                AudioDeviceSelector.enumerateDevices$default(this.this$0, null, 1, null);
            }
            {
                this.this$0 = $outer;
            }
        };
        this.availableAudioDevices = this.mutableAudioDevices;
        Object object = context.getSystemService("audio");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.media.AudioManager");
        }
        AudioManager audioManager = (AudioManager)object;
        LogWrapper logger = new LogWrapper();
        AudioDeviceManager audioDeviceManager = new AudioDeviceManager(context, logger, audioManager, new BuildWrapper(), new AudioFocusRequestWrapper());
        this.logger = logger;
        this.audioDeviceManager = audioDeviceManager;
        this.wiredHeadsetReceiver = new WiredHeadsetReceiver(context, logger);
        this.bluetoothHeadsetManager = BluetoothHeadsetManager.Companion.newInstance$audioswitch_release(context, logger, BluetoothAdapter.getDefaultAdapter(), audioDeviceManager);
    }

    public AudioDeviceSelector(@NotNull LogWrapper logger, @NotNull AudioDeviceManager audioDeviceManager, @NotNull WiredHeadsetReceiver wiredHeadsetReceiver, @Nullable BluetoothHeadsetManager headsetManager) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)audioDeviceManager, (String)"audioDeviceManager");
        Intrinsics.checkParameterIsNotNull((Object)((Object)wiredHeadsetReceiver), (String)"wiredHeadsetReceiver");
        this.logger = new LogWrapper();
        this.mutableAudioDevices = new ArrayList();
        this.state = State.STOPPED;
        this.bluetoothDeviceConnectionListener = new /* invalid duplicate definition of identical inner class */;
        this.wiredDeviceConnectionListener = new /* invalid duplicate definition of identical inner class */;
        this.availableAudioDevices = this.mutableAudioDevices;
        this.logger = logger;
        this.audioDeviceManager = audioDeviceManager;
        this.wiredHeadsetReceiver = wiredHeadsetReceiver;
        this.bluetoothHeadsetManager = headsetManager;
    }

    public static final /* synthetic */ void access$enumerateDevices(AudioDeviceSelector $this, String bluetoothHeadsetName) {
        $this.enumerateDevices(bluetoothHeadsetName);
    }

    public static final /* synthetic */ AudioDevice access$getUserSelectedDevice$p(AudioDeviceSelector $this) {
        return $this.userSelectedDevice;
    }

    public static final /* synthetic */ void access$setUserSelectedDevice$p(AudioDeviceSelector $this, AudioDevice audioDevice) {
        $this.userSelectedDevice = audioDevice;
    }

    public static final /* synthetic */ boolean access$getWiredHeadsetAvailable$p(AudioDeviceSelector $this) {
        return $this.wiredHeadsetAvailable;
    }

    public static final /* synthetic */ void access$setWiredHeadsetAvailable$p(AudioDeviceSelector $this, boolean bl) {
        $this.wiredHeadsetAvailable = bl;
    }

    public static final /* synthetic */ LogWrapper access$getLogger$p(AudioDeviceSelector $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$setLogger$p(AudioDeviceSelector $this, LogWrapper logWrapper) {
        $this.logger = logWrapper;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/twilio/audioswitch/selection/AudioDeviceSelector$State;", "", "(Ljava/lang/String;I)V", "STARTED", "ACTIVATED", "STOPPED", "audioswitch_release"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State STARTED;
        public static final /* enum */ State ACTIVATED;
        public static final /* enum */ State STOPPED;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = STARTED = new State();
            stateArray[1] = ACTIVATED = new State();
            stateArray[2] = STOPPED = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

