/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch.bluetooth;

import android.os.Handler;
import androidx.annotation.VisibleForTesting;
import com.twilio.audioswitch.android.LogWrapper;
import com.twilio.audioswitch.android.SystemClockWrapper;
import com.twilio.audioswitch.bluetooth.BluetoothDeviceConnectionListener;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b \u0018\u00002\u00020\u0001:\u0001#B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010!\u001a\u00020\u001aJ\u0006\u0010\"\u001a\u00020\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u00060\nR\u00020\u00008\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R&\u0010\u0011\u001a\u0004\u0018\u00010\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0013\u0010\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00020\u001eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006$"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob;", "", "logger", "Lcom/twilio/audioswitch/android/LogWrapper;", "bluetoothScoHandler", "Landroid/os/Handler;", "systemClockWrapper", "Lcom/twilio/audioswitch/android/SystemClockWrapper;", "(Lcom/twilio/audioswitch/android/LogWrapper;Landroid/os/Handler;Lcom/twilio/audioswitch/android/SystemClockWrapper;)V", "bluetoothScoRunnable", "Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob$BluetoothScoRunnable;", "bluetoothScoRunnable$annotations", "()V", "getBluetoothScoRunnable", "()Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob$BluetoothScoRunnable;", "setBluetoothScoRunnable", "(Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob$BluetoothScoRunnable;)V", "deviceListener", "Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;", "deviceListener$annotations", "getDeviceListener", "()Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;", "setDeviceListener", "(Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;)V", "scoAction", "Lkotlin/Function0;", "", "getScoAction", "()Lkotlin/jvm/functions/Function0;", "timeoutError", "Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener$ConnectionError;", "getTimeoutError", "()Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener$ConnectionError;", "cancelBluetoothScoJob", "executeBluetoothScoJob", "BluetoothScoRunnable", "audioswitch_release"})
public abstract class BluetoothScoJob {
    @NotNull
    private BluetoothScoRunnable bluetoothScoRunnable;
    @Nullable
    private BluetoothDeviceConnectionListener deviceListener;
    private final LogWrapper logger;
    private final Handler bluetoothScoHandler;
    private final SystemClockWrapper systemClockWrapper;

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void bluetoothScoRunnable$annotations() {
    }

    @NotNull
    public final BluetoothScoRunnable getBluetoothScoRunnable() {
        return this.bluetoothScoRunnable;
    }

    public final void setBluetoothScoRunnable(@NotNull BluetoothScoRunnable bluetoothScoRunnable) {
        Intrinsics.checkParameterIsNotNull((Object)bluetoothScoRunnable, (String)"<set-?>");
        this.bluetoothScoRunnable = bluetoothScoRunnable;
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void deviceListener$annotations() {
    }

    @Nullable
    public final BluetoothDeviceConnectionListener getDeviceListener() {
        return this.deviceListener;
    }

    public final void setDeviceListener(@Nullable BluetoothDeviceConnectionListener bluetoothDeviceConnectionListener2) {
        this.deviceListener = bluetoothDeviceConnectionListener2;
    }

    @NotNull
    protected abstract Function0<Unit> getScoAction();

    @NotNull
    protected abstract BluetoothDeviceConnectionListener.ConnectionError getTimeoutError();

    public final void executeBluetoothScoJob() {
        this.bluetoothScoRunnable = new BluetoothScoRunnable();
        this.bluetoothScoHandler.post((Runnable)this.bluetoothScoRunnable);
        this.logger.d("BluetoothScoManager", "Scheduled bluetooth sco job");
    }

    public final void cancelBluetoothScoJob() {
        this.bluetoothScoHandler.removeCallbacks((Runnable)this.bluetoothScoRunnable);
        this.logger.d("BluetoothScoManager", "Canceled bluetooth sco job");
    }

    public BluetoothScoJob(@NotNull LogWrapper logger, @NotNull Handler bluetoothScoHandler, @NotNull SystemClockWrapper systemClockWrapper) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)bluetoothScoHandler, (String)"bluetoothScoHandler");
        Intrinsics.checkParameterIsNotNull((Object)systemClockWrapper, (String)"systemClockWrapper");
        this.logger = logger;
        this.bluetoothScoHandler = bluetoothScoHandler;
        this.systemClockWrapper = systemClockWrapper;
        this.bluetoothScoRunnable = new BluetoothScoRunnable();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob$BluetoothScoRunnable;", "Ljava/lang/Runnable;", "(Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob;)V", "elapsedTime", "", "startTime", "run", "", "audioswitch_release"})
    public final class BluetoothScoRunnable
    implements Runnable {
        private final long startTime;
        private long elapsedTime;

        @Override
        public void run() {
            if (this.elapsedTime < 5000L) {
                BluetoothScoJob.this.logger.d("BluetoothScoManager", "Invoking bluetooth sco action");
                BluetoothScoJob.this.getScoAction().invoke();
                this.elapsedTime = BluetoothScoJob.this.systemClockWrapper.elapsedRealtime() - this.startTime;
                BluetoothScoJob.this.bluetoothScoHandler.postDelayed((Runnable)this, 500L);
            } else {
                BluetoothScoJob.this.logger.e("BluetoothScoManager", "Bluetooth sco job timed out", new TimeoutException());
                BluetoothDeviceConnectionListener bluetoothDeviceConnectionListener2 = BluetoothScoJob.this.getDeviceListener();
                if (bluetoothDeviceConnectionListener2 != null) {
                    bluetoothDeviceConnectionListener2.onBluetoothConnectionError(BluetoothScoJob.this.getTimeoutError());
                }
                BluetoothScoJob.this.cancelBluetoothScoJob();
            }
        }

        public BluetoothScoRunnable() {
            this.startTime = BluetoothScoJob.this.systemClockWrapper.elapsedRealtime();
        }
    }
}

