/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch.bluetooth;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.twilio.audioswitch.android.BluetoothDeviceWrapper;
import com.twilio.audioswitch.android.BluetoothIntentProcessor;
import com.twilio.audioswitch.android.LogWrapper;
import com.twilio.audioswitch.bluetooth.BluetoothDeviceConnectionListener;
import com.twilio.audioswitch.bluetooth.BluetoothScoJob;
import com.twilio.audioswitch.bluetooth.DisableBluetoothScoJob;
import com.twilio.audioswitch.bluetooth.EnableBluetoothScoJob;
import com.twilio.audioswitch.selection.AudioDeviceManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u001f\u001a\u00020\u0015J\u000e\u0010 \u001a\u0004\u0018\u00010\u001a*\u00020\u001dH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetReceiver;", "Landroid/content/BroadcastReceiver;", "context", "Landroid/content/Context;", "logger", "Lcom/twilio/audioswitch/android/LogWrapper;", "bluetoothIntentProcessor", "Lcom/twilio/audioswitch/android/BluetoothIntentProcessor;", "audioDeviceManager", "Lcom/twilio/audioswitch/selection/AudioDeviceManager;", "enableBluetoothScoJob", "Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob;", "disableBluetoothScoJob", "deviceListener", "Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;", "(Landroid/content/Context;Lcom/twilio/audioswitch/android/LogWrapper;Lcom/twilio/audioswitch/android/BluetoothIntentProcessor;Lcom/twilio/audioswitch/selection/AudioDeviceManager;Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob;Lcom/twilio/audioswitch/bluetooth/BluetoothScoJob;Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;)V", "getDeviceListener", "()Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;", "setDeviceListener", "(Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;)V", "enableBluetoothSco", "", "enable", "", "isHeadsetDevice", "deviceWrapper", "Lcom/twilio/audioswitch/android/BluetoothDeviceWrapper;", "onReceive", "intent", "Landroid/content/Intent;", "setupDeviceListener", "stop", "getHeadsetDevice", "audioswitch_release"})
public final class BluetoothHeadsetReceiver
extends BroadcastReceiver {
    private final Context context;
    private final LogWrapper logger;
    private final BluetoothIntentProcessor bluetoothIntentProcessor;
    private final BluetoothScoJob enableBluetoothScoJob;
    private final BluetoothScoJob disableBluetoothScoJob;
    @Nullable
    private BluetoothDeviceConnectionListener deviceListener;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        block12: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
            String string = intent.getAction();
            if (string == null) return;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String action = string2;
            boolean bl3 = false;
            String string3 = action;
            switch (string3.hashCode()) {
                case -1692127708: {
                    if (!string3.equals("android.media.ACTION_SCO_AUDIO_STATE_UPDATED")) return;
                    break block12;
                }
                case 1821585647: {
                    if (!string3.equals("android.bluetooth.device.action.ACL_DISCONNECTED")) return;
                    break;
                }
                case -301431627: {
                    if (!string3.equals("android.bluetooth.device.action.ACL_CONNECTED")) return;
                    BluetoothDeviceWrapper bluetoothDeviceWrapper = this.getHeadsetDevice(intent);
                    if (bluetoothDeviceWrapper == null) return;
                    BluetoothDeviceWrapper bluetoothDeviceWrapper2 = bluetoothDeviceWrapper;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    BluetoothDeviceWrapper bluetoothDevice = bluetoothDeviceWrapper2;
                    boolean bl6 = false;
                    this.logger.d("BluetoothDeviceReceiver", "Bluetooth ACL device " + bluetoothDevice.getName() + " connected");
                    BluetoothDeviceConnectionListener bluetoothDeviceConnectionListener2 = this.deviceListener;
                    if (bluetoothDeviceConnectionListener2 == null) return;
                    bluetoothDeviceConnectionListener2.onBluetoothConnected(bluetoothDevice);
                    return;
                }
            }
            BluetoothDeviceWrapper bluetoothDeviceWrapper = this.getHeadsetDevice(intent);
            if (bluetoothDeviceWrapper == null) return;
            BluetoothDeviceWrapper bluetoothDeviceWrapper3 = bluetoothDeviceWrapper;
            boolean bl7 = false;
            boolean bl8 = false;
            BluetoothDeviceWrapper bluetoothDevice = bluetoothDeviceWrapper3;
            boolean bl9 = false;
            this.logger.d("BluetoothDeviceReceiver", "Bluetooth ACL device " + bluetoothDevice.getName() + " disconnected");
            BluetoothDeviceConnectionListener bluetoothDeviceConnectionListener3 = this.deviceListener;
            if (bluetoothDeviceConnectionListener3 == null) return;
            bluetoothDeviceConnectionListener3.onBluetoothDisconnected();
            return;
        }
        int n = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -1);
        boolean bl = false;
        boolean bl10 = false;
        int state = n;
        boolean bl11 = false;
        switch (state) {
            case 1: {
                this.logger.d("BluetoothDeviceReceiver", "Bluetooth SCO Audio connected");
                this.enableBluetoothScoJob.cancelBluetoothScoJob();
                return;
            }
            case 0: {
                this.logger.d("BluetoothDeviceReceiver", "Bluetooth SCO Audio disconnected");
                this.disableBluetoothScoJob.cancelBluetoothScoJob();
                return;
            }
            case -1: {
                this.logger.e("BluetoothDeviceReceiver", "Error retrieving Bluetooth SCO Audio state");
            }
        }
        return;
    }

    public final void enableBluetoothSco(boolean enable) {
        if (enable) {
            this.enableBluetoothScoJob.executeBluetoothScoJob();
        } else {
            this.disableBluetoothScoJob.executeBluetoothScoJob();
        }
    }

    public final void setupDeviceListener(@NotNull BluetoothDeviceConnectionListener deviceListener) {
        Intrinsics.checkParameterIsNotNull((Object)deviceListener, (String)"deviceListener");
        this.deviceListener = deviceListener;
        this.enableBluetoothScoJob.setDeviceListener(deviceListener);
        this.disableBluetoothScoJob.setDeviceListener(deviceListener);
    }

    public final void stop() {
        this.deviceListener = null;
        this.enableBluetoothScoJob.setDeviceListener(null);
        this.disableBluetoothScoJob.setDeviceListener(null);
        this.context.unregisterReceiver((BroadcastReceiver)this);
    }

    private final BluetoothDeviceWrapper getHeadsetDevice(@NotNull Intent $this$getHeadsetDevice) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper;
        BluetoothDeviceWrapper bluetoothDeviceWrapper2 = this.bluetoothIntentProcessor.getBluetoothDevice($this$getHeadsetDevice);
        if (bluetoothDeviceWrapper2 != null) {
            BluetoothDeviceWrapper bluetoothDeviceWrapper3 = bluetoothDeviceWrapper2;
            boolean bl = false;
            boolean bl2 = false;
            BluetoothDeviceWrapper device = bluetoothDeviceWrapper3;
            boolean bl3 = false;
            bluetoothDeviceWrapper = this.isHeadsetDevice(device) ? device : null;
        } else {
            bluetoothDeviceWrapper = null;
        }
        return bluetoothDeviceWrapper;
    }

    private final boolean isHeadsetDevice(BluetoothDeviceWrapper deviceWrapper) {
        boolean bl;
        Integer n = deviceWrapper.getDeviceClass();
        if (n != null) {
            Integer n2 = n;
            boolean bl2 = false;
            boolean bl3 = false;
            int deviceClass = ((Number)n2).intValue();
            boolean bl4 = false;
            bl = deviceClass == 1032 || deviceClass == 1028 || deviceClass == 1056 || deviceClass == 1048 || deviceClass == 7936;
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final BluetoothDeviceConnectionListener getDeviceListener() {
        return this.deviceListener;
    }

    public final void setDeviceListener(@Nullable BluetoothDeviceConnectionListener bluetoothDeviceConnectionListener2) {
        this.deviceListener = bluetoothDeviceConnectionListener2;
    }

    public BluetoothHeadsetReceiver(@NotNull Context context, @NotNull LogWrapper logger, @NotNull BluetoothIntentProcessor bluetoothIntentProcessor, @NotNull AudioDeviceManager audioDeviceManager, @NotNull BluetoothScoJob enableBluetoothScoJob, @NotNull BluetoothScoJob disableBluetoothScoJob, @Nullable BluetoothDeviceConnectionListener deviceListener) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)bluetoothIntentProcessor, (String)"bluetoothIntentProcessor");
        Intrinsics.checkParameterIsNotNull((Object)audioDeviceManager, (String)"audioDeviceManager");
        Intrinsics.checkParameterIsNotNull((Object)enableBluetoothScoJob, (String)"enableBluetoothScoJob");
        Intrinsics.checkParameterIsNotNull((Object)disableBluetoothScoJob, (String)"disableBluetoothScoJob");
        this.context = context;
        this.logger = logger;
        this.bluetoothIntentProcessor = bluetoothIntentProcessor;
        this.enableBluetoothScoJob = enableBluetoothScoJob;
        this.disableBluetoothScoJob = disableBluetoothScoJob;
        this.deviceListener = deviceListener;
    }

    public /* synthetic */ BluetoothHeadsetReceiver(Context context, LogWrapper logWrapper, BluetoothIntentProcessor bluetoothIntentProcessor, AudioDeviceManager audioDeviceManager, BluetoothScoJob bluetoothScoJob, BluetoothScoJob bluetoothScoJob2, BluetoothDeviceConnectionListener bluetoothDeviceConnectionListener2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bluetoothScoJob = new EnableBluetoothScoJob(logWrapper, audioDeviceManager, null, null, 12, null);
        }
        if ((n & 0x20) != 0) {
            bluetoothScoJob2 = new DisableBluetoothScoJob(logWrapper, audioDeviceManager, null, null, 12, null);
        }
        if ((n & 0x40) != 0) {
            bluetoothDeviceConnectionListener2 = null;
        }
        this(context, logWrapper, bluetoothIntentProcessor, audioDeviceManager, bluetoothScoJob, bluetoothScoJob2, bluetoothDeviceConnectionListener2);
    }
}

