/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch.selection;

import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.media.AudioManager;
import com.twilio.audioswitch.android.BluetoothDeviceWrapper;
import com.twilio.audioswitch.android.BluetoothIntentProcessorImpl;
import com.twilio.audioswitch.android.BuildWrapper;
import com.twilio.audioswitch.android.LogWrapper;
import com.twilio.audioswitch.bluetooth.BluetoothController;
import com.twilio.audioswitch.bluetooth.BluetoothDeviceConnectionListener;
import com.twilio.audioswitch.bluetooth.BluetoothHeadsetReceiver;
import com.twilio.audioswitch.bluetooth.PreConnectedDeviceListener;
import com.twilio.audioswitch.selection.AudioDevice;
import com.twilio.audioswitch.selection.AudioDeviceManager;
import com.twilio.audioswitch.selection.AudioDeviceSelector;
import com.twilio.audioswitch.selection.AudioFocusRequestWrapper;
import com.twilio.audioswitch.wired.WiredDeviceConnectionListener;
import com.twilio.audioswitch.wired.WiredHeadsetReceiver;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(k=1, mv={1, 1, 15}, bv={1, 0, 3}, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000:\u0001UB\u0011\b\u0016\u0012\u0006\u0010Q\u001a\u00020P\u00a2\u0006\u0004\bR\u0010SB+\b\u0010\u0012\u0006\u00106\u001a\u000205\u0012\u0006\u0010 \u001a\u00020\u001f\u0012\u0006\u0010N\u001a\u00020M\u0012\b\u0010,\u001a\u0004\u0018\u00010+\u00a2\u0006\u0004\bR\u0010TJ\r\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0003J\r\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0004\b\b\u0010\u0003J\u000f\u0010\t\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u0017\u0010\n\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\n\u0010\u0006JQ\u0010\u0013\u001a\u00020\u00012B\u0010\u0012\u001a>\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00010\u000bj\u0002`\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0003J\u001d\u0010\u0017\u001a\u00020\u00162\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018Rb\u0010\u0019\u001aB\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000bj\u0004\u0018\u0001`\u00118\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0016\u0010 \u001a\u00020\u001f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u001f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\f8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R$\u0010&\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010\u0006R\u001e\u0010,\u001a\u0004\u0018\u00010+8\u0000@\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R\u001c\u00101\u001a\u0002008\u0000@\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b3\u00104R\u0016\u00106\u001a\u0002058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R&\u0010:\u001a\u0012\u0012\u0004\u0012\u00020\u000408j\b\u0012\u0004\u0012\u00020\u0004`98\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u00048F@\u0006\u00a2\u0006\u0006\u001a\u0004\b<\u0010)R\u0018\u0010=\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010'R\"\u0010?\u001a\u00020>8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b?\u0010@\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u0018\u0010E\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bE\u0010'R\u001c\u0010G\u001a\u00020F8\u0000@\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bG\u0010H\u001a\u0004\bI\u0010JR\u0016\u0010K\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bK\u0010LR\u0016\u0010N\u001a\u00020M8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bN\u0010O\u00a8\u0006V"}, d2={"Lcom/twilio/audioswitch/selection/AudioDeviceSelector;", "", "activate", "()V", "Lcom/twilio/audioswitch/selection/AudioDevice;", "audioDevice", "(Lcom/twilio/audioswitch/selection/AudioDevice;)V", "closeListeners", "deactivate", "enumerateDevices", "selectDevice", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "audioDevices", "selectedAudioDevice", "Lcom/twilio/audioswitch/selection/AudioDeviceChangeListener;", "listener", "start", "(Lkotlin/Function2;)V", "stop", "", "userSelectedDevicePresent", "(Ljava/util/List;)Z", "audioDeviceChangeListener", "Lkotlin/Function2;", "getAudioDeviceChangeListener$audioswitch_release", "()Lkotlin/jvm/functions/Function2;", "setAudioDeviceChangeListener$audioswitch_release", "(Lkotlin/jvm/functions/Function2;)V", "Lcom/twilio/audioswitch/selection/AudioDeviceManager;", "audioDeviceManager", "Lcom/twilio/audioswitch/selection/AudioDeviceManager;", "availableAudioDevices", "Ljava/util/List;", "getAvailableAudioDevices", "()Ljava/util/List;", "bluetoothAudioDevice", "Lcom/twilio/audioswitch/selection/AudioDevice;", "getBluetoothAudioDevice", "()Lcom/twilio/audioswitch/selection/AudioDevice;", "setBluetoothAudioDevice", "Lcom/twilio/audioswitch/bluetooth/BluetoothController;", "bluetoothController", "Lcom/twilio/audioswitch/bluetooth/BluetoothController;", "getBluetoothController$audioswitch_release", "()Lcom/twilio/audioswitch/bluetooth/BluetoothController;", "Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;", "bluetoothDeviceConnectionListener", "Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;", "getBluetoothDeviceConnectionListener$audioswitch_release", "()Lcom/twilio/audioswitch/bluetooth/BluetoothDeviceConnectionListener;", "Lcom/twilio/audioswitch/android/LogWrapper;", "logger", "Lcom/twilio/audioswitch/android/LogWrapper;", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "mutableAudioDevices", "Ljava/util/ArrayList;", "getSelectedAudioDevice", "selectedDevice", "Lcom/twilio/audioswitch/selection/AudioDeviceSelector$State;", "state", "Lcom/twilio/audioswitch/selection/AudioDeviceSelector$State;", "getState$audioswitch_release", "()Lcom/twilio/audioswitch/selection/AudioDeviceSelector$State;", "setState$audioswitch_release", "(Lcom/twilio/audioswitch/selection/AudioDeviceSelector$State;)V", "userSelectedDevice", "Lcom/twilio/audioswitch/wired/WiredDeviceConnectionListener;", "wiredDeviceConnectionListener", "Lcom/twilio/audioswitch/wired/WiredDeviceConnectionListener;", "getWiredDeviceConnectionListener$audioswitch_release", "()Lcom/twilio/audioswitch/wired/WiredDeviceConnectionListener;", "wiredHeadsetAvailable", "Z", "Lcom/twilio/audioswitch/wired/WiredHeadsetReceiver;", "wiredHeadsetReceiver", "Lcom/twilio/audioswitch/wired/WiredHeadsetReceiver;", "Landroid/content/Context;", "context", "<init>", "(Landroid/content/Context;)V", "(Lcom/twilio/audioswitch/android/LogWrapper;Lcom/twilio/audioswitch/selection/AudioDeviceManager;Lcom/twilio/audioswitch/wired/WiredHeadsetReceiver;Lcom/twilio/audioswitch/bluetooth/BluetoothController;)V", "State", "audioswitch_release"}, xs="", pn="", xi=0)
public final class AudioDeviceSelector {
    public LogWrapper logger;
    public final AudioDeviceManager audioDeviceManager;
    public final WiredHeadsetReceiver wiredHeadsetReceiver;
    @Nullable
    public final BluetoothController bluetoothController;
    @Nullable
    public Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> audioDeviceChangeListener;
    public AudioDevice selectedDevice;
    public AudioDevice userSelectedDevice;
    public boolean wiredHeadsetAvailable;
    public final ArrayList<AudioDevice> mutableAudioDevices;
    @Nullable
    public AudioDevice bluetoothAudioDevice;
    @NotNull
    public State state;
    @NotNull
    public final BluetoothDeviceConnectionListener bluetoothDeviceConnectionListener;
    @NotNull
    public final WiredDeviceConnectionListener wiredDeviceConnectionListener;
    @NotNull
    public final List<AudioDevice> availableAudioDevices;

    /*
     * Enabled aggressive block sorting
     */
    private final void activate(AudioDevice audioDevice) {
        Object object;
        if (audioDevice instanceof AudioDevice.BluetoothHeadset) {
            AudioDeviceSelector audioDeviceSelector = object;
            audioDeviceSelector.audioDeviceManager.enableSpeakerphone(false);
            object = audioDeviceSelector.bluetoothController;
            if (object == null) return;
            ((BluetoothController)object).activate();
            return;
        }
        if (audioDevice instanceof AudioDevice.Earpiece || audioDevice instanceof AudioDevice.WiredHeadset) {
            AudioDeviceSelector audioDeviceSelector = object;
            audioDeviceSelector.audioDeviceManager.enableSpeakerphone(false);
            object = audioDeviceSelector.bluetoothController;
            if (object == null) return;
        } else {
            if (!(audioDevice instanceof AudioDevice.Speakerphone)) return;
            Object object2 = object;
            ((AudioDeviceSelector)object2).audioDeviceManager.enableSpeakerphone(true);
            object = ((AudioDeviceSelector)object2).bluetoothController;
            if (object == null) return;
        }
        ((BluetoothController)object).deactivate();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void enumerateDevices() {
        v0 = this;
        v0.mutableAudioDevices.clear();
        var1_1 /* !! */  = v0.bluetoothAudioDevice;
        if (var1_1 /* !! */  != null) {
            this.mutableAudioDevices.add((AudioDevice)var1_1 /* !! */ );
        }
        if (this.wiredHeadsetAvailable) {
            this.mutableAudioDevices.add(new AudioDevice.WiredHeadset(null, 1, null));
        }
        if (this.audioDeviceManager.hasEarpiece() && !this.wiredHeadsetAvailable) {
            this.mutableAudioDevices.add(new AudioDevice.Earpiece(null, 1, null));
        }
        if (this.audioDeviceManager.hasSpeakerphone()) {
            this.mutableAudioDevices.add(new AudioDevice.Speakerphone(null, 1, null));
        }
        v1 = this;
        if (!v1.userSelectedDevicePresent(v1.mutableAudioDevices)) {
            this.userSelectedDevice = null;
        }
        if (this.userSelectedDevice == null) ** GOTO lbl-1000
        v2 = this;
        if (v2.userSelectedDevicePresent(v2.mutableAudioDevices)) {
            var1_1 /* !! */  = this.userSelectedDevice;
        } else lbl-1000:
        // 2 sources

        {
            var1_1 /* !! */  = this.mutableAudioDevices.size() > 0 ? this.mutableAudioDevices.get(0) : null;
        }
        this.selectedDevice = var1_1 /* !! */ ;
        if (this.state == State.ACTIVATED) {
            this.activate();
        }
        if ((var1_1 /* !! */  = this.audioDeviceChangeListener) != null) {
            var2_2 = this.selectedDevice;
            if (var2_2 != null) {
                var1_1 /* !! */ .invoke(this.mutableAudioDevices, (Object)var2_2);
            } else {
                var1_1 /* !! */ .invoke(this.mutableAudioDevices, null);
            }
        }
    }

    private final boolean userSelectedDevicePresent(List<? extends AudioDevice> object) {
        object = object.iterator();
        while (object.hasNext()) {
            if (!Intrinsics.areEqual((Object)((AudioDevice)object.next()), (Object)this.userSelectedDevice)) continue;
            return true;
        }
        return false;
    }

    private final void closeListeners() {
        BluetoothController bluetoothController = this.bluetoothController;
        if (bluetoothController != null) {
            bluetoothController.stop();
        }
        this.wiredHeadsetReceiver.stop();
        this.audioDeviceChangeListener = null;
        this.state = State.STOPPED;
    }

    public AudioDeviceSelector(@NotNull Context context) {
        AudioDeviceSelector audioDeviceSelector = this;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        audioDeviceSelector.logger = new LogWrapper();
        audioDeviceSelector.mutableAudioDevices = new ArrayList();
        audioDeviceSelector.state = State.STOPPED;
        audioDeviceSelector.bluetoothDeviceConnectionListener = new BluetoothDeviceConnectionListener(this){
            public final /* synthetic */ AudioDeviceSelector this$0;
            {
                this.this$0 = audioDeviceSelector;
            }

            public void onBluetoothConnected(@NotNull BluetoothDeviceWrapper bluetoothDeviceWrapper) {
                bluetoothDeviceConnectionListener.1 v0 = this;
                Intrinsics.checkParameterIsNotNull((Object)bluetoothDeviceWrapper, (String)"bluetoothDeviceWrapper");
                v0.this$0.setBluetoothAudioDevice(new AudioDevice.BluetoothHeadset(bluetoothDeviceWrapper.getName()));
                if (v0.this$0.getState$audioswitch_release() == State.ACTIVATED) {
                    AudioDeviceSelector audioDeviceSelector = this.this$0;
                    AudioDeviceSelector.access$setUserSelectedDevice$p(audioDeviceSelector, audioDeviceSelector.getBluetoothAudioDevice());
                }
                AudioDeviceSelector.access$enumerateDevices(this.this$0);
            }

            public void onBluetoothDisconnected() {
                bluetoothDeviceConnectionListener.1 v0 = this;
                v0.this$0.setBluetoothAudioDevice(null);
                AudioDeviceSelector.access$enumerateDevices(v0.this$0);
            }

            public void onBluetoothConnectionError(@NotNull BluetoothDeviceConnectionListener.ConnectionError connectionError) {
                BluetoothDeviceConnectionListener.ConnectionError connectionError2 = connectionError;
                Intrinsics.checkParameterIsNotNull((Object)connectionError2, (String)"error");
                if (connectionError2 instanceof BluetoothDeviceConnectionListener.ConnectionError.SCO_CONNECTION_ERROR) {
                    bluetoothDeviceConnectionListener.1 v1 = this;
                    AudioDeviceSelector.access$getLogger$p(v1.this$0).d("AudioDeviceSelector", "Removing the bluetooth audio device as the selected device due to a sco connection error.");
                    v1.this$0.setBluetoothAudioDevice(null);
                    AudioDeviceSelector.access$enumerateDevices(v1.this$0);
                }
            }
        };
        audioDeviceSelector.wiredDeviceConnectionListener = new WiredDeviceConnectionListener(this){
            public final /* synthetic */ AudioDeviceSelector this$0;
            {
                this.this$0 = audioDeviceSelector;
            }

            public void onDeviceConnected() {
                wiredDeviceConnectionListener.1 v0 = this;
                AudioDeviceSelector.access$setWiredHeadsetAvailable$p(v0.this$0, true);
                AudioDeviceSelector.access$getLogger$p(v0.this$0).d("AudioDeviceSelector", "Wired Headset available");
                if (v0.this$0.getState$audioswitch_release() == State.ACTIVATED) {
                    AudioDeviceSelector.access$setUserSelectedDevice$p(this.this$0, new AudioDevice.WiredHeadset(null, 1, null));
                }
                AudioDeviceSelector.access$enumerateDevices(this.this$0);
            }

            public void onDeviceDisconnected() {
                wiredDeviceConnectionListener.1 v0 = this;
                AudioDeviceSelector.access$setWiredHeadsetAvailable$p(v0.this$0, false);
                AudioDeviceSelector.access$enumerateDevices(v0.this$0);
            }
        };
        audioDeviceSelector.availableAudioDevices = audioDeviceSelector.mutableAudioDevices;
        Object object = context.getSystemService("audio");
        if (object != null) {
            WiredHeadsetReceiver wiredHeadsetReceiver;
            AudioFocusRequestWrapper audioFocusRequestWrapper;
            BuildWrapper buildWrapper;
            AudioDeviceManager audioDeviceManager;
            LogWrapper logWrapper;
            AudioDeviceSelector audioDeviceSelector2 = this;
            object = (AudioManager)object;
            LogWrapper logWrapper2 = logWrapper;
            logWrapper = new LogWrapper();
            AudioDeviceManager audioDeviceManager2 = audioDeviceManager;
            Object object2 = buildWrapper;
            buildWrapper = new BuildWrapper();
            Object object3 = audioFocusRequestWrapper;
            audioFocusRequestWrapper = new AudioFocusRequestWrapper();
            audioDeviceManager = new AudioDeviceManager(context, logWrapper2, (AudioManager)object, (BuildWrapper)object2, (AudioFocusRequestWrapper)object3);
            audioDeviceSelector2.logger = logWrapper2;
            audioDeviceSelector2.audioDeviceManager = audioDeviceManager2;
            object = wiredHeadsetReceiver;
            wiredHeadsetReceiver = new WiredHeadsetReceiver(context, logWrapper2);
            audioDeviceSelector2.wiredHeadsetReceiver = object;
            object = BluetoothAdapter.getDefaultAdapter();
            if (object != null) {
                BluetoothIntentProcessorImpl bluetoothIntentProcessorImpl;
                BluetoothHeadsetReceiver bluetoothHeadsetReceiver;
                PreConnectedDeviceListener preConnectedDeviceListener;
                BluetoothController bluetoothController;
                object2 = bluetoothController;
                object3 = preConnectedDeviceListener;
                preConnectedDeviceListener = new PreConnectedDeviceListener(logWrapper2, (BluetoothAdapter)object, null, 4, null);
                BluetoothHeadsetReceiver bluetoothHeadsetReceiver2 = bluetoothHeadsetReceiver;
                BluetoothIntentProcessorImpl bluetoothIntentProcessorImpl2 = bluetoothIntentProcessorImpl;
                bluetoothIntentProcessorImpl = new BluetoothIntentProcessorImpl();
                bluetoothHeadsetReceiver = new BluetoothHeadsetReceiver(context, logWrapper2, bluetoothIntentProcessorImpl2, audioDeviceManager2, null, null, null, 112, null);
                bluetoothController = new BluetoothController(context, (BluetoothAdapter)object, (PreConnectedDeviceListener)object3, bluetoothHeadsetReceiver2);
            } else {
                logWrapper2.d("AudioDeviceSelector", "Bluetooth is not supported on this device");
                object2 = null;
            }
            this.bluetoothController = object2;
            return;
        }
        throw new TypeCastException("null cannot be cast to non-null type android.media.AudioManager");
    }

    public AudioDeviceSelector(@NotNull LogWrapper logWrapper, @NotNull AudioDeviceManager audioDeviceManager, @NotNull WiredHeadsetReceiver wiredHeadsetReceiver, @Nullable BluetoothController bluetoothController) {
        AudioDeviceSelector audioDeviceSelector = this;
        Intrinsics.checkParameterIsNotNull((Object)logWrapper, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)audioDeviceManager, (String)"audioDeviceManager");
        Intrinsics.checkParameterIsNotNull((Object)((Object)wiredHeadsetReceiver), (String)"wiredHeadsetReceiver");
        audioDeviceSelector.logger = new LogWrapper();
        audioDeviceSelector.mutableAudioDevices = new ArrayList();
        audioDeviceSelector.state = State.STOPPED;
        audioDeviceSelector.bluetoothDeviceConnectionListener = new /* invalid duplicate definition of identical inner class */;
        audioDeviceSelector.wiredDeviceConnectionListener = new /* invalid duplicate definition of identical inner class */;
        audioDeviceSelector.availableAudioDevices = audioDeviceSelector.mutableAudioDevices;
        this.logger = logWrapper;
        this.audioDeviceManager = audioDeviceManager;
        this.wiredHeadsetReceiver = wiredHeadsetReceiver;
        this.bluetoothController = bluetoothController;
    }

    public static final /* synthetic */ AudioDevice access$getUserSelectedDevice$p(AudioDeviceSelector audioDeviceSelector) {
        return audioDeviceSelector.userSelectedDevice;
    }

    public static final /* synthetic */ void access$setUserSelectedDevice$p(AudioDeviceSelector audioDeviceSelector, AudioDevice audioDevice) {
        audioDeviceSelector.userSelectedDevice = audioDevice;
    }

    public static final /* synthetic */ void access$enumerateDevices(AudioDeviceSelector audioDeviceSelector) {
        audioDeviceSelector.enumerateDevices();
    }

    public static final /* synthetic */ LogWrapper access$getLogger$p(AudioDeviceSelector audioDeviceSelector) {
        return audioDeviceSelector.logger;
    }

    public static final /* synthetic */ void access$setLogger$p(AudioDeviceSelector audioDeviceSelector, LogWrapper logWrapper) {
        audioDeviceSelector.logger = logWrapper;
    }

    public static final /* synthetic */ boolean access$getWiredHeadsetAvailable$p(AudioDeviceSelector audioDeviceSelector) {
        return audioDeviceSelector.wiredHeadsetAvailable;
    }

    public static final /* synthetic */ void access$setWiredHeadsetAvailable$p(AudioDeviceSelector audioDeviceSelector, boolean bl) {
        audioDeviceSelector.wiredHeadsetAvailable = bl;
    }

    @Nullable
    public final BluetoothController getBluetoothController$audioswitch_release() {
        return this.bluetoothController;
    }

    @Nullable
    public final Function2<List<? extends AudioDevice>, AudioDevice, Unit> getAudioDeviceChangeListener$audioswitch_release() {
        return this.audioDeviceChangeListener;
    }

    public final void setAudioDeviceChangeListener$audioswitch_release(@Nullable Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> function2) {
        this.audioDeviceChangeListener = function2;
    }

    @Nullable
    public final AudioDevice getBluetoothAudioDevice() {
        return this.bluetoothAudioDevice;
    }

    public final void setBluetoothAudioDevice(@Nullable AudioDevice audioDevice) {
        this.bluetoothAudioDevice = audioDevice;
    }

    @NotNull
    public final State getState$audioswitch_release() {
        return this.state;
    }

    public final void setState$audioswitch_release(@NotNull State state) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"<set-?>");
        this.state = state;
    }

    @NotNull
    public final BluetoothDeviceConnectionListener getBluetoothDeviceConnectionListener$audioswitch_release() {
        return this.bluetoothDeviceConnectionListener;
    }

    @NotNull
    public final WiredDeviceConnectionListener getWiredDeviceConnectionListener$audioswitch_release() {
        return this.wiredDeviceConnectionListener;
    }

    public final void start(@NotNull Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> object) {
        Function2<? super List<? extends AudioDevice>, ? super AudioDevice, Unit> function2 = object;
        Intrinsics.checkParameterIsNotNull(function2, (String)"listener");
        this.audioDeviceChangeListener = function2;
        if (this.state.ordinal() != 2) {
            this.logger.d("AudioDeviceSelector", "Redundant start() invocation while already in the started or activated state");
        } else {
            object = this.bluetoothController;
            if (object != null) {
                ((BluetoothController)object).start(this.bluetoothDeviceConnectionListener);
            }
            AudioDeviceSelector audioDeviceSelector = this;
            audioDeviceSelector.wiredHeadsetReceiver.start(this.wiredDeviceConnectionListener);
            audioDeviceSelector.enumerateDevices();
            audioDeviceSelector.state = State.STARTED;
        }
    }

    public final void stop() {
        int n = this.state.ordinal();
        if (n != 0) {
            if (n != 1) {
                if (n == 2) {
                    this.logger.d("AudioDeviceSelector", "Redundant stop() invocation while already in the stopped state");
                }
            } else {
                AudioDeviceSelector audioDeviceSelector = this;
                audioDeviceSelector.deactivate();
                audioDeviceSelector.closeListeners();
            }
        } else {
            this.closeListeners();
        }
    }

    public final void activate() {
        int n = this.state.ordinal();
        if (n != 0) {
            if (n != 1) {
                if (n == 2) {
                    throw new IllegalStateException();
                }
            } else {
                AudioDevice audioDevice = this.selectedDevice;
                if (audioDevice != null) {
                    this.activate(audioDevice);
                }
            }
        } else {
            AudioDeviceSelector audioDeviceSelector = this;
            audioDeviceSelector.audioDeviceManager.cacheAudioState();
            audioDeviceSelector.audioDeviceManager.mute(false);
            audioDeviceSelector.audioDeviceManager.setAudioFocus();
            AudioDevice audioDevice = audioDeviceSelector.selectedDevice;
            if (audioDevice != null) {
                this.activate(audioDevice);
            }
            this.state = State.ACTIVATED;
        }
    }

    public final void deactivate() {
        if (this.state.ordinal() == 1) {
            BluetoothController bluetoothController = this.bluetoothController;
            if (bluetoothController != null) {
                bluetoothController.deactivate();
            }
            this.audioDeviceManager.restoreAudioState();
            this.state = State.STARTED;
        }
    }

    public final void selectDevice(@Nullable AudioDevice audioDevice) {
        if (Intrinsics.areEqual((Object)this.selectedDevice, (Object)audioDevice) ^ true) {
            this.userSelectedDevice = audioDevice;
            this.enumerateDevices();
        }
    }

    @Nullable
    public final AudioDevice getSelectedAudioDevice() {
        return this.selectedDevice;
    }

    @NotNull
    public final List<AudioDevice> getAvailableAudioDevices() {
        return this.availableAudioDevices;
    }

    @Metadata(k=1, mv={1, 1, 15}, bv={1, 0, 3}, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0080\u0001\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/twilio/audioswitch/selection/AudioDeviceSelector$State;", "Ljava/lang/Enum;", "<init>", "(Ljava/lang/String;I)V", "STARTED", "ACTIVATED", "STOPPED", "audioswitch_release"}, xs="", pn="", xi=0)
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State STARTED;
        public static final /* enum */ State ACTIVATED;
        public static final /* enum */ State STOPPED;
        public static final /* synthetic */ State[] $VALUES;

        static {
            State state;
            State state2;
            State state3;
            State[] stateArray = new State[3];
            State state4 = state3;
            STARTED = new State();
            stateArray[0] = state4;
            state4 = state2;
            ACTIVATED = new State();
            stateArray[1] = state4;
            state4 = state;
            STOPPED = new State();
            stateArray[2] = state4;
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

