/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch.selection;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioDeviceInfo;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import com.twilio.audioswitch.android.BuildWrapper;
import com.twilio.audioswitch.android.LogWrapper;
import com.twilio.audioswitch.selection.AudioDeviceManager;
import com.twilio.audioswitch.selection.AudioFocusRequestWrapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0012J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0012J\u0006\u0010\u001a\u001a\u00020\u0012J\b\u0010\u001b\u001a\u00020\u0012H\u0007J\u000e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0012J\b\u0010\u001d\u001a\u00020\u0015H\u0007J\b\u0010\u001e\u001a\u00020\u0015H\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/twilio/audioswitch/selection/AudioDeviceManager;", "", "context", "Landroid/content/Context;", "logger", "Lcom/twilio/audioswitch/android/LogWrapper;", "audioManager", "Landroid/media/AudioManager;", "build", "Lcom/twilio/audioswitch/android/BuildWrapper;", "audioFocusRequest", "Lcom/twilio/audioswitch/selection/AudioFocusRequestWrapper;", "(Landroid/content/Context;Lcom/twilio/audioswitch/android/LogWrapper;Landroid/media/AudioManager;Lcom/twilio/audioswitch/android/BuildWrapper;Lcom/twilio/audioswitch/selection/AudioFocusRequestWrapper;)V", "audioRequest", "Landroid/media/AudioFocusRequest;", "savedAudioMode", "", "savedIsMicrophoneMuted", "", "savedSpeakerphoneEnabled", "cacheAudioState", "", "enableBluetoothSco", "start", "enableSpeakerphone", "enable", "hasEarpiece", "hasSpeakerphone", "mute", "restoreAudioState", "setAudioFocus", "audioswitch_release"})
public final class AudioDeviceManager {
    private int savedAudioMode;
    private boolean savedIsMicrophoneMuted;
    private boolean savedSpeakerphoneEnabled;
    private AudioFocusRequest audioRequest;
    private final Context context;
    private final LogWrapper logger;
    private final AudioManager audioManager;
    private final BuildWrapper build;
    private final AudioFocusRequestWrapper audioFocusRequest;

    public final boolean hasEarpiece() {
        boolean hasEarpiece = this.context.getPackageManager().hasSystemFeature("android.hardware.telephony");
        if (hasEarpiece) {
            this.logger.d("AudioDeviceManager", "Earpiece available");
        }
        return hasEarpiece;
    }

    @SuppressLint(value={"NewApi"})
    public final boolean hasSpeakerphone() {
        boolean bl;
        if (this.build.getVersion() >= 23 && this.context.getPackageManager().hasSystemFeature("android.hardware.audio.output")) {
            AudioDeviceInfo[] devices;
            AudioDeviceInfo[] audioDeviceInfoArray = devices = this.audioManager.getDevices(2);
            int n = audioDeviceInfoArray.length;
            for (int i = 0; i < n; ++i) {
                AudioDeviceInfo device;
                AudioDeviceInfo audioDeviceInfo = device = audioDeviceInfoArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)audioDeviceInfo, (String)"device");
                if (audioDeviceInfo.getType() != 2) continue;
                this.logger.d("AudioDeviceManager", "Speakerphone available");
                return true;
            }
            bl = false;
        } else {
            this.logger.d("AudioDeviceManager", "Speakerphone available");
            bl = true;
        }
        return bl;
    }

    @SuppressLint(value={"NewApi"})
    public final void setAudioFocus() {
        if (this.build.getVersion() >= 26) {
            AudioFocusRequest audioFocusRequest = this.audioRequest = this.audioFocusRequest.buildRequest();
            if (audioFocusRequest != null) {
                AudioFocusRequest audioFocusRequest2 = audioFocusRequest;
                boolean bl = false;
                boolean bl2 = false;
                AudioFocusRequest it = audioFocusRequest2;
                boolean bl3 = false;
                this.audioManager.requestAudioFocus(it);
            }
        } else {
            this.audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)setAudioFocus.2.INSTANCE, 0, 2);
        }
        this.audioManager.setMode(3);
    }

    public final void enableBluetoothSco(boolean start) {
        AudioManager audioManager = this.audioManager;
        boolean bl = false;
        boolean bl2 = false;
        AudioManager $this$run = audioManager;
        boolean bl3 = false;
        if (start) {
            $this$run.startBluetoothSco();
        } else {
            $this$run.stopBluetoothSco();
        }
    }

    public final void enableSpeakerphone(boolean enable) {
        this.audioManager.setSpeakerphoneOn(enable);
    }

    public final void mute(boolean mute) {
        this.audioManager.setMicrophoneMute(mute);
    }

    public final void cacheAudioState() {
        this.savedAudioMode = this.audioManager.getMode();
        this.savedIsMicrophoneMuted = this.audioManager.isMicrophoneMute();
        this.savedSpeakerphoneEnabled = this.audioManager.isSpeakerphoneOn();
    }

    @SuppressLint(value={"NewApi"})
    public final void restoreAudioState() {
        this.audioManager.setMode(this.savedAudioMode);
        this.mute(this.savedIsMicrophoneMuted);
        this.enableSpeakerphone(this.savedSpeakerphoneEnabled);
        if (this.build.getVersion() >= 26) {
            AudioFocusRequest audioFocusRequest = this.audioRequest;
            if (audioFocusRequest != null) {
                AudioFocusRequest audioFocusRequest2 = audioFocusRequest;
                boolean bl = false;
                boolean bl2 = false;
                AudioFocusRequest it = audioFocusRequest2;
                boolean bl3 = false;
                this.audioManager.abandonAudioFocusRequest(it);
            }
        } else {
            this.audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)restoreAudioState.2.INSTANCE);
        }
    }

    public AudioDeviceManager(@NotNull Context context, @NotNull LogWrapper logger, @NotNull AudioManager audioManager, @NotNull BuildWrapper build, @NotNull AudioFocusRequestWrapper audioFocusRequest) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)audioManager, (String)"audioManager");
        Intrinsics.checkParameterIsNotNull((Object)build, (String)"build");
        Intrinsics.checkParameterIsNotNull((Object)audioFocusRequest, (String)"audioFocusRequest");
        this.context = context;
        this.logger = logger;
        this.audioManager = audioManager;
        this.build = build;
        this.audioFocusRequest = audioFocusRequest;
    }
}

