/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util.regex;

import java.io.PrintStream;

public class WildcardStringParser {
    public static final char[] ALPHABET = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00e6', '\u00f8', '\u00e5', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'N', 'M', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c6', '\u00d8', '\u00c5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.', '_', '-'};
    public static final char FREE_RANGE_CHARACTER = '*';
    public static final char FREE_PASS_CHARACTER = '?';
    boolean mInitialized;
    String mStringMask;
    WildcardStringParserState mInitialState;
    int mTotalNumberOfStringsParsed;
    boolean mDebugging;
    PrintStream out;

    public WildcardStringParser(String pStringMask) {
        this(pStringMask, false);
    }

    public WildcardStringParser(String pStringMask, boolean pDebugging) {
        this(pStringMask, pDebugging, System.out);
    }

    public WildcardStringParser(String pStringMask, boolean pDebugging, PrintStream pDebuggingPrintStream) {
        this.mStringMask = pStringMask;
        this.mDebugging = pDebugging;
        this.out = pDebuggingPrintStream;
        this.mInitialized = this.buildAutomaton();
    }

    private boolean checkIfStateInWildcardRange(WildcardStringParserState pState) {
        WildcardStringParserState runnerState = pState;
        while (runnerState.mPreviousState != null) {
            runnerState = runnerState.mPreviousState;
            if (WildcardStringParser.isFreeRangeCharacter(runnerState.mChar)) {
                return true;
            }
            if (WildcardStringParser.isFreePassCharacter(runnerState.mChar)) continue;
            return false;
        }
        return false;
    }

    private boolean checkIfLastFreeRangeState(WildcardStringParserState pState) {
        if (WildcardStringParser.isFreeRangeCharacter(pState.mChar)) {
            return true;
        }
        return WildcardStringParser.isFreePassCharacter(pState.mChar) && this.checkIfStateInWildcardRange(pState);
    }

    private boolean isTrivialAutomaton() {
        for (int i = 0; i < this.mStringMask.length(); ++i) {
            if (WildcardStringParser.isFreeRangeCharacter(this.mStringMask.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean buildAutomaton() {
        WildcardStringParserState runnerState = null;
        WildcardStringParserState newState = null;
        WildcardStringParserState lastFreeRangeState = null;
        if (this.mStringMask != null && this.mStringMask.length() > 0) {
            newState = new WildcardStringParserState(this.mStringMask.charAt(0));
            newState.mAutomatonStateNumber = 0;
            newState.mPreviousState = null;
            if (this.checkIfLastFreeRangeState(newState)) {
                lastFreeRangeState = newState;
            }
        } else {
            System.err.println("string mask provided are null or empty - aborting!");
            return false;
        }
        this.mInitialState = runnerState = newState;
        this.mInitialState.mAutomatonStateNumber = 0;
        for (int i = 1; i < this.mStringMask.length(); ++i) {
            char activeChar = this.mStringMask.charAt(i);
            if (!WildcardStringParser.isInAlphabet(activeChar) && !WildcardStringParser.isWildcardCharacter(activeChar)) {
                System.err.println("one or more characters in string mask are not legal characters - aborting!");
                return false;
            }
            runnerState.mLastFreeRangeState = lastFreeRangeState;
            newState = new WildcardStringParserState(activeChar);
            newState.mAutomatonStateNumber = i;
            newState.mPreviousState = runnerState;
            if (this.checkIfLastFreeRangeState(newState)) {
                lastFreeRangeState = newState;
            }
            runnerState.mNextState = newState;
            runnerState = newState;
            if (runnerState.mAutomatonStateNumber != this.mStringMask.length() - 1) continue;
            runnerState.mLastFreeRangeState = lastFreeRangeState;
        }
        this.mTotalNumberOfStringsParsed = 0;
        return true;
    }

    public static boolean isInAlphabet(char pCharToCheck) {
        for (int i = 0; i < ALPHABET.length; ++i) {
            if (pCharToCheck != ALPHABET[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isFreeRangeCharacter(char pCharToCheck) {
        return pCharToCheck == '*';
    }

    public static boolean isFreePassCharacter(char pCharToCheck) {
        return pCharToCheck == '?';
    }

    public static boolean isWildcardCharacter(char pCharToCheck) {
        return WildcardStringParser.isFreeRangeCharacter(pCharToCheck) || WildcardStringParser.isFreePassCharacter(pCharToCheck);
    }

    public String getStringMask() {
        return this.mStringMask;
    }

    public boolean parseString(String pStringToParse) {
        if (this.mDebugging) {
            this.out.println("parsing \"" + pStringToParse + "\"...");
        }
        ++this.mTotalNumberOfStringsParsed;
        if (pStringToParse == null) {
            if (this.mDebugging) {
                this.out.println("string to be parsed is null - rejection!");
            }
            return false;
        }
        ParsableString parsableString = new ParsableString(pStringToParse);
        if (!parsableString.checkString()) {
            if (this.mDebugging) {
                this.out.println("one or more characters in string to be parsed are not legal characters - rejection!");
            }
            return false;
        }
        if (!this.mInitialized) {
            System.err.println("automaton is not initialized - rejection!");
            return false;
        }
        if (this.isTrivialAutomaton()) {
            if (this.mDebugging) {
                this.out.println("automaton represents a trivial string mask (accepts all strings) - acceptance!");
            }
            return true;
        }
        if (parsableString.isEmpty()) {
            if (this.mDebugging) {
                this.out.println("string to be parsed is empty and not trivial automaton - rejection!");
            }
            return false;
        }
        boolean hasPerformedFreeRangeMovement = false;
        int numberOfFreePassCharactersRead_SinceLastFreePassState = 0;
        int numberOfParsedCharactersRead_SinceLastFreePassState = 0;
        WildcardStringParserState runnerState = null;
        if (parsableString.mCharArray[0] != this.mInitialState.mChar && !WildcardStringParser.isWildcardCharacter(this.mInitialState.mChar)) {
            if (this.mDebugging) {
                this.out.println("cannot enter first automaton state - rejection!");
            }
            return false;
        }
        runnerState = this.mInitialState;
        parsableString.mIndex = 0;
        if (WildcardStringParser.isFreePassCharacter(runnerState.mChar)) {
            ++numberOfFreePassCharactersRead_SinceLastFreePassState;
        }
        for (int i = 0; i < parsableString.length(); ++i) {
            if (this.mDebugging) {
                this.out.println();
            }
            if (this.mDebugging) {
                this.out.println("parsing - index number " + i + ", active char: '" + parsableString.getActiveChar() + "' char string index: " + parsableString.mIndex + " number of chars since last free-range state: " + numberOfParsedCharactersRead_SinceLastFreePassState);
            }
            if (this.mDebugging) {
                this.out.println("parsing - state: " + runnerState.mAutomatonStateNumber + " '" + runnerState.mChar + "' - no of free-pass chars read: " + numberOfFreePassCharactersRead_SinceLastFreePassState);
            }
            if (this.mDebugging) {
                this.out.println("parsing - hasPerformedFreeRangeMovement: " + hasPerformedFreeRangeMovement);
            }
            if (runnerState.mNextState == null) {
                if (this.mDebugging) {
                    this.out.println("parsing - runnerState.mNextState == null");
                }
                if (WildcardStringParser.isFreeRangeCharacter(runnerState.mChar)) {
                    if (hasPerformedFreeRangeMovement) {
                        if (parsableString.reachedEndOfString()) {
                            if (numberOfFreePassCharactersRead_SinceLastFreePassState > numberOfParsedCharactersRead_SinceLastFreePassState) {
                                if (this.mDebugging) {
                                    this.out.println("no subsequent state (final state) and the state represents '*' - end of parsing string, but not enough characters read - rejection!");
                                }
                                return false;
                            }
                            if (this.mDebugging) {
                                this.out.println("no subsequent state (final state) and the state represents '*' - end of parsing string and enough characters read - acceptance!");
                            }
                            return true;
                        }
                        if (numberOfFreePassCharactersRead_SinceLastFreePassState > numberOfParsedCharactersRead_SinceLastFreePassState) {
                            if (this.mDebugging) {
                                this.out.println("no subsequent state (final state) and the state represents '*' - not the end of parsing string and not enough characters read - read next character");
                            }
                            ++parsableString.mIndex;
                            ++numberOfParsedCharactersRead_SinceLastFreePassState;
                            continue;
                        }
                        if (this.mDebugging) {
                            this.out.println("no subsequent state (final state) and the state represents '*' - not the end of parsing string, but enough characters read - acceptance!");
                        }
                        return true;
                    }
                    if (this.mDebugging) {
                        this.out.println("no subsequent state (final state) and the state represents '*' - no skipping performed - acceptance!");
                    }
                    return true;
                }
                if (parsableString.reachedEndOfString()) {
                    if (hasPerformedFreeRangeMovement && numberOfFreePassCharactersRead_SinceLastFreePassState > numberOfParsedCharactersRead_SinceLastFreePassState) {
                        if (this.mDebugging) {
                            this.out.println("no subsequent state (final state) and skipping has been performed and end of parsing string, but not enough characters read - rejection!");
                        }
                        return false;
                    }
                    if (this.mDebugging) {
                        this.out.println("no subsequent state (final state) and the end of the string to test is reached - acceptance!");
                    }
                    return true;
                }
                if (!this.mDebugging) continue;
                this.out.println("parsing - escaping process...");
                continue;
            }
            if (this.mDebugging) {
                this.out.println("parsing - runnerState.mNextState != null");
            }
            if (WildcardStringParser.isFreeRangeCharacter(runnerState.mChar)) {
                numberOfFreePassCharactersRead_SinceLastFreePassState = 0;
                numberOfParsedCharactersRead_SinceLastFreePassState = 0;
                WildcardStringParserState freeRangeRunnerState = runnerState.mNextState;
                while (freeRangeRunnerState != null && WildcardStringParser.isFreePassCharacter(freeRangeRunnerState.mChar)) {
                    runnerState = freeRangeRunnerState;
                    hasPerformedFreeRangeMovement = true;
                    ++numberOfFreePassCharactersRead_SinceLastFreePassState;
                    freeRangeRunnerState = freeRangeRunnerState.mNextState;
                }
                if (runnerState.mNextState == null) {
                    if (this.mDebugging) {
                        this.out.println();
                    }
                    if (this.mDebugging) {
                        this.out.println("parsing - index number " + i + ", active char: '" + parsableString.getActiveChar() + "' char string index: " + parsableString.mIndex + " number of chars since last free-range state: " + numberOfParsedCharactersRead_SinceLastFreePassState);
                    }
                    if (this.mDebugging) {
                        this.out.println("parsing - state: " + runnerState.mAutomatonStateNumber + " '" + runnerState.mChar + "' - no of free-pass chars read: " + numberOfFreePassCharactersRead_SinceLastFreePassState);
                    }
                    if (this.mDebugging) {
                        this.out.println("parsing - hasPerformedFreeRangeMovement: " + hasPerformedFreeRangeMovement);
                    }
                    return hasPerformedFreeRangeMovement && numberOfFreePassCharactersRead_SinceLastFreePassState >= numberOfParsedCharactersRead_SinceLastFreePassState;
                }
            }
            if (WildcardStringParser.isFreeRangeCharacter(runnerState.mNextState.mChar)) {
                runnerState = runnerState.mNextState;
                ++parsableString.mIndex;
                ++numberOfParsedCharactersRead_SinceLastFreePassState;
                continue;
            }
            if (WildcardStringParser.isFreePassCharacter(runnerState.mNextState.mChar)) {
                runnerState = runnerState.mNextState;
                ++parsableString.mIndex;
                ++numberOfFreePassCharactersRead_SinceLastFreePassState;
                ++numberOfParsedCharactersRead_SinceLastFreePassState;
                continue;
            }
            if (!parsableString.reachedEndOfString() && runnerState.mNextState.mChar == parsableString.getSubsequentChar()) {
                runnerState = runnerState.mNextState;
                ++parsableString.mIndex;
                ++numberOfParsedCharactersRead_SinceLastFreePassState;
                continue;
            }
            if (runnerState.mLastFreeRangeState != null) {
                runnerState = runnerState.mLastFreeRangeState;
                ++parsableString.mIndex;
                ++numberOfParsedCharactersRead_SinceLastFreePassState;
                continue;
            }
            if (this.mDebugging) {
                this.out.println("the next state does not represent the same character as the next character in the string to test, and there are no last-free-range-state - rejection!");
            }
            return false;
        }
        if (this.mDebugging) {
            this.out.println("finished reading parsing string and not at any final state - rejection!");
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (!this.mInitialized) {
            buffer.append(this.getClass().getName());
            buffer.append(":  Not initialized properly!");
            buffer.append("\n");
            buffer.append("\n");
        } else {
            WildcardStringParserState runnerState = this.mInitialState;
            buffer.append(this.getClass().getName());
            buffer.append(":  String mask ");
            buffer.append(this.mStringMask);
            buffer.append("\n");
            buffer.append("\n");
            buffer.append("      Automaton: ");
            while (runnerState != null) {
                buffer.append(runnerState.mAutomatonStateNumber);
                buffer.append(": ");
                buffer.append(runnerState.mChar);
                buffer.append(" (");
                if (runnerState.mLastFreeRangeState != null) {
                    buffer.append(runnerState.mLastFreeRangeState.mAutomatonStateNumber);
                } else {
                    buffer.append("-");
                }
                buffer.append(")");
                if (runnerState.mNextState != null) {
                    buffer.append("   -->   ");
                }
                runnerState = runnerState.mNextState;
            }
            buffer.append("\n");
            buffer.append("      Format: <state index>: <character> (<last free state>)");
            buffer.append("\n");
            buffer.append("      Number of strings parsed: " + this.mTotalNumberOfStringsParsed);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public boolean equals(Object pObject) {
        if (pObject instanceof WildcardStringParser) {
            WildcardStringParser externalParser = (WildcardStringParser)pObject;
            return externalParser.mInitialized == this.mInitialized && externalParser.mStringMask == this.mStringMask;
        }
        return super.equals(pObject);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected Object clone() throws CloneNotSupportedException {
        if (this.mInitialized) {
            return new WildcardStringParser(this.mStringMask);
        }
        return null;
    }

    protected void finalize() throws Throwable {
    }

    class ParsableString {
        char[] mCharArray;
        int mIndex;

        ParsableString(String pStringToParse) {
            if (pStringToParse != null) {
                this.mCharArray = pStringToParse.toCharArray();
            }
            this.mIndex = -1;
        }

        boolean reachedEndOfString() {
            return this.mIndex == this.mCharArray.length - 1;
        }

        int length() {
            return this.mCharArray.length;
        }

        char getActiveChar() {
            if (this.mIndex > -1 && this.mIndex < this.mCharArray.length) {
                return this.mCharArray[this.mIndex];
            }
            System.err.println(this.getClass().getName() + ": trying to access character outside character array!");
            return ' ';
        }

        char getSubsequentChar() {
            if (this.mIndex > -1 && this.mIndex + 1 < this.mCharArray.length) {
                return this.mCharArray[this.mIndex + 1];
            }
            System.err.println(this.getClass().getName() + ": trying to access character outside character array!");
            return ' ';
        }

        boolean checkString() {
            if (!this.isEmpty()) {
                for (int i = 0; i < this.mCharArray.length; ++i) {
                    if (WildcardStringParser.isInAlphabet(this.mCharArray[i])) continue;
                    return false;
                }
            }
            return true;
        }

        boolean isEmpty() {
            return this.mCharArray == null || this.mCharArray.length == 0;
        }

        public String toString() {
            return new String(this.mCharArray);
        }
    }

    class WildcardStringParserState {
        int mAutomatonStateNumber;
        char mChar;
        WildcardStringParserState mPreviousState;
        WildcardStringParserState mNextState;
        WildcardStringParserState mLastFreeRangeState;

        public WildcardStringParserState(char pChar) {
            this.mChar = pChar;
        }
    }
}

