/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util.convert;

import com.twelvemonkeys.util.convert.ConversionException;
import com.twelvemonkeys.util.convert.Converter;
import com.twelvemonkeys.util.convert.MissingTypeException;
import com.twelvemonkeys.util.convert.NoAvailableConverterException;
import com.twelvemonkeys.util.convert.PropertyConverter;

class ConverterImpl
extends Converter {
    ConverterImpl() {
    }

    private PropertyConverter getConverterForType(Class pType) {
        Class cl = pType;
        do {
            Object converter;
            if ((converter = ConverterImpl.getInstance().mConverters.get(cl)) == null) continue;
            return (PropertyConverter)converter;
        } while ((cl = cl.getSuperclass()) != null);
        return null;
    }

    public Object toObject(String pString, Class pType, String pFormat) throws ConversionException {
        if (pString == null) {
            return null;
        }
        if (pType == null) {
            throw new MissingTypeException();
        }
        PropertyConverter converter = this.getConverterForType(pType);
        if (converter == null) {
            throw new NoAvailableConverterException("Cannot convert to object, no converter available for type \"" + pType.getName() + "\"");
        }
        return converter.toObject(pString, pType, pFormat);
    }

    public String toString(Object pBean, String pFormat) throws ConversionException {
        if (pBean == null) {
            return null;
        }
        PropertyConverter converter = this.getConverterForType(pBean.getClass());
        if (converter == null) {
            throw new NoAvailableConverterException("Cannot object to string, no converter available for type \"" + pBean.getClass().getName() + "\"");
        }
        return converter.toString(pBean, pFormat);
    }
}

