/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.util.CollectionUtil;
import com.twelvemonkeys.xml.XMLSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLProperties
extends Properties {
    public static final String UTF_8_ENCODING = "UTF-8";
    public static final String XMLNS = "xmlns";
    public static final String PROPERTIES = "properties";
    public static final String PROPERTY = "property";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_VALUE = "value";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_FORMAT = "format";
    public static final String DEFAULT_TYPE = "String";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd hh:mm:ss.SSS";
    public static final String DTD = "<!ELEMENT properties (property*)>\n<!ELEMENT property (value?, property*)>\n<!ATTLIST property\n\tname  CDATA #REQUIRED\n\tvalue CDATA #IMPLIED\n\ttype  CDATA \"String\"\n>\n<!ELEMENT value (#PCDATA)>\n<!ATTLIST value\n\ttype  CDATA \"String\"\n>";
    public static final String SYSTEM_DTD_URI = "http://www.twelvemonkeys.com/xml/XMLProperties.dtd";
    public static final String NAMESPACE_URI = "http://www.twelvemonkeys.com/xml/XMLProperties";
    public static final String SAX_VALIDATION_URI = "http://xml.org/sax/features/validation";
    private boolean mValidation = true;
    protected Vector mErrors = null;
    protected Vector mWarnings = null;
    protected Hashtable mFormats = new Hashtable();
    protected static DateFormat sDefaultFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");

    public XMLProperties() {
    }

    public XMLProperties(Properties pDefaults) {
        super(pDefaults);
    }

    void addXMLError(SAXParseException pException) {
        if (this.mErrors == null) {
            this.mErrors = new Vector();
        }
        this.mErrors.add(pException);
    }

    public SAXParseException[] getXMLErrors() {
        if (this.mErrors == null) {
            return null;
        }
        return this.mErrors.toArray(new SAXParseException[this.mErrors.size()]);
    }

    void addXMLWarning(SAXParseException pException) {
        if (this.mWarnings == null) {
            this.mWarnings = new Vector();
        }
        this.mWarnings.add(pException);
    }

    public SAXParseException[] getXMLWarnings() {
        if (this.mWarnings == null) {
            return null;
        }
        return this.mWarnings.toArray(new SAXParseException[this.mWarnings.size()]);
    }

    public synchronized void load(InputStream pInput) throws IOException {
        XMLReader parser;
        String driver = System.getProperty("org.xml.sax.driver");
        if (driver == null) {
            driver = "org.apache.xerces.parsers.SAXParser";
        }
        try {
            parser = XMLReaderFactory.createXMLReader(driver);
            parser.setFeature(SAX_VALIDATION_URI, this.mValidation);
        }
        catch (SAXNotRecognizedException saxnre) {
            throw new RuntimeException("Error configuring XML parser \"" + driver + "\": " + saxnre.getClass().getName() + ": " + saxnre.getMessage());
        }
        catch (SAXException saxe) {
            throw new RuntimeException("Error creating XML parser \"" + driver + "\": " + saxe.getClass().getName() + ": " + saxe.getMessage());
        }
        PropertiesHandler handler = new PropertiesHandler(this);
        parser.setContentHandler(handler);
        parser.setErrorHandler(handler);
        parser.setDTDHandler(handler);
        parser.setEntityResolver(handler);
        try {
            parser.parse(new InputSource(pInput));
        }
        catch (SAXParseException saxpe) {
            throw new IOException("Error parsing XML: " + saxpe.getClass().getName() + ": " + saxpe.getMessage() + " Line: " + saxpe.getLineNumber() + " Column: " + saxpe.getColumnNumber());
        }
        catch (SAXException saxe) {
            throw new IOException("Error parsing XML: " + saxe.getClass().getName() + ": " + saxe.getMessage());
        }
    }

    protected Object initPropertyValue(String pValue, String pType, String pFormat) throws ClassNotFoundException {
        Class<?> cl;
        Object value;
        if (pValue == null) {
            return null;
        }
        if (pType == null || pType.equals(DEFAULT_TYPE) || pType.equals("java.lang.String")) {
            return pValue;
        }
        if (pType.equals("Date") || pType.equals("java.util.Date")) {
            Date value2 = pFormat == null ? StringUtil.toDate(pValue, sDefaultFormat) : StringUtil.toDate(pValue, new SimpleDateFormat(pFormat));
            return value2;
        }
        if (pType.equals("java.sql.Timestamp")) {
            Timestamp value3;
            try {
                value3 = StringUtil.toTimestamp(pValue);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e.getMessage());
            }
            return value3;
        }
        int dot = pType.indexOf(".");
        if (dot < 0) {
            pType = "java.lang." + pType;
        }
        if ((value = this.createInstance(cl = Class.forName(pType), pValue)) == null) {
            value = this.invokeStaticMethod(cl, "valueOf", pValue);
        }
        return value;
    }

    private Object createInstance(Class pClass, Object pParam) {
        Object value;
        try {
            Class[] param = new Class[]{pParam.getClass()};
            Object[] arg = new Object[]{pParam};
            Constructor constructor = pClass.getDeclaredConstructor(param);
            value = constructor.newInstance(arg);
        }
        catch (Exception e) {
            return null;
        }
        return value;
    }

    private Object invokeStaticMethod(Class pClass, String pMethod, Object pParam) {
        Object value = null;
        try {
            Class[] param = new Class[]{pParam.getClass()};
            Object[] arg = new Object[]{pParam};
            Method method = pClass.getMethod(pMethod, param);
            if (Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers())) {
                value = method.invoke(null, arg);
            }
        }
        catch (Exception e) {
            return null;
        }
        return value;
    }

    public String getPropertyFormat(String pKey) {
        return StringUtil.valueOf(this.mFormats.get(pKey));
    }

    public synchronized String setPropertyFormat(String pKey, String pFormat) {
        return StringUtil.valueOf(this.mFormats.put(pKey, pFormat));
    }

    public synchronized Object setPropertyValue(String pKey, Object pValue) {
        return this.put(pKey, pValue);
    }

    public synchronized Object getPropertyValue(String pKey) {
        return this.getPropertyValue(pKey, null);
    }

    public Object getPropertyValue(String pKey, Object pDefaultValue) {
        Object value = super.get(pKey);
        if (value != null) {
            return value;
        }
        if (this.defaults instanceof XMLProperties) {
            return ((XMLProperties)this.defaults).getPropertyValue(pKey);
        }
        return this.defaults != null ? this.defaults.getProperty(pKey) : pDefaultValue;
    }

    public Object get(Object pKey) {
        Object value = super.get(pKey);
        if (value != null && value instanceof Date) {
            String format = this.getPropertyFormat(StringUtil.valueOf(pKey));
            value = format != null ? new SimpleDateFormat(format).format(value) : sDefaultFormat.format(value);
            return value;
        }
        return StringUtil.valueOf(value);
    }

    public String getProperty(String pKey, String pDefaultValue) {
        String value = (String)this.get(pKey);
        if (value != null) {
            return value;
        }
        return this.defaults != null ? this.defaults.getProperty(pKey) : pDefaultValue;
    }

    public String getProperty(String pKey) {
        return this.getProperty(pKey, null);
    }

    public synchronized void store(OutputStream pOutput, String pHeader) throws IOException {
        XMLProperties.storeXML(this, pOutput, pHeader);
    }

    public static void storeProperties(Map pProperties, OutputStream pOutput, String pHeader) throws IOException {
        Properties props = new Properties();
        for (Map.Entry entry : pProperties.entrySet()) {
            props.setProperty((String)entry.getKey(), StringUtil.valueOf(entry.getValue()));
        }
        props.store(pOutput, pHeader);
    }

    public static void storeXML(Map pProperties, OutputStream pOutput, String pHeader) throws IOException {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        DOMImplementation dom = builder.getDOMImplementation();
        Document document = dom.createDocument(null, PROPERTIES, dom.createDocumentType(PROPERTIES, null, SYSTEM_DTD_URI));
        Element root = document.getDocumentElement();
        root.setAttribute(XMLNS, NAMESPACE_URI);
        if (pHeader != null) {
            document.insertBefore(document.createComment(" " + pHeader + " "), root);
        }
        document.insertBefore(document.createComment(" " + new Date() + " "), root);
        for (Map.Entry entry : pProperties.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            String format = null;
            if (pProperties instanceof XMLProperties) {
                format = ((XMLProperties)pProperties).getPropertyFormat(key);
            }
            XMLProperties.insertElement(document, key, value, format);
        }
        XMLSerializer serializer = new XMLSerializer(pOutput, UTF_8_ENCODING);
        serializer.serialize(document);
    }

    private static void insertElement(Document pDocument, String pName, Object pValue, String pFormat) {
        String[] names = StringUtil.toStringArray(pName, ".");
        String value = null;
        if (pValue != null) {
            value = pValue instanceof Date ? (pFormat != null ? new SimpleDateFormat(pFormat).format(pValue) : sDefaultFormat.format(pValue)) : String.valueOf(pValue);
        }
        Element element = pDocument.getDocumentElement();
        for (int i = 0; i < names.length; ++i) {
            boolean found = false;
            NodeList children = element.getElementsByTagName(PROPERTY);
            Element child = null;
            for (int j = 0; j < children.getLength(); ++j) {
                child = (Element)children.item(j);
                if (!names[i].equals(child.getAttribute(PROPERTY_NAME))) continue;
                found = true;
                element = child;
                break;
            }
            if (!found) {
                child = pDocument.createElement(PROPERTY);
                child.setAttribute(PROPERTY_NAME, names[i]);
                element.appendChild(child);
                element = child;
            }
            if (i + 1 != names.length) continue;
            if (StringUtil.contains(value, "\n") || StringUtil.contains(value, "\t") || StringUtil.contains(value, "\"") || StringUtil.contains(value, "&") || StringUtil.contains(value, "<") || StringUtil.contains(value, ">")) {
                Element valueElement = pDocument.createElement(PROPERTY_VALUE);
                String className = pValue.getClass().getName();
                if (!DEFAULT_TYPE.equals(className = StringUtil.replace(className, "java.lang.", ""))) {
                    valueElement.setAttribute(PROPERTY_TYPE, className);
                }
                if (pFormat != null) {
                    valueElement.setAttribute(PROPERTY_FORMAT, pFormat);
                }
                CDATASection cdata = pDocument.createCDATASection(value);
                valueElement.appendChild(cdata);
                child.appendChild(valueElement);
                continue;
            }
            child.setAttribute(PROPERTY_VALUE, value);
            String className = pValue.getClass().getName();
            className = StringUtil.replace(className, "java.lang.", "");
            if (!DEFAULT_TYPE.equals(className)) {
                child.setAttribute(PROPERTY_TYPE, className);
            }
            if (pFormat == null) continue;
            child.setAttribute(PROPERTY_FORMAT, pFormat);
        }
    }

    public Properties getProperties(String pGroupKey) {
        XMLProperties props = new XMLProperties();
        String groupKey = pGroupKey;
        if (groupKey.charAt(groupKey.length()) != '.') {
            groupKey = groupKey + ".";
        }
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(groupKey)) continue;
            String subKey = key.substring(key.indexOf(groupKey));
            props.setPropertyValue(subKey, entry.getValue());
        }
        return props.size() > 0 ? props : null;
    }

    public Properties setProperties(String pGroupKey, Properties pProperties) {
        XMLProperties old = new XMLProperties();
        String groupKey = pGroupKey;
        if (groupKey.charAt(groupKey.length()) != '.') {
            groupKey = groupKey + ".";
        }
        for (Map.Entry<Object, Object> entry : pProperties.entrySet()) {
            String key = (String)entry.getKey();
            Object obj = this.setPropertyValue(groupKey + key, entry.getValue());
            if (obj == null) continue;
            old.setPropertyValue(groupKey + key, entry.getValue());
        }
        return old.size() > 0 ? old : null;
    }

    public static void main(String[] pArgs) throws Exception {
        System.out.println("DTD: \n<!ELEMENT properties (property*)>\n<!ELEMENT property (value?, property*)>\n<!ATTLIST property\n\tname  CDATA #REQUIRED\n\tvalue CDATA #IMPLIED\n\ttype  CDATA \"String\"\n>\n<!ELEMENT value (#PCDATA)>\n<!ATTLIST value\n\ttype  CDATA \"String\"\n>");
        System.out.println("--");
        System.out.println("Reading properties from \"" + pArgs[0] + "\"...");
        XMLProperties props = new XMLProperties();
        props.load(new FileInputStream(new File(pArgs[0])));
        props.list(System.out);
        System.out.println("--");
        String key = "key";
        Object old = props.setProperty(key, "AAA");
        XMLProperties p1 = new XMLProperties(new XMLProperties(props));
        Properties p2 = new Properties(new Properties(props));
        System.out.println("XMLProperties: " + ((Properties)p1).getProperty(key) + " ==" + " Properties: " + p2.getProperty(key));
        if (old == null) {
            props.remove("key");
        } else {
            props.put("key", old);
        }
        System.out.println("--");
        File out = new File("copy_of_" + pArgs[0]);
        System.out.println("Writing properties to \"" + out.getName() + "\"");
        if (!out.exists()) {
            props.store(new FileOutputStream(out), "XML Properties file written by XMLProperties.");
        } else {
            System.err.println("File \"" + out.getName() + "\" allready exists, cannot write!");
        }
        out = new File("copy_of_" + pArgs[0].substring(0, pArgs[0].lastIndexOf(".")) + ".properties");
        System.out.println("Writing properties to \"" + out.getName() + "\"");
        if (!out.exists()) {
            XMLProperties.storeProperties(props, new FileOutputStream(out), "Properties file written by XMLProperties.");
        } else {
            System.err.println("File \"" + out.getName() + "\" allready exists, cannot write!");
        }
        System.out.println("--");
        System.out.println("getPropertyValue(\"one\"): " + props.getPropertyValue("one") + " class: " + props.getPropertyValue("one").getClass());
        System.out.println("setPropertyValue(\"now\", " + new Date() + "): " + props.setPropertyValue("now", new Date()) + " class: " + props.getPropertyValue("now").getClass());
        System.out.println("getPropertyValue(\"date\"): " + props.getPropertyValue("date") + " class: " + props.getPropertyValue("date").getClass());
        System.out.println("getPropertyValue(\"time\"): " + props.getPropertyValue("time") + " class: " + props.getPropertyValue("time").getClass());
    }

    protected class PropertiesHandler
    extends DefaultHandler {
        protected Stack mStack = null;
        protected char[] mReadSoFar = null;
        protected boolean mIsValue = false;
        protected String mType = null;
        protected String mFormat = null;
        protected XMLProperties mProperties = null;
        protected Locator mLocator = null;

        PropertiesHandler(XMLProperties pProperties) {
            this.mProperties = pProperties;
            this.mStack = new Stack();
        }

        public void setDocumentLocator(Locator pLocator) {
            this.mLocator = pLocator;
        }

        public void error(SAXParseException pException) throws SAXParseException {
            this.mProperties.addXMLError(pException);
        }

        public void fatalError(SAXParseException pException) throws SAXParseException {
            throw pException;
        }

        public void warning(SAXParseException pException) throws SAXParseException {
            this.mProperties.addXMLWarning(pException);
        }

        public void startElement(String pNamespaceURI, String pLocalName, String pQualifiedName, Attributes pAttributes) throws SAXException {
            if (XMLProperties.PROPERTY.equals(pLocalName)) {
                String name = pAttributes.getValue(XMLProperties.PROPERTY_NAME);
                String value = pAttributes.getValue(XMLProperties.PROPERTY_VALUE);
                String type = pAttributes.getValue(XMLProperties.PROPERTY_TYPE);
                String format = pAttributes.getValue(XMLProperties.PROPERTY_FORMAT);
                if (!this.mStack.isEmpty()) {
                    name = (String)this.mStack.peek() + "." + name;
                }
                if (value != null) {
                    this.mProperties.setProperty(name, value);
                    if (!XMLProperties.DEFAULT_TYPE.equals(type)) {
                        this.mType = type;
                        this.mFormat = format;
                    }
                }
                this.mStack.push(name);
            } else if (XMLProperties.PROPERTY_VALUE.equals(pLocalName)) {
                String name = (String)this.mStack.peek();
                String type = pAttributes.getValue(XMLProperties.PROPERTY_TYPE);
                String format = pAttributes.getValue(XMLProperties.PROPERTY_FORMAT);
                if (!XMLProperties.DEFAULT_TYPE.equals(type)) {
                    this.mType = type;
                    this.mFormat = format;
                }
                this.mIsValue = true;
            }
        }

        public void endElement(String pNamespaceURI, String pLocalName, String pQualifiedName) throws SAXException {
            if (XMLProperties.PROPERTY.equals(pLocalName)) {
                String name = (String)this.mStack.pop();
                try {
                    String prop = this.mProperties.getProperty(name);
                    if (prop != null) {
                        Object value = this.mProperties.initPropertyValue(prop, this.mType, this.mFormat);
                        if (this.mFormat != null && !XMLProperties.DEFAULT_DATE_FORMAT.equals(this.mFormat)) {
                            this.mProperties.setPropertyFormat(name, this.mFormat);
                        }
                        this.mProperties.setPropertyValue(name, value);
                    }
                    this.mType = null;
                    this.mFormat = null;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    throw new SAXException(e);
                }
            } else if (XMLProperties.PROPERTY_VALUE.equals(pLocalName)) {
                if (this.mStack.isEmpty()) {
                    return;
                }
                String name = (String)this.mStack.peek();
                String value = new String(this.mReadSoFar);
                if (!StringUtil.isEmpty(value)) {
                    if (this.mProperties.containsKey(name)) {
                        throw new SAXParseException("Value can only be specified either using the \"value\" attribute, OR the \"value\" element, not both.", this.mLocator);
                    }
                    this.mProperties.setProperty(name, value);
                }
                this.mIsValue = false;
            }
        }

        public void characters(char[] pChars, int pStart, int pLength) throws SAXException {
            if (this.mIsValue) {
                if (this.mReadSoFar == null) {
                    this.mReadSoFar = new char[pLength];
                    System.arraycopy(pChars, pStart, this.mReadSoFar, 0, pLength);
                } else {
                    this.mReadSoFar = (char[])CollectionUtil.mergeArrays(this.mReadSoFar, 0, this.mReadSoFar.length, pChars, pStart, pLength);
                }
            }
        }

        public InputSource resolveEntity(String pPublicId, String pSystemId) {
            if (XMLProperties.SYSTEM_DTD_URI.equals(pSystemId)) {
                return new InputSource(new StringReader(XMLProperties.DTD));
            }
            return null;
        }
    }
}

