/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import com.twelvemonkeys.util.ExpiringMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUHashMap<K, V>
extends LinkedHashMap<K, V>
implements ExpiringMap<K, V> {
    private int mMaxSize = 1000;
    private float mTrimFactor = 0.01f;

    public LRUHashMap() {
        super(16, 0.75f, true);
    }

    public LRUHashMap(int pMaxSize) {
        super(16, 0.75f, true);
        this.setMaxSize(pMaxSize);
    }

    public LRUHashMap(Map<? extends K, ? extends V> pContents) {
        super(16, 0.75f, true);
        this.putAll(pContents);
    }

    public LRUHashMap(Map<? extends K, ? extends V> pContents, int pMaxSize) {
        super(16, 0.75f, true);
        this.setMaxSize(pMaxSize);
        this.putAll(pContents);
    }

    public int getMaxSize() {
        return this.mMaxSize;
    }

    public void setMaxSize(int pMaxSize) {
        if (pMaxSize < 0) {
            throw new IllegalArgumentException("max size must be positive");
        }
        this.mMaxSize = pMaxSize;
        while (this.size() > this.mMaxSize) {
            this.removeLRU();
        }
    }

    public float getTrimFactor() {
        return this.mTrimFactor;
    }

    public void setTrimFactor(float pTrimFactor) {
        if (pTrimFactor < 0.0f || pTrimFactor >= 1.0f) {
            throw new IllegalArgumentException("trim factor must be between 0 and 1");
        }
        this.mTrimFactor = pTrimFactor;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> pEldest) {
        if (this.size() >= this.mMaxSize) {
            this.removeLRU();
        }
        return false;
    }

    @Override
    public void processRemoved(Map.Entry<K, V> pRemoved) {
    }

    public void removeLRU() {
        int removeCount = (int)Math.max((float)this.size() * this.mTrimFactor, 1.0f);
        Iterator entries = this.entrySet().iterator();
        while (removeCount-- > 0 && entries.hasNext()) {
            entries.next();
            entries.remove();
        }
    }
}

