/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.net;

import com.twelvemonkeys.io.FileUtil;
import com.twelvemonkeys.lang.DateUtil;
import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.net.HttpURLConnection;
import com.twelvemonkeys.net.SimpleAuthenticator;
import com.twelvemonkeys.util.BASE64;
import com.twelvemonkeys.util.CollectionUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public final class NetUtil {
    private static final String VERSION_ID = "NetUtil/2.1";
    private static Authenticator sAuthenticator = null;
    private static final int BUF_SIZE = 8192;
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String HTTP_GET = "GET";
    public static final String HTTP_POST = "POST";
    public static final String HTTP_HEAD = "HEAD";
    public static final String HTTP_OPTIONS = "OPTIONS";
    public static final String HTTP_PUT = "PUT";
    public static final String HTTP_DELETE = "DELETE";
    public static final String HTTP_TRACE = "TRACE";
    private static final SimpleDateFormat HTTP_RFC1123_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    private static final SimpleDateFormat HTTP_RFC850_FORMAT;
    private static final SimpleDateFormat HTTP_ASCTIME_FORMAT;
    private static long sNext50YearWindowChange;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void update50YearWindowIfNeeded() {
        long next = sNext50YearWindowChange;
        if (next < System.currentTimeMillis()) {
            sNext50YearWindowChange = next += 86400000L;
            Date startDate = new Date(next - 1577847600000L);
            SimpleDateFormat simpleDateFormat = HTTP_RFC850_FORMAT;
            synchronized (simpleDateFormat) {
                HTTP_RFC850_FORMAT.set2DigitYearStart(startDate);
            }
            simpleDateFormat = HTTP_ASCTIME_FORMAT;
            synchronized (simpleDateFormat) {
                HTTP_ASCTIME_FORMAT.set2DigitYearStart(startDate);
            }
        }
    }

    private NetUtil() {
    }

    public static void main1(String[] args) {
        String timeStr;
        String string = timeStr = args.length > 0 && !StringUtil.isNumber(args[0]) ? args[0] : null;
        long time = args.length > 0 ? (timeStr != null ? NetUtil.parseHTTPDate(timeStr) : Long.parseLong(args[0])) : System.currentTimeMillis();
        System.out.println(timeStr + " --> " + time + " --> " + NetUtil.formatHTTPDate(time));
    }

    public static void main(String[] pArgs) throws IOException {
        OutputStream os;
        int timeout = 0;
        boolean followRedirects = true;
        boolean debugHeaders = false;
        String requestPropertiesFile = null;
        String requestHeaders = null;
        String postData = null;
        File putData = null;
        int argIdx = 0;
        boolean errArgs = false;
        boolean writeToFile = false;
        boolean writeToStdOut = false;
        String outFileName = null;
        while (argIdx < pArgs.length && pArgs[argIdx].charAt(0) == '-' && pArgs[argIdx].length() >= 2) {
            if (pArgs[argIdx].charAt(1) == 't' || pArgs[argIdx].equals("--timeout")) {
                ++argIdx;
                try {
                    timeout = Integer.parseInt(pArgs[argIdx++]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    errArgs = true;
                    break;
                }
            }
            if (pArgs[argIdx].charAt(1) == 'd' || pArgs[argIdx].equals("--debugheaders")) {
                debugHeaders = true;
                ++argIdx;
                continue;
            }
            if (pArgs[argIdx].charAt(1) == 'n' || pArgs[argIdx].equals("--nofollowredirects")) {
                followRedirects = false;
                ++argIdx;
                continue;
            }
            if (pArgs[argIdx].charAt(1) == 'r' || pArgs[argIdx].equals("--requestproperties")) {
                int n = ++argIdx;
                ++argIdx;
                requestPropertiesFile = pArgs[n];
                continue;
            }
            if (pArgs[argIdx].charAt(1) == 'p' || pArgs[argIdx].equals("--postdata")) {
                int n = ++argIdx;
                ++argIdx;
                postData = pArgs[n];
                continue;
            }
            if (pArgs[argIdx].charAt(1) == 'u' || pArgs[argIdx].equals("--putdata")) {
                int n = ++argIdx;
                ++argIdx;
                putData = new File(pArgs[n]);
                if (putData.exists()) continue;
                errArgs = true;
                break;
            }
            if (pArgs[argIdx].charAt(1) == 'h' || pArgs[argIdx].equals("--header")) {
                int n = ++argIdx;
                ++argIdx;
                requestHeaders = pArgs[n];
                continue;
            }
            if (pArgs[argIdx].charAt(1) == 'f' || pArgs[argIdx].equals("--file")) {
                writeToFile = true;
                if (++argIdx >= pArgs.length - 1 || pArgs[argIdx].charAt(0) == '-') continue;
                outFileName = pArgs[argIdx++];
                continue;
            }
            if (pArgs[argIdx].charAt(1) == 'o' || pArgs[argIdx].equals("--output")) {
                ++argIdx;
                writeToStdOut = true;
                continue;
            }
            System.err.println("Unknown option \"" + pArgs[argIdx++] + "\"");
        }
        if (errArgs || pArgs.length < argIdx + 1) {
            System.err.println("Usage: java  NetUtil [-f|--file [<file name>]] [-d|--debugheaders] [-h|--header <header data>] [-p|--postdata <URL-encoded postdata>] [-u|--putdata <file name>] [-r|--requestProperties <properties file>] [-t|--timeout <miliseconds>] [-n|--nofollowredirects] fromUrl");
            System.exit(5);
        }
        String url = pArgs[argIdx];
        Properties requestProperties = new Properties();
        if (requestPropertiesFile != null) {
            requestProperties.load(new FileInputStream(new File(requestPropertiesFile)));
        }
        if (requestHeaders != null) {
            String[] headerPairs;
            for (String headerPair : headerPairs = StringUtil.toStringArray(requestHeaders, ",")) {
                String value;
                String[] pair = StringUtil.toStringArray(headerPair, ":");
                String key = pair.length > 0 ? pair[0].trim() : null;
                String string = value = pair.length > 1 ? pair[1].trim() : "";
                if (key == null) continue;
                requestProperties.setProperty(key, value);
            }
        }
        URL reqURL = NetUtil.getURLAndSetAuthorization(url, requestProperties);
        java.net.HttpURLConnection conn = NetUtil.createHttpURLConnection(reqURL, requestProperties, followRedirects, timeout);
        if (postData != null) {
            conn.setRequestMethod(HTTP_POST);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", String.valueOf(postData.length()));
            conn.setRequestProperty("Content-Encoding", "ISO-8859-1");
            OutputStream os2 = conn.getOutputStream();
            System.err.println("OutputStream: " + os2.getClass().getName() + "@" + System.identityHashCode(os2));
            OutputStreamWriter writer = new OutputStreamWriter(os2, "ISO-8859-1");
            writer.write(postData);
            writer.write("\r\n");
            writer.close();
        } else if (putData != null) {
            conn.setRequestMethod(HTTP_PUT);
            conn.setRequestProperty("Content-Length", String.valueOf(putData.length()));
            OutputStream os3 = conn.getOutputStream();
            System.err.println("OutputStream: " + os3.getClass().getName() + "@" + System.identityHashCode(os3));
            FileUtil.copy(new FileInputStream(putData), os3);
            os3.close();
        }
        InputStream is = conn.getResponseCode() == 200 ? conn.getInputStream() : conn.getErrorStream();
        if (debugHeaders) {
            String key;
            System.err.println("Request (debug):");
            System.err.println(conn.getClass());
            System.err.println("Response (debug):");
            System.err.println(conn.getHeaderField(0));
            int i = 1;
            while ((key = conn.getHeaderFieldKey(i)) != null) {
                System.err.println(key + ": " + conn.getHeaderField(key));
                ++i;
            }
        }
        if (writeToFile) {
            File outFile;
            if (outFileName == null) {
                int idx;
                outFileName = reqURL.getFile();
                if (StringUtil.isEmpty(outFileName) && StringUtil.isEmpty(outFileName = conn.getHeaderField("Location"))) {
                    outFileName = "index";
                    String ext = conn.getContentType();
                    if (!StringUtil.isEmpty(ext)) {
                        int idx2 = ext.lastIndexOf(47);
                        if (idx2 >= 0) {
                            ext = ext.substring(idx2 + 1);
                        }
                        if ((idx2 = ext.indexOf(59)) >= 0) {
                            ext = ext.substring(0, idx2);
                        }
                        outFileName = outFileName + "." + ext;
                    }
                }
                if ((idx = outFileName.lastIndexOf(47)) >= 0) {
                    outFileName = outFileName.substring(idx + 1);
                }
                if ((idx = outFileName.indexOf(63)) >= 0) {
                    outFileName = outFileName.substring(0, idx);
                }
            }
            if (!(outFile = new File(outFileName)).createNewFile()) {
                if (outFile.exists()) {
                    System.err.println("Cannot write to file " + outFile.getAbsolutePath() + ", file allready exists.");
                } else {
                    System.err.println("Cannot write to file " + outFile.getAbsolutePath() + ", check write permissions.");
                }
                System.exit(5);
            }
            os = new FileOutputStream(outFile);
        } else {
            os = writeToStdOut ? System.out : null;
        }
        if ((writeToFile || writeToStdOut) && is != null) {
            FileUtil.copy(is, os);
        }
    }

    public static boolean isHttpURL(String pURL) {
        return pURL != null && pURL.startsWith(HTTP);
    }

    public static boolean isHttpURL(URL pURL) {
        return pURL != null && pURL.getProtocol().equals(HTTP_PROTOCOL);
    }

    public static byte[] getBytesHttp(String pURL) throws IOException {
        return NetUtil.getBytesHttp(pURL, 0);
    }

    public static byte[] getBytesHttp(URL pURL) throws IOException {
        return NetUtil.getBytesHttp(pURL, 0);
    }

    public static InputStream getInputStreamHttp(String pURL) throws IOException {
        return NetUtil.getInputStreamHttp(pURL, 0);
    }

    public static InputStream getInputStreamHttp(URL pURL) throws IOException {
        return NetUtil.getInputStreamHttp(pURL, 0);
    }

    public static InputStream getInputStreamHttp(String pURL, int pTimeout) throws IOException {
        return NetUtil.getInputStreamHttp(pURL, null, true, pTimeout);
    }

    public static InputStream getInputStreamHttp(String pURL, Properties pProperties, boolean pFollowRedirects, int pTimeout) throws IOException {
        Properties properties = pProperties != null ? pProperties : new Properties();
        URL url = NetUtil.getURLAndSetAuthorization(pURL, properties);
        return NetUtil.getInputStreamHttp(url, properties, pFollowRedirects, pTimeout);
    }

    private static URL getURLAndSetAuthorization(String pURL, Properties pProperties) throws MalformedURLException {
        String url = pURL;
        String userPass = null;
        String protocolPrefix = HTTP;
        int httpIdx = url.indexOf(HTTPS);
        if (httpIdx >= 0) {
            protocolPrefix = HTTPS;
            url = url.substring(httpIdx + HTTPS.length());
        } else {
            httpIdx = url.indexOf(HTTP);
            if (httpIdx >= 0) {
                url = url.substring(httpIdx + HTTP.length());
            }
        }
        int atIdx = url.indexOf("@");
        if (atIdx >= 0) {
            userPass = url.substring(0, atIdx);
            url = url.substring(atIdx + 1);
        }
        if (userPass != null) {
            pProperties.setProperty("Authorization", "Basic " + BASE64.encode(userPass.getBytes()));
        }
        return new URL(protocolPrefix + url);
    }

    public static InputStream getInputStreamHttp(URL pURL, int pTimeout) throws IOException {
        return NetUtil.getInputStreamHttp(pURL, null, true, pTimeout);
    }

    public static InputStream getInputStreamHttp(URL pURL, Properties pProperties, boolean pFollowRedirects, int pTimeout) throws IOException {
        java.net.HttpURLConnection conn = NetUtil.createHttpURLConnection(pURL, pProperties, pFollowRedirects, pTimeout);
        conn.setRequestMethod(HTTP_GET);
        InputStream is = conn.getInputStream();
        if (conn.getResponseCode() != 200) {
            throw new IOException("The request gave the response: " + conn.getResponseCode() + ": " + conn.getResponseMessage());
        }
        return is;
    }

    public static InputStream getInputStreamHttpPost(String pURL, Map pPostData, Properties pProperties, boolean pFollowRedirects, int pTimeout) throws IOException {
        pProperties = pProperties != null ? pProperties : new Properties();
        URL url = NetUtil.getURLAndSetAuthorization(pURL, pProperties);
        return NetUtil.getInputStreamHttpPost(url, pPostData, pProperties, pFollowRedirects, pTimeout);
    }

    public static InputStream getInputStreamHttpPost(URL pURL, Map pPostData, Properties pProperties, boolean pFollowRedirects, int pTimeout) throws IOException {
        String encoding;
        java.net.HttpURLConnection conn = NetUtil.createHttpURLConnection(pURL, pProperties, pFollowRedirects, pTimeout);
        conn.setRequestMethod(HTTP_POST);
        StringBuilder postStr = new StringBuilder();
        if (pPostData != null) {
            Iterator data = pPostData.entrySet().iterator();
            while (data.hasNext()) {
                Map.Entry entry = data.next();
                postStr.append(URLEncoder.encode((String)entry.getKey(), "UTF-8"));
                postStr.append('=');
                postStr.append(URLEncoder.encode(entry.getValue().toString(), "UTF-8"));
                if (!data.hasNext()) continue;
                postStr.append('&');
            }
        }
        if (StringUtil.isEmpty(encoding = conn.getRequestProperty("Content-Encoding"))) {
            encoding = "UTF-8";
        }
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("Content-Length", String.valueOf(postStr.length()));
        conn.setRequestProperty("Content-Encoding", encoding);
        OutputStream os = conn.getOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(os, encoding);
        writer.write(postStr.toString());
        writer.write("\r\n");
        writer.close();
        InputStream is = conn.getInputStream();
        if (conn.getResponseCode() != 200) {
            throw new IOException("The request gave the response: " + conn.getResponseCode() + ": " + conn.getResponseMessage());
        }
        return is;
    }

    public static java.net.HttpURLConnection createHttpURLConnection(URL pURL, Properties pProperties, boolean pFollowRedirects, int pTimeout) throws IOException {
        java.net.HttpURLConnection conn = pTimeout > 0 ? new HttpURLConnection(pURL, pTimeout) : (java.net.HttpURLConnection)pURL.openConnection();
        if (pProperties == null || !pProperties.containsKey("User-Agent")) {
            conn.setRequestProperty("User-Agent", "NetUtil/2.1 (" + System.getProperty("os.name") + "/" + System.getProperty("os.version") + "; " + System.getProperty("os.arch") + "; " + System.getProperty("java.vm.name") + "/" + System.getProperty("java.vm.version") + ")");
        }
        if (pProperties != null) {
            for (Map.Entry<Object, Object> entry : pProperties.entrySet()) {
                conn.setRequestProperty((String)entry.getKey(), entry.getValue().toString());
            }
        }
        try {
            conn.setInstanceFollowRedirects(pFollowRedirects);
        }
        catch (LinkageError le) {
            java.net.HttpURLConnection.setFollowRedirects(pFollowRedirects);
            System.err.println("You are using an old Java Spec, consider upgrading.");
            System.err.println("java.net.HttpURLConnection.setInstanceFollowRedirects(" + pFollowRedirects + ") failed.");
        }
        conn.setDoInput(true);
        conn.setDoOutput(true);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesHttp(String pURL, int pTimeout) throws IOException {
        BufferedInputStream in = new BufferedInputStream(NetUtil.getInputStreamHttp(pURL, pTimeout), 16384);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        try {
            int count;
            while ((count = ((InputStream)in).read(buffer)) != -1) {
                bytes.write(buffer, 0, count);
            }
        }
        finally {
            ((InputStream)in).close();
        }
        return bytes.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesHttp(URL pURL, int pTimeout) throws IOException {
        BufferedInputStream in = new BufferedInputStream(NetUtil.getInputStreamHttp(pURL, pTimeout), 16384);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        try {
            int count;
            while ((count = ((InputStream)in).read(buffer)) != -1) {
                bytes.write(buffer, 0, count);
            }
        }
        finally {
            ((InputStream)in).close();
        }
        return bytes.toByteArray();
    }

    public static synchronized Authenticator registerAuthenticator() {
        if (sAuthenticator != null) {
            return sAuthenticator;
        }
        String authenticatorName = System.getProperty("java.net.Authenticator");
        if (authenticatorName != null) {
            try {
                Class<?> authenticatorClass = Class.forName(authenticatorName);
                sAuthenticator = (Authenticator)authenticatorClass.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (InstantiationException ie) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (sAuthenticator == null) {
            sAuthenticator = SimpleAuthenticator.getInstance();
        }
        Authenticator.setDefault(sAuthenticator);
        return sAuthenticator;
    }

    public static InetAddress createInetAddressFromURL(URL pURL) {
        try {
            return InetAddress.getByName(pURL.getHost());
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static URL createURLFromInetAddress(InetAddress pIP, String pProtocol) {
        try {
            return new URL(pProtocol, pIP.getHostName(), "");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static URL createURLFromInetAddress(InetAddress pIP) {
        return NetUtil.createURLFromInetAddress(pIP, HTTP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] getBytesHttpOld(String pURL) throws IOException {
        BufferedInputStream in = new BufferedInputStream(NetUtil.getInputStreamHttp(pURL), 16384);
        byte[] bytes = new byte[]{};
        byte[] buffer = new byte[8192];
        try {
            int count;
            while ((count = ((InputStream)in).read(buffer)) != -1) {
                bytes = (byte[])CollectionUtil.mergeArrays(bytes, 0, bytes.length, buffer, 0, count);
            }
        }
        finally {
            ((InputStream)in).close();
        }
        return bytes;
    }

    public static String formatHTTPDate(long pTime) {
        return NetUtil.formatHTTPDate(new Date(pTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatHTTPDate(Date pTime) {
        SimpleDateFormat simpleDateFormat = HTTP_RFC1123_FORMAT;
        synchronized (simpleDateFormat) {
            return HTTP_RFC1123_FORMAT.format(pTime);
        }
    }

    public static long parseHTTPDate(String pDate) throws NumberFormatException {
        return NetUtil.parseHTTPDateImpl(pDate).getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date parseHTTPDateImpl(String pDate) throws NumberFormatException {
        Date date;
        SimpleDateFormat format;
        if (pDate == null) {
            throw new IllegalArgumentException("date == null");
        }
        if (StringUtil.isEmpty(pDate)) {
            throw new NumberFormatException("Invalid HTTP date: \"" + pDate + "\"");
        }
        if (pDate.indexOf(45) >= 0) {
            format = HTTP_RFC850_FORMAT;
            NetUtil.update50YearWindowIfNeeded();
        } else if (pDate.indexOf(44) < 0) {
            format = HTTP_ASCTIME_FORMAT;
            NetUtil.update50YearWindowIfNeeded();
        } else {
            format = HTTP_RFC1123_FORMAT;
        }
        try {
            SimpleDateFormat simpleDateFormat = format;
            synchronized (simpleDateFormat) {
                date = format.parse(pDate);
            }
        }
        catch (ParseException e) {
            NumberFormatException nfe = new NumberFormatException("Invalid HTTP date: \"" + pDate + "\"");
            nfe.initCause(e);
            throw nfe;
        }
        if (date == null) {
            throw new NumberFormatException("Invalid HTTP date: \"" + pDate + "\"");
        }
        return date;
    }

    static {
        HTTP_RFC1123_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        HTTP_RFC850_FORMAT = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss z", Locale.US);
        HTTP_ASCTIME_FORMAT = new SimpleDateFormat("EEE MMM d HH:mm:ss yy", Locale.US);
        sNext50YearWindowChange = DateUtil.currentTimeDay();
        HTTP_RFC850_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        HTTP_ASCTIME_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        NetUtil.update50YearWindowIfNeeded();
    }
}

