/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.lang;

public final class MathUtil {
    private static final double LN_10 = Math.log(10.0);
    private static final double LN_2 = Math.log(10.0);

    private MathUtil() {
    }

    public static double toRadians(double pAngDeg) {
        return pAngDeg * Math.PI / 180.0;
    }

    public static double toDegrees(double pAngRad) {
        return pAngRad * 180.0 / Math.PI;
    }

    public static double ln(double pArg) {
        return Math.log(pArg);
    }

    public static double log(double pArg) {
        return Math.log(pArg) / LN_10;
    }

    public static double log2(double pArg) {
        return Math.log(pArg) / LN_2;
    }

    public static double log(double pArg, double pBase) {
        return Math.log(pArg) / Math.log(pBase);
    }

    public static long abs(long pNumber) {
        if (pNumber == Long.MIN_VALUE) {
            throw new ArithmeticException("long overflow: 9223372036854775808");
        }
        return pNumber < 0L ? -pNumber : pNumber;
    }

    public static int abs(int pNumber) {
        if (pNumber == Integer.MIN_VALUE) {
            throw new ArithmeticException("int overflow: 2147483648");
        }
        return pNumber < 0 ? -pNumber : pNumber;
    }
}

