/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.lang;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExceptionUtil {
    static void launder(Throwable pThrowable, Class<? extends Throwable> ... pExpectedTypes) {
        if (pThrowable instanceof Error) {
            throw (Error)pThrowable;
        }
        if (pThrowable instanceof RuntimeException) {
            throw (RuntimeException)pThrowable;
        }
        for (Class<? extends Throwable> expectedType : pExpectedTypes) {
            if (!expectedType.isInstance(pThrowable)) continue;
            throw new RuntimeException(pThrowable);
        }
        throw new UndeclaredThrowableException(pThrowable);
    }

    static <T extends Throwable> void throwAs(Class<T> pType, Throwable pThrowable) throws T {
        throw pThrowable;
    }

    public static void throwUnchecked(Throwable pThrowable) {
        ExceptionUtil.throwAs(RuntimeException.class, pThrowable);
    }

    static void handle(Throwable pThrowable, ThrowableHandler<? extends Throwable> ... pHandler) {
        ExceptionUtil.handleImpl(pThrowable, pHandler);
    }

    private static <T extends Throwable> void handleImpl(Throwable pThrowable, ThrowableHandler<T> ... pHandler) {
        for (ThrowableHandler<Throwable> throwableHandler : pHandler) {
            if (!throwableHandler.handles(pThrowable)) continue;
            throwableHandler.handle(pThrowable);
            return;
        }
        ExceptionUtil.throwUnchecked(pThrowable);
    }

    public static void main(String[] pArgs) {
        while (true) {
            ExceptionUtil.foo();
        }
    }

    private static void foo() {
        try {
            ExceptionUtil.bar();
        }
        catch (Throwable t) {
            ExceptionUtil.handle(t, new ThrowableHandler<IOException>(new Class[]{IOException.class}){

                @Override
                public void handle(IOException pThrowable) {
                    System.out.println("IOException: " + pThrowable + " handled");
                }
            }, new ThrowableHandler<Exception>(new Class[]{SQLException.class, NumberFormatException.class}){

                @Override
                public void handle(Exception pThrowable) {
                    System.out.println("Exception: " + pThrowable + " handled");
                }
            }, new ThrowableHandler<Throwable>(new Class[]{Throwable.class}){

                @Override
                public void handle(Throwable pThrowable) {
                    System.err.println("Generic throwable: " + pThrowable + " NOT handled");
                    ExceptionUtil.throwUnchecked(pThrowable);
                }
            });
        }
    }

    private static void bar() {
        ExceptionUtil.baz();
    }

    private static void baz() {
        double random = Math.random();
        if (random < 0.3333333333333333) {
            ExceptionUtil.throwUnchecked(new FileNotFoundException("FNF Boo"));
        }
        if (random < 0.6666666666666666) {
            ExceptionUtil.throwUnchecked(new SQLException("SQL Boo"));
        } else {
            ExceptionUtil.throwUnchecked(new Exception("Some Boo"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ThrowableHandler<T extends Throwable> {
        private Class<? extends T>[] mThrowables;

        protected ThrowableHandler(Class<? extends T> ... pThrowables) {
            this.mThrowables = (Class[])pThrowables.clone();
        }

        public final boolean handles(Throwable pThrowable) {
            for (Class<T> clazz : this.mThrowables) {
                if (!clazz.isAssignableFrom(pThrowable.getClass())) continue;
                return true;
            }
            return false;
        }

        public abstract void handle(T var1);
    }
}

