/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.lang;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class DateUtil {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long CALENDAR_YEAR = 31556952000L;

    private DateUtil() {
    }

    public static long delta(long pStart) {
        return System.currentTimeMillis() - pStart;
    }

    public static long delta(Date pStart) {
        return System.currentTimeMillis() - pStart.getTime();
    }

    public static long currentTimeSecond() {
        return DateUtil.roundToSecond(System.currentTimeMillis());
    }

    public static long currentTimeMinute() {
        return DateUtil.roundToMinute(System.currentTimeMillis());
    }

    public static long currentTimeHour() {
        return DateUtil.roundToHour(System.currentTimeMillis());
    }

    public static long currentTimeDay() {
        return DateUtil.roundToDay(System.currentTimeMillis());
    }

    public static long roundToSecond(long pTime) {
        return pTime / 1000L * 1000L;
    }

    public static long roundToMinute(long pTime) {
        return pTime / 60000L * 60000L;
    }

    public static long roundToHour(long pTime) {
        return pTime / 3600000L * 3600000L;
    }

    public static long roundToDay(long pTime) {
        return DateUtil.roundToDay(pTime, TimeZone.getDefault());
    }

    public static long roundToDay(long pTime, TimeZone pTimeZone) {
        int offset = pTimeZone.getOffset(pTime);
        return (pTime + (long)offset) / 86400000L * 86400000L - (long)offset;
    }

    public static void main(String[] pArgs) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd HH.mm.ss S");
        long time = pArgs.length > 0 ? format.parse(pArgs[0]).getTime() : System.currentTimeMillis();
        System.out.println(time + ": " + format.format(new Date(time)));
        time = DateUtil.roundToSecond(time);
        System.out.println(time + ": " + format.format(new Date(time)));
        time = DateUtil.roundToMinute(time);
        System.out.println(time + ": " + format.format(new Date(time)));
        time = DateUtil.roundToHour(time);
        System.out.println(time + ": " + format.format(new Date(time)));
        time = DateUtil.roundToDay(time);
        System.out.println(time + ": " + format.format(new Date(time)));
    }
}

