/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.AbstractCachedSeekableStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public final class MemoryCacheSeekableStream
extends AbstractCachedSeekableStream {
    public MemoryCacheSeekableStream(InputStream pStream) {
        super(pStream, new MemoryCache());
    }

    public final boolean isCachedMemory() {
        return true;
    }

    public final boolean isCachedFile() {
        return false;
    }

    static final class MemoryCache
    extends AbstractCachedSeekableStream.StreamCache {
        static final int BLOCK_SIZE = 8192;
        private final List<byte[]> mCache = new ArrayList<byte[]>();
        private long mLength;
        private long mPosition;
        private long mStart;

        MemoryCache() {
        }

        private byte[] getBlock() throws IOException {
            long currPos = this.mPosition - this.mStart;
            if (currPos < 0L) {
                throw new IOException("StreamCache flushed before read position");
            }
            long index = currPos / 8192L;
            if (index >= Integer.MAX_VALUE) {
                throw new IOException("Memory cache max size exceeded");
            }
            if (index >= (long)this.mCache.size()) {
                try {
                    this.mCache.add(new byte[8192]);
                }
                catch (OutOfMemoryError e) {
                    throw new IOException("No more memory for cache: " + this.mCache.size() * 8192);
                }
            }
            return this.mCache.get((int)index);
        }

        public void write(int pByte) throws IOException {
            byte[] buffer = this.getBlock();
            int idx = (int)(this.mPosition % 8192L);
            buffer[idx] = (byte)pByte;
            ++this.mPosition;
            if (this.mPosition > this.mLength) {
                this.mLength = this.mPosition;
            }
        }

        public void write(byte[] pBuffer, int pOffset, int pLength) throws IOException {
            byte[] buffer = this.getBlock();
            for (int i = 0; i < pLength; ++i) {
                int index = (int)this.mPosition % 8192;
                if (index == 0) {
                    buffer = this.getBlock();
                }
                buffer[index] = pBuffer[pOffset + i];
                ++this.mPosition;
            }
            if (this.mPosition > this.mLength) {
                this.mLength = this.mPosition;
            }
        }

        public int read() throws IOException {
            if (this.mPosition >= this.mLength) {
                return -1;
            }
            byte[] buffer = this.getBlock();
            int idx = (int)(this.mPosition % 8192L);
            ++this.mPosition;
            return buffer[idx] & 0xFF;
        }

        public int read(byte[] pBytes, int pOffset, int pLength) throws IOException {
            int i;
            if (this.mPosition >= this.mLength) {
                return -1;
            }
            byte[] buffer = this.getBlock();
            int bufferPos = (int)(this.mPosition % 8192L);
            int maxLen = (int)Math.min((long)Math.min(pLength, buffer.length - bufferPos), this.mLength - this.mPosition);
            for (i = 0; i < maxLen; ++i) {
                pBytes[pOffset + i] = buffer[bufferPos + i];
            }
            this.mPosition += (long)i;
            return i;
        }

        public void seek(long pPosition) throws IOException {
            if (pPosition < this.mStart) {
                throw new IOException("Seek before flush position");
            }
            this.mPosition = pPosition;
        }

        public void flush(long pPosition) {
            int firstPos = (int)(pPosition / 8192L) - 1;
            for (int i = 0; i < firstPos; ++i) {
                this.mCache.remove(0);
            }
            this.mStart = pPosition;
        }

        public long getPosition() {
            return this.mPosition;
        }
    }
}

