/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.SeekableInputStream;
import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import java.io.InputStream;

abstract class AbstractCachedSeekableStream
extends SeekableInputStream {
    protected final InputStream mStream;
    protected long mStreamPosition;
    private StreamCache mCache;

    protected AbstractCachedSeekableStream(InputStream pStream, StreamCache pCache) {
        Validate.notNull(pStream, "stream");
        Validate.notNull(pCache, "cache");
        this.mStream = pStream;
        this.mCache = pCache;
    }

    protected final StreamCache getCache() {
        return this.mCache;
    }

    public int available() throws IOException {
        long avail = this.mStreamPosition - this.mPosition + (long)this.mStream.available();
        return avail > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)avail;
    }

    public int read() throws IOException {
        int read;
        this.checkOpen();
        if (this.mPosition == this.mStreamPosition) {
            read = this.mStream.read();
            if (read >= 0) {
                ++this.mStreamPosition;
                this.mCache.write(read);
            }
        } else {
            this.syncPosition();
            read = this.mCache.read();
        }
        if (read != -1) {
            ++this.mPosition;
        }
        return read;
    }

    public int read(byte[] pBytes, int pOffset, int pLength) throws IOException {
        int length;
        this.checkOpen();
        if (this.mPosition == this.mStreamPosition) {
            length = this.mStream.read(pBytes, pOffset, pLength);
            if (length > 0) {
                this.mStreamPosition += (long)length;
                this.mCache.write(pBytes, pOffset, length);
            }
        } else {
            this.syncPosition();
            length = this.mCache.read(pBytes, pOffset, pLength);
        }
        if (length > 0) {
            this.mPosition += (long)length;
        }
        return length;
    }

    protected final void syncPosition() throws IOException {
        if (this.mCache.getPosition() != this.mPosition) {
            this.mCache.seek(this.mPosition);
        }
    }

    public final boolean isCached() {
        return true;
    }

    public abstract boolean isCachedMemory();

    public abstract boolean isCachedFile();

    protected void seekImpl(long pPosition) throws IOException {
        if (this.mStreamPosition < pPosition) {
            long left;
            if (this.mCache.getPosition() != this.mStreamPosition) {
                this.mCache.seek(this.mStreamPosition);
            }
            int bufferLen = (left = pPosition - this.mStreamPosition) > 1024L ? 1024 : (int)left;
            byte[] buffer = new byte[bufferLen];
            while (left > 0L) {
                int length = (long)buffer.length < left ? buffer.length : (int)left;
                int read = this.mStream.read(buffer, 0, length);
                if (read > 0) {
                    this.mCache.write(buffer, 0, read);
                    this.mStreamPosition += (long)read;
                    left -= (long)read;
                    continue;
                }
                if (read >= 0) continue;
                break;
            }
        } else if (this.mStreamPosition >= pPosition) {
            this.mCache.seek(pPosition);
        }
    }

    protected void flushBeforeImpl(long pPosition) {
        this.mCache.flush(pPosition);
    }

    protected void closeImpl() throws IOException {
        this.mCache.flush(this.mPosition);
        this.mCache = null;
        this.mStream.close();
    }

    public static abstract class StreamCache {
        protected StreamCache() {
        }

        abstract void write(int var1) throws IOException;

        void write(byte[] pBuffer, int pOffset, int pLength) throws IOException {
            for (int i = 0; i < pLength; ++i) {
                this.write(pBuffer[pOffset + i]);
            }
        }

        abstract int read() throws IOException;

        int read(byte[] pBuffer, int pOffset, int pLength) throws IOException {
            int read;
            int count = 0;
            for (int i = 0; i < pLength && (read = this.read()) >= 0; ++i) {
                pBuffer[pOffset + i] = (byte)read;
                ++count;
            }
            return count;
        }

        abstract void seek(long var1) throws IOException;

        void flush(long pPosition) {
        }

        abstract long getPosition() throws IOException;
    }
}

