/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.image.MagickAccelerator;
import com.twelvemonkeys.lang.SystemUtil;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;

public class ResampleOp
implements BufferedImageOp {
    public static final int FILTER_UNDEFINED = 0;
    public static final int FILTER_POINT = 1;
    public static final int FILTER_BOX = 2;
    public static final int FILTER_TRIANGLE = 3;
    public static final int FILTER_HERMITE = 4;
    public static final int FILTER_HANNING = 5;
    public static final int FILTER_HAMMING = 6;
    public static final int FILTER_BLACKMAN = 7;
    public static final int FILTER_GAUSSIAN = 8;
    public static final int FILTER_QUADRATIC = 9;
    public static final int FILTER_CUBIC = 10;
    public static final int FILTER_CATROM = 11;
    public static final int FILTER_MITCHELL = 12;
    public static final int FILTER_LANCZOS = 13;
    public static final int FILTER_BLACKMAN_BESSEL = 14;
    public static final int FILTER_BLACKMAN_SINC = 15;
    public static final RenderingHints.Key KEY_RESAMPLE_INTERPOLATION = new Key("ResampleInterpolation");
    public static final Object VALUE_INTERPOLATION_POINT = new Value(KEY_RESAMPLE_INTERPOLATION, "Point", 1);
    public static final Object VALUE_INTERPOLATION_BOX = new Value(KEY_RESAMPLE_INTERPOLATION, "Box", 2);
    public static final Object VALUE_INTERPOLATION_TRIANGLE = new Value(KEY_RESAMPLE_INTERPOLATION, "Triangle", 3);
    public static final Object VALUE_INTERPOLATION_HERMITE = new Value(KEY_RESAMPLE_INTERPOLATION, "Hermite", 4);
    public static final Object VALUE_INTERPOLATION_HANNING = new Value(KEY_RESAMPLE_INTERPOLATION, "Hanning", 5);
    public static final Object VALUE_INTERPOLATION_HAMMING = new Value(KEY_RESAMPLE_INTERPOLATION, "Hamming", 6);
    public static final Object VALUE_INTERPOLATION_BLACKMAN = new Value(KEY_RESAMPLE_INTERPOLATION, "Blackman", 7);
    public static final Object VALUE_INTERPOLATION_GAUSSIAN = new Value(KEY_RESAMPLE_INTERPOLATION, "Gaussian", 8);
    public static final Object VALUE_INTERPOLATION_QUADRATIC = new Value(KEY_RESAMPLE_INTERPOLATION, "Quadratic", 9);
    public static final Object VALUE_INTERPOLATION_CUBIC = new Value(KEY_RESAMPLE_INTERPOLATION, "Cubic", 10);
    public static final Object VALUE_INTERPOLATION_CATROM = new Value(KEY_RESAMPLE_INTERPOLATION, "Catrom", 11);
    public static final Object VALUE_INTERPOLATION_MITCHELL = new Value(KEY_RESAMPLE_INTERPOLATION, "Mitchell", 12);
    public static final Object VALUE_INTERPOLATION_LANCZOS = new Value(KEY_RESAMPLE_INTERPOLATION, "Lanczos", 13);
    public static final Object VALUE_INTERPOLATION_BLACKMAN_BESSEL = new Value(KEY_RESAMPLE_INTERPOLATION, "Blackman-Bessel", 14);
    public static final Object VALUE_INTERPOLATION_BLACKMAN_SINC = new Value(KEY_RESAMPLE_INTERPOLATION, "Blackman-Sinc", 15);
    int mWidth;
    int mHeight;
    int mFilterType;
    private static final boolean TRANSFORM_OP_BICUBIC_SUPPORT = SystemUtil.isFieldAvailable(AffineTransformOp.class.getName(), "TYPE_BICUBIC");
    private static final double B = 0.3333333333333333;
    private static final double C = 0.3333333333333333;
    private static final double P0 = 0.8888888888888888;
    private static final double P2 = -2.0;
    private static final double P3 = 1.1666666666666667;
    private static final double Q0 = 1.7777777777777777;
    private static final double Q1 = -3.3333333333333335;
    private static final double Q2 = 2.0;
    private static final double Q3 = -0.3888888888888889;

    public ResampleOp(int pWidth, int pHeight) {
        this(pWidth, pHeight, 0);
    }

    public ResampleOp(int pWidth, int pHeight, RenderingHints pHints) {
        this(pWidth, pHeight, ResampleOp.getFilterType(pHints));
    }

    public ResampleOp(int pWidth, int pHeight, int pFilterType) {
        if (pWidth <= 0 || pHeight <= 0) {
            throw new IllegalArgumentException("width and height must be positive");
        }
        this.mWidth = pWidth;
        this.mHeight = pHeight;
        ResampleOp.validateFilterType(pFilterType);
        this.mFilterType = pFilterType;
    }

    private static void validateFilterType(int pFilterType) {
        switch (pFilterType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown filter type: " + pFilterType);
            }
        }
    }

    private static int getFilterType(RenderingHints pHints) {
        if (pHints == null) {
            return 0;
        }
        if (pHints.containsKey(KEY_RESAMPLE_INTERPOLATION)) {
            Object value = pHints.get(KEY_RESAMPLE_INTERPOLATION);
            if (!KEY_RESAMPLE_INTERPOLATION.isCompatibleValue(value)) {
                throw new IllegalArgumentException(value + " incompatible with key " + KEY_RESAMPLE_INTERPOLATION);
            }
            return value != null ? ((Value)value).getFilterType() : 0;
        }
        if (RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR.equals(pHints.get(RenderingHints.KEY_INTERPOLATION)) || !pHints.containsKey(RenderingHints.KEY_INTERPOLATION) && (RenderingHints.VALUE_RENDER_SPEED.equals(pHints.get(RenderingHints.KEY_RENDERING)) || RenderingHints.VALUE_COLOR_RENDER_SPEED.equals(pHints.get(RenderingHints.KEY_COLOR_RENDERING)))) {
            return 1;
        }
        if (RenderingHints.VALUE_INTERPOLATION_BILINEAR.equals(pHints.get(RenderingHints.KEY_INTERPOLATION))) {
            return 3;
        }
        if (RenderingHints.VALUE_INTERPOLATION_BICUBIC.equals(pHints.get(RenderingHints.KEY_INTERPOLATION))) {
            return 9;
        }
        if (RenderingHints.VALUE_RENDER_QUALITY.equals(pHints.get(RenderingHints.KEY_RENDERING)) || RenderingHints.VALUE_COLOR_RENDER_QUALITY.equals(pHints.get(RenderingHints.KEY_COLOR_RENDERING))) {
            return 12;
        }
        return 0;
    }

    public final BufferedImage filter(BufferedImage pInput, BufferedImage pOutput) {
        ColorModel cm;
        if (pInput == null) {
            throw new NullPointerException("Input == null");
        }
        if (pInput == pOutput) {
            throw new IllegalArgumentException("Output image cannot be the same as the input image");
        }
        switch (this.mFilterType) {
            case 1: {
                return ResampleOp.fastResample(pInput, pOutput, this.mWidth, this.mHeight, 1);
            }
            case 3: {
                return ResampleOp.fastResample(pInput, pOutput, this.mWidth, this.mHeight, 2);
            }
            case 9: {
                if (!TRANSFORM_OP_BICUBIC_SUPPORT) break;
                return ResampleOp.fastResample(pInput, pOutput, this.mWidth, this.mHeight, 3);
            }
        }
        InterpolationFilter filter = ResampleOp.createFilter(this.mFilterType);
        if ((double)Math.min(pInput.getWidth(), pInput.getHeight()) <= filter.support() || (double)Math.min(this.mWidth, this.mHeight) <= filter.support()) {
            return ResampleOp.fastResample(pInput, pOutput, this.mWidth, this.mHeight, 2);
        }
        BufferedImage result = MagickAccelerator.filter(this, pInput, pOutput);
        if (result != null) {
            return result;
        }
        BufferedImage input = this.mFilterType != 2 && (cm = pInput.getColorModel()) instanceof IndexColorModel ? ImageUtil.toBuffered(pInput, cm.hasAlpha() ? 6 : 5) : pInput;
        result = pOutput != null ? ImageUtil.toBuffered(pOutput, input.getType()) : this.createCompatibleDestImage(input, null);
        this.resample(input, result, filter);
        if (pOutput != null && pOutput != result) {
            ImageUtil.drawOnto(pOutput, result);
            result = pOutput;
        }
        return result;
    }

    private static BufferedImage fastResample(BufferedImage pInput, BufferedImage pOutput, int pWidth, int pHeight, int pType) {
        AffineTransformOp scale;
        AffineTransform transform;
        double yScale;
        double xScale;
        BufferedImage temp = pInput;
        if (pType > 1 && (pWidth < pInput.getWidth() || pHeight < pInput.getHeight())) {
            int w;
            int h = pHeight;
            for (w = pWidth; w < pInput.getWidth() / 2; w *= 2) {
            }
            while (h < pInput.getHeight() / 2) {
                h *= 2;
            }
            xScale = (double)w / (double)pInput.getWidth();
            yScale = (double)h / (double)pInput.getHeight();
            transform = AffineTransform.getScaleInstance(xScale, yScale);
            scale = new AffineTransformOp(transform, 2);
            temp = scale.filter(temp, null);
        }
        scale = null;
        xScale = (double)pWidth / (double)temp.getWidth();
        yScale = (double)pHeight / (double)temp.getHeight();
        if (pType > 1) {
            while (xScale < 0.5 || yScale < 0.5) {
                if (xScale >= 0.5) {
                    transform = AffineTransform.getScaleInstance(1.0, 0.5);
                    scale = new AffineTransformOp(transform, 2);
                    yScale *= 2.0;
                } else if (yScale >= 0.5) {
                    transform = AffineTransform.getScaleInstance(0.5, 1.0);
                    scale = new AffineTransformOp(transform, 2);
                    xScale *= 2.0;
                } else {
                    xScale *= 2.0;
                    yScale *= 2.0;
                }
                if (scale == null) {
                    transform = AffineTransform.getScaleInstance(0.5, 0.5);
                    scale = new AffineTransformOp(transform, 2);
                }
                temp = scale.filter(temp, null);
            }
        }
        transform = AffineTransform.getScaleInstance(xScale, yScale);
        scale = new AffineTransformOp(transform, pType);
        return scale.filter(temp, pOutput);
    }

    public int getFilterType() {
        return this.mFilterType;
    }

    private static InterpolationFilter createFilter(int pFilterType) {
        if (pFilterType == 0) {
            pFilterType = 13;
        }
        switch (pFilterType) {
            case 2: {
                return new BoxFilter();
            }
            case 3: {
                return new TriangleFilter();
            }
            case 4: {
                return new HermiteFilter();
            }
            case 5: {
                return new HanningFilter();
            }
            case 6: {
                return new HammingFilter();
            }
            case 7: {
                return new BlacmanFilter();
            }
            case 8: {
                return new GaussianFilter();
            }
            case 9: {
                return new QuadraticFilter();
            }
            case 10: {
                return new CubicFilter();
            }
            case 11: {
                return new CatromFilter();
            }
            case 12: {
                return new MitchellFilter();
            }
            case 13: {
                return new LanczosFilter();
            }
            case 14: {
                return new BlackmanBesselFilter();
            }
            case 15: {
                return new BlackmanSincFilter();
            }
        }
        throw new IllegalStateException("Unknown filter type: " + pFilterType);
    }

    public final BufferedImage createCompatibleDestImage(BufferedImage pInput, ColorModel pModel) {
        if (pInput == null) {
            throw new NullPointerException("pInput == null");
        }
        ColorModel cm = pModel != null ? pModel : pInput.getColorModel();
        return new BufferedImage(cm, ImageUtil.createCompatibleWritableRaster(pInput, cm, this.mWidth, this.mHeight), cm.isAlphaPremultiplied(), null);
    }

    public RenderingHints getRenderingHints() {
        Object value;
        switch (this.mFilterType) {
            case 0: {
                return null;
            }
            case 1: {
                value = VALUE_INTERPOLATION_POINT;
                break;
            }
            case 2: {
                value = VALUE_INTERPOLATION_BOX;
                break;
            }
            case 3: {
                value = VALUE_INTERPOLATION_TRIANGLE;
                break;
            }
            case 4: {
                value = VALUE_INTERPOLATION_HERMITE;
                break;
            }
            case 5: {
                value = VALUE_INTERPOLATION_HANNING;
                break;
            }
            case 6: {
                value = VALUE_INTERPOLATION_HAMMING;
                break;
            }
            case 7: {
                value = VALUE_INTERPOLATION_BLACKMAN;
                break;
            }
            case 8: {
                value = VALUE_INTERPOLATION_GAUSSIAN;
                break;
            }
            case 9: {
                value = VALUE_INTERPOLATION_QUADRATIC;
                break;
            }
            case 10: {
                value = VALUE_INTERPOLATION_CUBIC;
                break;
            }
            case 11: {
                value = VALUE_INTERPOLATION_CATROM;
                break;
            }
            case 12: {
                value = VALUE_INTERPOLATION_MITCHELL;
                break;
            }
            case 13: {
                value = VALUE_INTERPOLATION_LANCZOS;
                break;
            }
            case 14: {
                value = VALUE_INTERPOLATION_BLACKMAN_BESSEL;
                break;
            }
            case 15: {
                value = VALUE_INTERPOLATION_BLACKMAN_SINC;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown filter type: " + this.mFilterType);
            }
        }
        return new RenderingHints(KEY_RESAMPLE_INTERPOLATION, value);
    }

    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle(this.mWidth, this.mHeight);
    }

    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = srcPt instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
            dstPt.setLocation(srcPt);
        }
        return dstPt;
    }

    private static double sinc(double x) {
        if ((x *= Math.PI) != 0.0) {
            return Math.sin(x) / x;
        }
        return 1.0;
    }

    private static double j1(double t) {
        double[] pOne = new double[]{5.811993540016061E20, -6.672106568924916E19, 2.3164335806340024E18, -3.588817569910106E16, 2.9087952638347756E14, -1.3229834803321265E12, 3.4132341823017006E9, -4695753.530642996, 2701.1227108923235};
        double[] qOne = new double[]{1.1623987080032122E21, 1.185770712190321E19, 6.092061398917522E16, 2.0816612213076075E14, 5.2437102621676495E11, 1.013863514358674E9, 1501793.5949985855, 1606.9315734814877, 1.0};
        double p = pOne[8];
        double q = qOne[8];
        for (int i = 7; i >= 0; --i) {
            p = p * t * t + pOne[i];
            q = q * t * t + qOne[i];
        }
        return p / q;
    }

    private static double p1(double t) {
        double[] pOne = new double[]{35224.66491336798, 62758.84524716128, 31353.963110915956, 4985.4832060594335, 211.15291828539623, 1.2571716929145342};
        double[] qOne = new double[]{35224.66491336798, 62694.34695935605, 31240.406381904104, 4930.396490181089, 203.07751891347593, 1.0};
        double p = pOne[5];
        double q = qOne[5];
        for (int i = 4; i >= 0; --i) {
            p = p * (8.0 / t) * (8.0 / t) + pOne[i];
            q = q * (8.0 / t) * (8.0 / t) + qOne[i];
        }
        return p / q;
    }

    private static double q1(double t) {
        double[] pOne = new double[]{351.17519143035526, 721.0391804904475, 425.98730116544425, 83.18989576738508, 4.568171629551227, 0.03532840052740124};
        double[] qOne = new double[]{7491.737417180912, 15414.177339265098, 9152.231701516992, 1811.1867005523513, 103.81875854621337, 1.0};
        double p = pOne[5];
        double q = qOne[5];
        for (int i = 4; i >= 0; --i) {
            p = p * (8.0 / t) * (8.0 / t) + pOne[i];
            q = q * (8.0 / t) * (8.0 / t) + qOne[i];
        }
        return p / q;
    }

    static double besselOrderOne(double t) {
        if (t == 0.0) {
            return 0.0;
        }
        double p = t;
        if (t < 0.0) {
            t = -t;
        }
        if (t < 8.0) {
            return p * ResampleOp.j1(t);
        }
        double q = Math.sqrt(2.0 / (Math.PI * t)) * (ResampleOp.p1(t) * (1.0 / Math.sqrt(2.0) * (Math.sin(t) - Math.cos(t))) - 8.0 / t * ResampleOp.q1(t) * (-1.0 / Math.sqrt(2.0) * (Math.sin(t) + Math.cos(t))));
        if (p < 0.0) {
            q = -q;
        }
        return q;
    }

    private static double bessel(double t) {
        if (t == 0.0) {
            return 0.7853981633974483;
        }
        return ResampleOp.besselOrderOne(Math.PI * t) / (2.0 * t);
    }

    private static double blackman(double t) {
        return 0.42 + 0.5 * Math.cos(Math.PI * t) + 0.08 * Math.cos(Math.PI * 2 * t);
    }

    static int round(double d) {
        int n = (int)d;
        double diff = d - (double)n;
        if (diff < 0.0) {
            diff = -diff;
        }
        if (diff >= 0.5) {
            n = d < 0.0 ? --n : ++n;
        }
        return n;
    }

    private ContributorList calcXContrib(double xscale, double fwidth, int srcwidth, InterpolationFilter pFilter, int i) {
        ContributorList contribX;
        block11: {
            block10: {
                contribX = new ContributorList();
                if (!(xscale < 1.0)) break block10;
                double width = fwidth / xscale;
                double fscale = 1.0 / xscale;
                if (width <= 0.5) {
                    width = 0.500001;
                    fscale = 1.0;
                }
                contribX.p = new Contributor[(int)(width * 2.0 + 1.0)];
                double center = (double)i / xscale;
                int left = (int)Math.ceil(center - width);
                int right = (int)Math.floor(center + width);
                double density = 0.0;
                for (int j = left; j <= right; ++j) {
                    double weight = center - (double)j;
                    weight = pFilter.filter(weight / fscale) / fscale;
                    int n = j < 0 ? -j : (j >= srcwidth ? srcwidth - j + srcwidth - 1 : j);
                    if (n >= srcwidth) {
                        n %= srcwidth;
                    } else if (n < 0) {
                        n = srcwidth - 1;
                    }
                    ++contribX.n;
                    contribX.p[k] = new Contributor();
                    contribX.p[k].pixel = n;
                    contribX.p[k].weight = weight;
                    density += weight;
                }
                if (density == 0.0 || density == 1.0) break block11;
                density = 1.0 / density;
                for (int k = 0; k < contribX.n; ++k) {
                    contribX.p[k].weight *= density;
                }
                break block11;
            }
            contribX.p = new Contributor[(int)(fwidth * 2.0 + 1.0)];
            double center = (double)i / xscale;
            int left = (int)Math.ceil(center - fwidth);
            int right = (int)Math.floor(center + fwidth);
            for (int j = left; j <= right; ++j) {
                double weight = center - (double)j;
                weight = pFilter.filter(weight);
                int n = j < 0 ? -j : (j >= srcwidth ? srcwidth - j + srcwidth - 1 : j);
                if (n >= srcwidth) {
                    n %= srcwidth;
                } else if (n < 0) {
                    n = srcwidth - 1;
                }
                ++contribX.n;
                contribX.p[k] = new Contributor();
                contribX.p[k].pixel = n;
                contribX.p[k].weight = weight;
            }
        }
        return contribX;
    }

    private BufferedImage resample(BufferedImage pSource, BufferedImage pDest, InterpolationFilter pFilter) {
        int dstWidth = pDest.getWidth();
        int dstHeight = pDest.getHeight();
        int srcWidth = pSource.getWidth();
        int srcHeight = pSource.getHeight();
        ColorModel cm = pSource.getColorModel();
        WritableRaster work = cm.createCompatibleWritableRaster(1, srcHeight);
        double xscale = (double)dstWidth / (double)srcWidth;
        double yscale = (double)dstHeight / (double)srcHeight;
        ContributorList[] contribY = new ContributorList[dstHeight];
        for (int i = 0; i < contribY.length; ++i) {
            contribY[i] = new ContributorList();
        }
        double fwidth = pFilter.support();
        if (yscale < 1.0) {
            double width = fwidth / yscale;
            double fscale = 1.0 / yscale;
            if (width <= 0.5) {
                width = 0.500001;
                fscale = 1.0;
            }
            for (int i = 0; i < dstHeight; ++i) {
                contribY[i].p = new Contributor[(int)(width * 2.0 + 1.0)];
                double center = (double)i / yscale;
                int left = (int)Math.ceil(center - width);
                int right = (int)Math.floor(center + width);
                double density = 0.0;
                for (int j = left; j <= right; ++j) {
                    double weight = center - (double)j;
                    weight = pFilter.filter(weight / fscale) / fscale;
                    int n = j < 0 ? -j : (j >= srcHeight ? srcHeight - j + srcHeight - 1 : j);
                    if (n >= srcHeight) {
                        n %= srcHeight;
                    } else if (n < 0) {
                        n = srcHeight - 1;
                    }
                    ++contribY[i].n;
                    contribY[i].p[k] = new Contributor();
                    contribY[i].p[k].pixel = n;
                    contribY[i].p[k].weight = weight;
                    density += weight;
                }
                if (density == 0.0 || density == 1.0) continue;
                density = 1.0 / density;
                for (int k = 0; k < contribY[i].n; ++k) {
                    contribY[i].p[k].weight *= density;
                }
            }
        } else {
            for (int i = 0; i < dstHeight; ++i) {
                contribY[i].p = new Contributor[(int)(fwidth * 2.0 + 1.0)];
                double center = (double)i / yscale;
                double left = Math.ceil(center - fwidth);
                double right = Math.floor(center + fwidth);
                int j = (int)left;
                while ((double)j <= right) {
                    double weight = center - (double)j;
                    weight = pFilter.filter(weight);
                    int n = j < 0 ? -j : (j >= srcHeight ? srcHeight - j + srcHeight - 1 : j);
                    if (n >= srcHeight) {
                        n %= srcHeight;
                    } else if (n < 0) {
                        n = srcHeight - 1;
                    }
                    ++contribY[i].n;
                    contribY[i].p[k] = new Contributor();
                    contribY[i].p[k].pixel = n;
                    contribY[i].p[k].weight = weight;
                    ++j;
                }
            }
        }
        WritableRaster raster = pSource.getRaster();
        WritableRaster out = pDest.getRaster();
        int numChannels = raster.getNumBands();
        int[] channelMax = new int[numChannels];
        for (int k = 0; k < numChannels; ++k) {
            channelMax[k] = (1 << pSource.getColorModel().getComponentSize(k)) - 1;
        }
        for (int xx = 0; xx < dstWidth; ++xx) {
            int j;
            double pel;
            boolean bPelDelta;
            int channel;
            ContributorList contribX = this.calcXContrib(xscale, fwidth, srcWidth, pFilter, xx);
            for (int k = 0; k < srcHeight; ++k) {
                for (channel = 0; channel < numChannels; ++channel) {
                    double weight = 0.0;
                    bPelDelta = false;
                    pel = raster.getSample(contribX.p[0].pixel, k, channel);
                    for (j = 0; j < contribX.n; ++j) {
                        double pel2;
                        double d = pel2 = j == 0 ? pel : (double)raster.getSample(contribX.p[j].pixel, k, channel);
                        if (pel2 != pel) {
                            bPelDelta = true;
                        }
                        weight += pel2 * contribX.p[j].weight;
                    }
                    double d = weight = bPelDelta ? (double)ResampleOp.round(weight) : pel;
                    if (weight < 0.0) {
                        weight = 0.0;
                    } else if (weight > (double)channelMax[channel]) {
                        weight = channelMax[channel];
                    }
                    work.setSample(0, k, channel, weight);
                }
            }
            for (int i = 0; i < dstHeight; ++i) {
                for (channel = 0; channel < numChannels; ++channel) {
                    double weight = 0.0;
                    bPelDelta = false;
                    pel = work.getSample(0, contribY[i].p[0].pixel, channel);
                    for (j = 0; j < contribY[i].n; ++j) {
                        double pel2;
                        double d = pel2 = j == 0 ? pel : (double)work.getSample(0, contribY[i].p[j].pixel, channel);
                        if (pel2 != pel) {
                            bPelDelta = true;
                        }
                        weight += pel2 * contribY[i].p[j].weight;
                    }
                    double d = weight = bPelDelta ? (double)ResampleOp.round(weight) : pel;
                    if (weight < 0.0) {
                        weight = 0.0;
                    } else if (weight > (double)channelMax[channel]) {
                        weight = channelMax[channel];
                    }
                    out.setSample(xx, i, channel, weight);
                }
            }
        }
        return pDest;
    }

    class ContributorList {
        int n;
        Contributor[] p;

        ContributorList() {
        }
    }

    class Contributor {
        int pixel;
        double weight;

        Contributor() {
        }
    }

    static class BlackmanSincFilter
    implements InterpolationFilter {
        BlackmanSincFilter() {
        }

        public final double filter(double t) {
            return ResampleOp.blackman(t / this.support()) * ResampleOp.sinc(t);
        }

        public final double support() {
            return 4.0;
        }
    }

    static class BlackmanBesselFilter
    implements InterpolationFilter {
        BlackmanBesselFilter() {
        }

        public final double filter(double t) {
            return ResampleOp.blackman(t / this.support()) * ResampleOp.bessel(t);
        }

        public final double support() {
            return 3.2383;
        }
    }

    static class HammingFilter
    implements InterpolationFilter {
        HammingFilter() {
        }

        public final double filter(double t) {
            return 0.54 + 0.46 * Math.cos(Math.PI * t);
        }

        public final double support() {
            return 1.0;
        }
    }

    static class HanningFilter
    implements InterpolationFilter {
        HanningFilter() {
        }

        public final double filter(double t) {
            return 0.5 + 0.5 * Math.cos(Math.PI * t);
        }

        public final double support() {
            return 1.0;
        }
    }

    static class GaussianFilter
    implements InterpolationFilter {
        GaussianFilter() {
        }

        public final double filter(double t) {
            return Math.exp(-2.0 * t * t) * Math.sqrt(0.6366197723675814);
        }

        public final double support() {
            return 1.25;
        }
    }

    static class CatromFilter
    implements InterpolationFilter {
        CatromFilter() {
        }

        public final double filter(double t) {
            if (t < 0.0) {
                t = -t;
            }
            if (t < 1.0) {
                return 0.5 * (2.0 + t * t * (-5.0 + t * 3.0));
            }
            if (t < 2.0) {
                return 0.5 * (4.0 + t * (-8.0 + t * (5.0 - t)));
            }
            return 0.0;
        }

        public final double support() {
            return 2.0;
        }
    }

    static class BlacmanFilter
    implements InterpolationFilter {
        BlacmanFilter() {
        }

        public final double filter(double t) {
            return ResampleOp.blackman(t);
        }

        public final double support() {
            return 1.0;
        }
    }

    static class MitchellFilter
    implements InterpolationFilter {
        MitchellFilter() {
        }

        public final double filter(double t) {
            if (t < -2.0) {
                return 0.0;
            }
            if (t < -1.0) {
                return 1.7777777777777777 - t * (-3.3333333333333335 - t * (2.0 - t * -0.3888888888888889));
            }
            if (t < 0.0) {
                return 0.8888888888888888 + t * t * (-2.0 - t * 1.1666666666666667);
            }
            if (t < 1.0) {
                return 0.8888888888888888 + t * t * (-2.0 + t * 1.1666666666666667);
            }
            if (t < 2.0) {
                return 1.7777777777777777 + t * (-3.3333333333333335 + t * (2.0 + t * -0.3888888888888889));
            }
            return 0.0;
        }

        public final double support() {
            return 2.0;
        }
    }

    static class LanczosFilter
    implements InterpolationFilter {
        LanczosFilter() {
        }

        public final double filter(double t) {
            if (t < 0.0) {
                t = -t;
            }
            if (t < 3.0) {
                return ResampleOp.sinc(t) * ResampleOp.sinc(t / 3.0);
            }
            return 0.0;
        }

        public final double support() {
            return 3.0;
        }
    }

    static class CubicFilter
    implements InterpolationFilter {
        CubicFilter() {
        }

        public final double filter(double t) {
            if (t < 0.0) {
                t = -t;
            }
            if (t < 1.0) {
                double tt = t * t;
                return 0.5 * tt * t - tt + 0.6666666666666666;
            }
            if (t < 2.0) {
                t = 2.0 - t;
                return 0.16666666666666666 * (t * t * t);
            }
            return 0.0;
        }

        public final double support() {
            return 2.0;
        }
    }

    static class QuadraticFilter
    implements InterpolationFilter {
        QuadraticFilter() {
        }

        public final double filter(double t) {
            if (t < 0.0) {
                t = -t;
            }
            if (t < 0.5) {
                return 0.75 - t * t;
            }
            if (t < 1.5) {
                return 0.5 * ((t -= 1.5) * t);
            }
            return 0.0;
        }

        public final double support() {
            return 1.5;
        }
    }

    static class TriangleFilter
    implements InterpolationFilter {
        TriangleFilter() {
        }

        public final double filter(double t) {
            if (t < 0.0) {
                t = -t;
            }
            if (t < 1.0) {
                return 1.0 - t;
            }
            return 0.0;
        }

        public final double support() {
            return 1.0;
        }
    }

    static class BoxFilter
    implements InterpolationFilter {
        private final double mSupport;

        public BoxFilter() {
            this.mSupport = 0.5;
        }

        protected BoxFilter(double pSupport) {
            this.mSupport = pSupport;
        }

        public final double filter(double t) {
            if (t >= -0.5 && t < 0.5) {
                return 1.0;
            }
            return 0.0;
        }

        public final double support() {
            return this.mSupport;
        }
    }

    static class PointFilter
    extends BoxFilter {
        public PointFilter() {
            super(0.0);
        }
    }

    static class HermiteFilter
    implements InterpolationFilter {
        HermiteFilter() {
        }

        public final double filter(double t) {
            if (t < 0.0) {
                t = -t;
            }
            if (t < 1.0) {
                return (2.0 * t - 3.0) * t * t + 1.0;
            }
            return 0.0;
        }

        public final double support() {
            return 1.0;
        }
    }

    static interface InterpolationFilter {
        public double filter(double var1);

        public double support();
    }

    static final class Value {
        private final RenderingHints.Key mKey;
        private final String mName;
        private final int mType;

        public Value(RenderingHints.Key pKey, String pName, int pType) {
            this.mKey = pKey;
            this.mName = pName;
            ResampleOp.validateFilterType(pType);
            this.mType = pType;
        }

        public boolean isCompatibleKey(Key pKey) {
            return pKey == this.mKey;
        }

        public int getFilterType() {
            return this.mType;
        }

        public String toString() {
            return this.mName;
        }
    }

    static class Key
    extends RenderingHints.Key {
        static int sIndex = 10000;
        private final String mName;

        public Key(String pName) {
            super(sIndex++);
            this.mName = pName;
        }

        public boolean isCompatibleValue(Object pValue) {
            return pValue instanceof Value && ((Value)pValue).isCompatibleKey(this);
        }

        public String toString() {
            return this.mName;
        }
    }
}

