/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import com.twelvemonkeys.image.BufferedImageIcon;
import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.image.ResampleOp;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class PixelizeOp
implements BufferedImageOp,
RasterOp {
    private final int mPixelSizeX;
    private final int mPixelSizeY;
    private Rectangle mSourceRegion;

    public PixelizeOp(int pPixelSize) {
        this(pPixelSize, pPixelSize);
    }

    public PixelizeOp(int pPixelSizeX, int pPixelSizeY) {
        this.mPixelSizeX = pPixelSizeX;
        this.mPixelSizeY = pPixelSizeY;
    }

    public Rectangle getSourceRegion() {
        if (this.mSourceRegion == null) {
            return null;
        }
        return new Rectangle(this.mSourceRegion);
    }

    public void setSourceRegion(Rectangle pSourceRegion) {
        if (pSourceRegion == null) {
            this.mSourceRegion = null;
        } else if (this.mSourceRegion == null) {
            this.mSourceRegion = new Rectangle(pSourceRegion);
        } else {
            this.mSourceRegion.setBounds(pSourceRegion);
        }
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        BufferedImage result = dest != null ? dest : this.createCompatibleDestImage(src, null);
        this.filterImpl(src.getRaster(), result.getRaster());
        return result;
    }

    public WritableRaster filter(Raster src, WritableRaster dest) {
        WritableRaster result = dest != null ? dest : this.createCompatibleDestRaster(src);
        return this.filterImpl(src, result);
    }

    private WritableRaster filterImpl(Raster src, WritableRaster dest) {
        if (this.mSourceRegion != null) {
            int cx = this.mSourceRegion.x;
            int cy = this.mSourceRegion.y;
            int cw = this.mSourceRegion.width;
            int ch = this.mSourceRegion.height;
            boolean same = src == dest;
            dest = dest.createWritableChild(cx, cy, cw, ch, 0, 0, null);
            src = same ? dest : src.createChild(cx, cy, cw, ch, 0, 0, null);
        }
        int width = src.getWidth();
        int height = src.getHeight();
        int w = (width + this.mPixelSizeX - 1) / this.mPixelSizeX;
        int h = (height + this.mPixelSizeY - 1) / this.mPixelSizeY;
        boolean oddX = width % w != 0;
        boolean oddY = height % h != 0;
        int dataElements = src.getNumDataElements();
        int bands = src.getNumBands();
        int dataType = src.getTransferType();
        Object data = null;
        int[] bitMasks = null;
        int[] bitOffsets = null;
        if (src.getTransferType() == 1) {
            if (src.getSampleModel() instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel sampleModel = (SinglePixelPackedSampleModel)src.getSampleModel();
                bitMasks = sampleModel.getBitMasks();
                bitOffsets = sampleModel.getBitOffsets();
            } else {
                bitMasks = new int[]{65535};
                bitOffsets = new int[]{0};
            }
        }
        for (int y = 0; y < h; ++y) {
            int scanH = !oddY || y + 1 < h ? this.mPixelSizeY : height - y * this.mPixelSizeY;
            for (int x = 0; x < w; ++x) {
                int scanW = !oddX || x + 1 < w ? this.mPixelSizeX : width - x * this.mPixelSizeX;
                int pixelCount = scanW * scanH;
                int pixelLength = pixelCount * dataElements;
                data = src.getDataElements(x * this.mPixelSizeX, y * this.mPixelSizeY, scanW, scanH, data);
                double valueA = 0.0;
                double valueR = 0.0;
                double valueG = 0.0;
                double valueB = 0.0;
                switch (dataType) {
                    case 0: {
                        int i;
                        byte[] bytePixels = (byte[])data;
                        for (i = 0; i < pixelLength; i += dataElements) {
                            valueA += (double)(bytePixels[i] & 0xFF);
                            if (bands <= 1) continue;
                            valueR += (double)(bytePixels[i + 1] & 0xFF);
                            valueG += (double)(bytePixels[i + 2] & 0xFF);
                            if (bands <= 3) continue;
                            valueB += (double)(bytePixels[i + 3] & 0xFF);
                        }
                        valueA /= (double)pixelCount;
                        if (bands > 1) {
                            valueR /= (double)pixelCount;
                            valueG /= (double)pixelCount;
                            if (bands > 3) {
                                valueB /= (double)pixelCount;
                            }
                        }
                        for (i = 0; i < pixelLength; i += dataElements) {
                            bytePixels[i] = (byte)PixelizeOp.clamp((int)valueA);
                            if (bands <= 1) continue;
                            bytePixels[i + 1] = (byte)PixelizeOp.clamp((int)valueR);
                            bytePixels[i + 2] = (byte)PixelizeOp.clamp((int)valueG);
                            if (bands <= 3) continue;
                            bytePixels[i + 3] = (byte)PixelizeOp.clamp((int)valueB);
                        }
                        break;
                    }
                    case 3: {
                        int i;
                        int[] intPixels = (int[])data;
                        for (i = 0; i < pixelLength; i += dataElements) {
                            valueA += (double)((intPixels[i] & 0xFF000000) >> 24);
                            valueR += (double)((intPixels[i] & 0xFF0000) >> 16);
                            valueG += (double)((intPixels[i] & 0xFF00) >> 8);
                            valueB += (double)(intPixels[i] & 0xFF);
                        }
                        valueA /= (double)pixelCount;
                        valueR /= (double)pixelCount;
                        valueG /= (double)pixelCount;
                        valueB /= (double)pixelCount;
                        for (i = 0; i < pixelLength; i += dataElements) {
                            intPixels[i] = PixelizeOp.clamp((int)valueA) << 24;
                            int n = i;
                            intPixels[n] = intPixels[n] | PixelizeOp.clamp((int)valueR) << 16;
                            int n2 = i;
                            intPixels[n2] = intPixels[n2] | PixelizeOp.clamp((int)valueG) << 8;
                            int n3 = i;
                            intPixels[n3] = intPixels[n3] | PixelizeOp.clamp((int)valueB);
                        }
                        break;
                    }
                    case 1: {
                        if (bitMasks != null) {
                            int i;
                            short[] shortPixels = (short[])data;
                            for (i = 0; i < pixelLength; i += dataElements) {
                                valueA += (double)((shortPixels[i] & bitMasks[0]) >> bitOffsets[0]);
                                if (bitMasks.length <= 1) continue;
                                valueR += (double)((shortPixels[i] & bitMasks[1]) >> bitOffsets[1]);
                                valueG += (double)((shortPixels[i] & bitMasks[2]) >> bitOffsets[2]);
                                if (bitMasks.length <= 3) continue;
                                valueB += (double)((shortPixels[i] & bitMasks[3]) >> bitOffsets[3]);
                            }
                            valueA /= (double)pixelCount;
                            valueR /= (double)pixelCount;
                            valueG /= (double)pixelCount;
                            valueB /= (double)pixelCount;
                            for (i = 0; i < pixelLength; i += dataElements) {
                                shortPixels[i] = (short)((int)valueA << bitOffsets[0] & bitMasks[0]);
                                if (bitMasks.length <= 1) continue;
                                int n = i;
                                shortPixels[n] = (short)(shortPixels[n] | (short)((int)valueR << bitOffsets[1] & bitMasks[1]));
                                int n4 = i;
                                shortPixels[n4] = (short)(shortPixels[n4] | (short)((int)valueG << bitOffsets[2] & bitMasks[2]));
                                if (bitMasks.length <= 3) continue;
                                int n5 = i;
                                shortPixels[n5] = (short)(shortPixels[n5] | (short)((int)valueB << bitOffsets[3] & bitMasks[3]));
                            }
                            break;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("TransferType not supported: " + dataType);
                    }
                }
                dest.setDataElements(x * this.mPixelSizeX, y * this.mPixelSizeY, scanW, scanH, data);
            }
        }
        return dest;
    }

    private static int clamp(int pValue) {
        return pValue > 255 ? 255 : pValue;
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        ColorModel cm = destCM != null ? destCM : src.getColorModel();
        return new BufferedImage(cm, ImageUtil.createCompatibleWritableRaster(src, cm, src.getWidth(), src.getHeight()), cm.isAlphaPremultiplied(), null);
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster();
    }

    public Rectangle2D getBounds2D(Raster src) {
        return new Rectangle(src.getWidth(), src.getHeight());
    }

    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle(src.getWidth(), src.getHeight());
    }

    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = srcPt instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        dstPt.setLocation(srcPt);
        return dstPt;
    }

    public static void main(String[] pArgs) throws IOException {
        BufferedImage image = ImageIO.read(new File("2006-Lamborghini-Gallardo-Spyder-Y-T-1600x1200.png"));
        for (int i = 0; i < 10; ++i) {
            new ResampleOp(image.getWidth() / 10, image.getHeight() / 10, 9).filter(image, null);
        }
        long start = System.currentTimeMillis();
        image = new ResampleOp(image.getWidth() / 4, image.getHeight() / 4, 9).filter(image, null);
        long time = System.currentTimeMillis() - start;
        System.out.println("time: " + time + " ms");
        JFrame frame = new JFrame("Test");
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(new JScrollPane(new JLabel(new BufferedImageIcon(image))));
        frame.pack();
        frame.setVisible(true);
    }
}

