/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.io.FileUtil;
import com.twelvemonkeys.lang.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;

public final class WriterFileSuffixFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private final String mDescription;
    private Map<String, Boolean> mKnownSuffixes = new HashMap<String, Boolean>(32);

    public WriterFileSuffixFilter() {
        this("Images (all supported output formats)");
    }

    public WriterFileSuffixFilter(String pDescription) {
        this.mDescription = pDescription;
    }

    public boolean accept(File pFile) {
        if (pFile.isDirectory()) {
            return true;
        }
        String suffix = FileUtil.getExtension((File)pFile);
        return !StringUtil.isEmpty((String)suffix) && this.hasWriterForSuffix(suffix);
    }

    private boolean hasWriterForSuffix(String pSuffix) {
        if (this.mKnownSuffixes.get(pSuffix) == Boolean.TRUE) {
            return true;
        }
        try {
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersBySuffix(pSuffix);
            if (iterator.hasNext()) {
                this.mKnownSuffixes.put(pSuffix, Boolean.TRUE);
                return true;
            }
            this.mKnownSuffixes.put(pSuffix, Boolean.FALSE);
            return false;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    public String getDescription() {
        return this.mDescription;
    }
}

