/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import javax.imageio.ImageTypeSpecifier;

public class IndexedImageTypeSpecifier
extends ImageTypeSpecifier {
    IndexedImageTypeSpecifier(IndexColorModel pColorModel) {
        super(pColorModel, pColorModel.createCompatibleSampleModel(1, 1));
    }

    public static ImageTypeSpecifier createFromIndexColorModel(IndexColorModel pColorModel) {
        return new IndexedImageTypeSpecifier(pColorModel);
    }

    public final BufferedImage createBufferedImage(int pWidth, int pHeight) {
        try {
            WritableRaster raster = this.colorModel.createCompatibleWritableRaster(pWidth, pHeight);
            return new BufferedImage(this.colorModel, raster, this.colorModel.isAlphaPremultiplied(), new Hashtable());
        }
        catch (NegativeArraySizeException e) {
            throw new IllegalArgumentException("Array size > Integer.MAX_VALUE!");
        }
    }
}

