/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public final class SubImageInputStream
extends ImageInputStreamImpl {
    private final ImageInputStream mStream;
    private final long mStartPos;
    private final long mLength;

    public SubImageInputStream(ImageInputStream pStream, long pLength) throws IOException {
        Validate.notNull((Object)pStream, (String)"stream");
        if (pLength < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        this.mStream = pStream;
        this.mStartPos = pStream.getStreamPosition();
        this.mLength = pLength;
    }

    public int read() throws IOException {
        if (this.streamPos >= this.mLength) {
            return -1;
        }
        int read = this.mStream.read();
        if (read >= 0) {
            ++this.streamPos;
        }
        return read;
    }

    public int read(byte[] pBytes, int pOffset, int pLength) throws IOException {
        if (this.streamPos >= this.mLength) {
            return -1;
        }
        int length = (int)Math.min((long)pLength, this.mLength - this.streamPos);
        int count = this.mStream.read(pBytes, pOffset, length);
        if (count >= 0) {
            this.streamPos += (long)count;
        }
        return count;
    }

    public long length() {
        try {
            long length = this.mStream.length();
            return length < 0L ? -1L : Math.min(length - this.mStartPos, this.mLength);
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    public void seek(long pPosition) throws IOException {
        if (pPosition < this.getFlushedPosition()) {
            throw new IndexOutOfBoundsException("pos < flushedPosition");
        }
        this.mStream.seek(this.mStartPos + pPosition);
        this.streamPos = pPosition;
    }

    protected void finalize() throws Throwable {
    }
}

