/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public final class BufferedImageInputStream
extends ImageInputStreamImpl
implements ImageInputStream {
    static final int DEFAULT_BUFFER_SIZE = 8192;
    private ImageInputStream mStream;
    private byte[] mBuffer;
    private long mBufferStart = 0L;
    private int mBufferPos = 0;
    private int mBufferLength = 0;

    public BufferedImageInputStream(ImageInputStream pStream) throws IOException {
        this(pStream, 8192);
    }

    private BufferedImageInputStream(ImageInputStream pStream, int pBufferSize) throws IOException {
        Validate.notNull((Object)pStream, (String)"stream");
        this.mStream = pStream;
        this.streamPos = pStream.getStreamPosition();
        this.mBuffer = new byte[pBufferSize];
    }

    private void fillBuffer() throws IOException {
        this.mBufferStart = this.streamPos;
        this.mBufferLength = this.mStream.read(this.mBuffer, 0, this.mBuffer.length);
        this.mBufferPos = 0;
    }

    private boolean isBufferValid() throws IOException {
        return this.mBufferPos < this.mBufferLength && this.mBufferStart == this.mStream.getStreamPosition() - (long)this.mBufferLength;
    }

    public int read() throws IOException {
        if (!this.isBufferValid()) {
            this.fillBuffer();
        }
        if (this.mBufferLength <= 0) {
            return -1;
        }
        this.bitOffset = 0;
        ++this.streamPos;
        return this.mBuffer[this.mBufferPos++] & 0xFF;
    }

    public int read(byte[] pBuffer, int pOffset, int pLength) throws IOException {
        this.bitOffset = 0;
        if (!this.isBufferValid()) {
            if (pLength >= this.mBuffer.length) {
                return this.readDirect(pBuffer, pOffset, pLength);
            }
            this.fillBuffer();
        }
        return this.readBuffered(pBuffer, pOffset, pLength);
    }

    private int readDirect(byte[] pBuffer, int pOffset, int pLength) throws IOException {
        int read = this.mStream.read(pBuffer, pOffset, Math.min(this.mBuffer.length, pLength));
        if (read > 0) {
            this.streamPos += (long)read;
        }
        this.mBufferStart = this.mStream.getStreamPosition();
        this.mBufferLength = 0;
        return read;
    }

    private int readBuffered(byte[] pBuffer, int pOffset, int pLength) {
        if (this.mBufferLength <= 0) {
            return -1;
        }
        int length = Math.min(this.mBufferLength - this.mBufferPos, pLength);
        if (length > 0) {
            System.arraycopy(this.mBuffer, this.mBufferPos, pBuffer, pOffset, length);
            this.mBufferPos += length;
        }
        this.streamPos += (long)length;
        return length;
    }

    public void seek(long pPosition) throws IOException {
        this.mStream.seek(pPosition);
        this.mBufferLength = 0;
        this.streamPos = this.mStream.getStreamPosition();
    }

    public void flushBefore(long pos) throws IOException {
        this.mStream.flushBefore(pos);
    }

    public long getFlushedPosition() {
        return this.mStream.getFlushedPosition();
    }

    public boolean isCached() {
        return this.mStream.isCached();
    }

    public boolean isCachedMemory() {
        return this.mStream.isCachedMemory();
    }

    public boolean isCachedFile() {
        return this.mStream.isCachedFile();
    }

    public void close() throws IOException {
        if (this.mStream != null) {
            this.mStream = null;
            this.mBuffer = null;
        }
        super.close();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public long length() {
        try {
            return this.mStream.length();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }
}

