/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.spi;

import com.twelvemonkeys.lang.Validate;

public class ProviderInfo {
    private final String mTitle;
    private final String mVendorName;
    private final String mVersion;

    public ProviderInfo(Package pPackage) {
        Validate.notNull((Object)pPackage, (String)"package");
        String title = pPackage.getImplementationTitle();
        this.mTitle = title != null ? title : pPackage.getName();
        String vendor = pPackage.getImplementationVendor();
        this.mVendorName = vendor != null ? vendor : ProviderInfo.fakeVendor(pPackage);
        String version = pPackage.getImplementationVersion();
        this.mVersion = version != null ? version : this.fakeVersion(pPackage);
    }

    private static String fakeVendor(Package pPackage) {
        String name = pPackage.getName();
        return name.startsWith("com.twelvemonkeys") ? "TwelveMonkeys" : name;
    }

    private String fakeVersion(Package pPackage) {
        String name = pPackage.getName();
        return name.startsWith("com.twelvemonkeys") ? "DEV" : "Unspecified";
    }

    final String getImplementationTitle() {
        return this.mTitle;
    }

    public final String getVendorName() {
        return this.mVendorName;
    }

    public final String getVersion() {
        return this.mVersion;
    }

    public String toString() {
        return this.mTitle + ", " + this.mVersion + " by " + this.mVendorName;
    }
}

