/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio;

import com.twelvemonkeys.imageio.util.IIOUtil;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public abstract class ImageWriterBase
extends ImageWriter {
    protected ImageOutputStream mImageOutput;

    protected ImageWriterBase(ImageWriterSpi pProvider) {
        super(pProvider);
    }

    public String getFormatName() throws IOException {
        return this.getOriginatingProvider().getFormatNames()[0];
    }

    public void setOutput(Object pOutput) {
        super.setOutput(pOutput);
        if (pOutput instanceof ImageOutputStream) {
            this.mImageOutput = (ImageOutputStream)pOutput;
        }
    }

    protected void assertOutput() {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null");
        }
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam pParam) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata pInData, ImageWriteParam pParam) {
        return null;
    }

    protected static Rectangle getSourceRegion(ImageWriteParam pParam, int pWidth, int pHeight) {
        return IIOUtil.getSourceRegion(pParam, pWidth, pHeight);
    }

    protected static BufferedImage fakeAOI(BufferedImage pImage, ImageWriteParam pParam) {
        return IIOUtil.fakeAOI(pImage, ImageWriterBase.getSourceRegion(pParam, pImage.getWidth(), pImage.getHeight()));
    }

    protected static Image fakeSubsampling(Image pImage, ImageWriteParam pParam) {
        return IIOUtil.fakeSubsampling(pImage, pParam);
    }
}

