/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio;

import com.twelvemonkeys.image.BufferedImageIcon;
import com.twelvemonkeys.imageio.util.IIOUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImageReaderBase
extends ImageReader {
    protected ImageInputStream mImageInput;

    protected ImageReaderBase(ImageReaderSpi pProvider) {
        super(pProvider);
    }

    @Override
    public void setInput(Object pInput, boolean pSeekForwardOnly, boolean pIgnoreMetadata) {
        this.resetMembers();
        super.setInput(pInput, pSeekForwardOnly, pIgnoreMetadata);
        if (pInput instanceof ImageInputStream) {
            this.mImageInput = (ImageInputStream)pInput;
        }
    }

    @Override
    public void dispose() {
        this.resetMembers();
        super.dispose();
    }

    @Override
    public void reset() {
        this.resetMembers();
        super.reset();
    }

    protected abstract void resetMembers();

    @Override
    public IIOMetadata getImageMetadata(int pImageIndex) throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public int getNumImages(boolean pAllowSearch) throws IOException {
        this.assertInput();
        return 1;
    }

    protected void checkBounds(int pIndex) throws IOException {
        this.assertInput();
        if (pIndex < this.getMinIndex()) {
            throw new IndexOutOfBoundsException("index < minIndex");
        }
        if (this.getNumImages(false) != -1 && pIndex >= this.getNumImages(false)) {
            throw new IndexOutOfBoundsException("index >= numImages (" + pIndex + " >= " + this.getNumImages(false) + ")");
        }
    }

    protected void assertInput() {
        if (this.getInput() == null) {
            throw new IllegalStateException("getInput() == null");
        }
    }

    public static BufferedImage getDestination(ImageReadParam pParam, Iterator<ImageTypeSpecifier> pTypes, int pWidth, int pHeight) throws IIOException {
        BufferedImage dest;
        BufferedImage image = ImageReader.getDestination(pParam, pTypes, pWidth, pHeight);
        if (pParam != null && (dest = pParam.getDestination()) != null) {
            boolean found = false;
            while (pTypes.hasNext()) {
                ImageTypeSpecifier specifier = pTypes.next();
                int imageType = specifier.getBufferedImageType();
                if (imageType != 0 && imageType == dest.getType()) {
                    found = true;
                    break;
                }
                if (specifier.getSampleModel().getTransferType() != dest.getSampleModel().getTransferType() || specifier.getNumBands() > dest.getSampleModel().getNumBands()) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IIOException(String.format("Illegal explicit destination image %s", dest));
            }
        }
        return image;
    }

    protected static BufferedImage fakeAOI(BufferedImage pImage, ImageReadParam pParam) {
        return IIOUtil.fakeAOI(pImage, ImageReaderBase.getSourceRegion(pParam, pImage.getWidth(), pImage.getHeight()));
    }

    protected static Image fakeSubsampling(Image pImage, ImageReadParam pParam) {
        return IIOUtil.fakeSubsampling(pImage, pParam);
    }

    public static void main(String[] pArgs) throws IOException {
        BufferedImage image = ImageIO.read(new File(pArgs[0]));
        if (image == null) {
            System.err.println("Supported formats: " + Arrays.toString(ImageIO.getReaderFormatNames()));
            System.exit(1);
        }
        ImageReaderBase.showIt(image, pArgs[0]);
    }

    protected static void showIt(final BufferedImage pImage, final String pTitle) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    JFrame frame = new JFrame(pTitle);
                    frame.setDefaultCloseOperation(3);
                    frame.setLocationByPlatform(true);
                    JPanel pane = new JPanel(new BorderLayout());
                    JScrollPane scroll = new JScrollPane(new ImageLabel(pImage));
                    scroll.setBorder(null);
                    pane.add(scroll);
                    frame.setContentPane(pane);
                    frame.pack();
                    frame.setVisible(true);
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ImageLabel
    extends JLabel {
        Paint mBackground;
        final Paint mCheckeredBG;
        final Color mDefaultBG;

        public ImageLabel(BufferedImage pImage) {
            super((Icon)new BufferedImageIcon(pImage));
            this.setOpaque(false);
            this.setCursor(Cursor.getPredefinedCursor(1));
            this.mCheckeredBG = ImageLabel.createTexture();
            this.mDefaultBG = ImageLabel.getDefaultBackground(pImage);
            this.mBackground = this.mDefaultBG != null ? this.mDefaultBG : this.mCheckeredBG;
            JPopupMenu popup = this.createBackgroundPopup();
            this.setComponentPopupMenu(popup);
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        ImageLabel.this.getComponentPopupMenu().show(ImageLabel.this, e.getX(), e.getY());
                    }
                }
            });
        }

        private JPopupMenu createBackgroundPopup() {
            JPopupMenu popup = new JPopupMenu();
            ButtonGroup group = new ButtonGroup();
            this.addCheckBoxItem(new ChangeBackgroundAction("Checkered", this.mCheckeredBG), popup, group);
            popup.addSeparator();
            this.addCheckBoxItem(new ChangeBackgroundAction("White", Color.WHITE), popup, group);
            this.addCheckBoxItem(new ChangeBackgroundAction("Light", Color.LIGHT_GRAY), popup, group);
            this.addCheckBoxItem(new ChangeBackgroundAction("Gray", Color.GRAY), popup, group);
            this.addCheckBoxItem(new ChangeBackgroundAction("Dark", Color.DARK_GRAY), popup, group);
            this.addCheckBoxItem(new ChangeBackgroundAction("Black", Color.BLACK), popup, group);
            popup.addSeparator();
            this.addCheckBoxItem(new ChooseBackgroundAction("Choose...", this.mDefaultBG != null ? this.mDefaultBG : Color.BLUE), popup, group);
            return popup;
        }

        private void addCheckBoxItem(Action pAction, JPopupMenu pPopup, ButtonGroup pGroup) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(pAction);
            pGroup.add(item);
            pPopup.add(item);
        }

        private static Color getDefaultBackground(BufferedImage pImage) {
            IndexColorModel cm;
            int transparent;
            if (pImage.getColorModel() instanceof IndexColorModel && (transparent = (cm = (IndexColorModel)pImage.getColorModel()).getTransparentPixel()) >= 0) {
                return new Color(cm.getRGB(transparent), false);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Paint createTexture() {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            BufferedImage pattern = graphicsConfiguration.createCompatibleImage(20, 20);
            Graphics2D g = pattern.createGraphics();
            try {
                g.setColor(Color.LIGHT_GRAY);
                g.fillRect(0, 0, pattern.getWidth(), pattern.getHeight());
                g.setColor(Color.GRAY);
                g.fillRect(0, 0, pattern.getWidth() / 2, pattern.getHeight() / 2);
                g.fillRect(pattern.getWidth() / 2, pattern.getHeight() / 2, pattern.getWidth() / 2, pattern.getHeight() / 2);
            }
            finally {
                g.dispose();
            }
            return new TexturePaint(pattern, new Rectangle(pattern.getWidth(), pattern.getHeight()));
        }

        protected void paintComponent(Graphics g) {
            Graphics2D gr = (Graphics2D)g;
            gr.setPaint(this.mBackground);
            gr.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paintComponent(g);
        }

        private class ChooseBackgroundAction
        extends ChangeBackgroundAction {
            public ChooseBackgroundAction(String pName, Color pColor) {
                super(pName, pColor);
                this.putValue("SmallIcon", new Icon(){

                    public void paintIcon(Component c, Graphics pGraphics, int x, int y) {
                        Graphics g = pGraphics.create();
                        g.setColor((Color)ChooseBackgroundAction.this.mPaint);
                        g.fillRect(x, y, 16, 16);
                        g.dispose();
                    }

                    public int getIconWidth() {
                        return 16;
                    }

                    public int getIconHeight() {
                        return 16;
                    }
                });
            }

            public void actionPerformed(ActionEvent e) {
                Color selected = JColorChooser.showDialog(ImageLabel.this, "Choose background", (Color)this.mPaint);
                if (selected != null) {
                    this.mPaint = selected;
                    super.actionPerformed(e);
                }
            }
        }

        private class ChangeBackgroundAction
        extends AbstractAction {
            protected Paint mPaint;

            public ChangeBackgroundAction(String pName, Paint pPaint) {
                super(pName);
                this.mPaint = pPaint;
            }

            public void actionPerformed(ActionEvent e) {
                ImageLabel.this.mBackground = this.mPaint;
                ImageLabel.this.repaint();
            }
        }
    }
}

