/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.webp.lossless;

import com.twelvemonkeys.imageio.plugins.webp.LSBBitReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.IIOException;

final class HuffmanTable {
    private static final int LEVEL1_BITS = 8;
    private static final int[] L_CODE_ORDER = new int[]{17, 18, 0, 1, 2, 3, 4, 5, 16, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private final int[] level1 = new int[256];
    private final List<int[]> level2 = new ArrayList<int[]>();

    public HuffmanTable(LSBBitReader lSBBitReader, int n) throws IOException {
        boolean bl;
        boolean bl2 = bl = lSBBitReader.readBit() == 1;
        if (bl) {
            int n2 = lSBBitReader.readBit() + 1;
            boolean bl3 = lSBBitReader.readBit() == 1;
            short s = (short)lSBBitReader.readBits(bl3 ? 8 : 1);
            if (n2 == 2) {
                short s2 = (short)lSBBitReader.readBits(8);
                for (int i = 0; i < 256; i += 2) {
                    this.level1[i] = 0x10000 | s;
                    this.level1[i + 1] = 0x10000 | s2;
                }
            } else {
                Arrays.fill(this.level1, (int)s);
            }
        } else {
            int n3 = (int)(lSBBitReader.readBits(4) + 4L);
            short[] sArray = new short[L_CODE_ORDER.length];
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                short s;
                sArray[HuffmanTable.L_CODE_ORDER[i]] = s = (short)lSBBitReader.readBits(3);
                if (s <= 0) continue;
                ++n4;
            }
            short[] sArray2 = HuffmanTable.readCodeLengths(lSBBitReader, sArray, n, n4);
            this.buildFromLengths(sArray2);
        }
    }

    private HuffmanTable(short[] sArray, int n) {
        this.buildFromLengths(sArray, n);
    }

    private void buildFromLengths(short[] sArray) {
        int n = 0;
        for (short s : sArray) {
            if (s == 0) continue;
            ++n;
        }
        this.buildFromLengths(sArray, n);
    }

    private void buildFromLengths(short[] sArray, int n) {
        int n22;
        int[] nArray = new int[n];
        int n3 = 0;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] == 0) continue;
            nArray[n3++] = sArray[i] << 16 | i;
        }
        if (n == 1) {
            Arrays.fill(this.level1, nArray[0] & 0xFFFF);
            return;
        }
        Arrays.sort(nArray);
        int[] nArray2 = new int[16];
        for (int n22 : nArray) {
            int n4 = n22 >>> 16;
            nArray2[n4] = nArray2[n4] + 1;
        }
        int n5 = 0;
        int n6 = 2;
        n3 = 0;
        int n7 = 1;
        while (n7 <= 8) {
            while (nArray2[n7] > 0) {
                n22 = nArray[n3++];
                for (int i = n5; i < this.level1.length; i += n6) {
                    this.level1[i] = n22;
                }
                n5 = this.nextCode(n5, n7);
                int n8 = n7;
                nArray2[n8] = nArray2[n8] - 1;
            }
            ++n7;
            n6 <<= 1;
        }
        n7 = 255;
        n22 = -1;
        int[] nArray3 = null;
        n6 = 2;
        int n9 = 9;
        while (n9 <= 15) {
            while (nArray2[n9] > 0) {
                int n10;
                int n11;
                int n12 = nArray[n3++];
                if ((n5 & n7) != n22) {
                    n11 = HuffmanTable.nextTableBitSize(nArray2, n9, 8);
                    n10 = 1 << n11;
                    nArray3 = new int[n10];
                    n22 = n5 & n7;
                    this.level2.add(nArray3);
                    this.level1[n22] = 8 + n11 << 16 | this.level2.size() - 1;
                }
                n11 = n9 - 8 << 16 | n12 & 0xFFFF;
                for (n10 = n5 >>> 8; n10 < nArray3.length; n10 += n6) {
                    nArray3[n10] = n11;
                }
                n5 = this.nextCode(n5, n9);
                int n13 = n9;
                nArray2[n13] = nArray2[n13] - 1;
            }
            ++n9;
            n6 <<= 1;
        }
    }

    private static int nextTableBitSize(int[] nArray, int n, int n2) {
        int n3 = 1 << n - n2;
        while (n < 15 && (n3 -= nArray[n]) > 0) {
            ++n;
            n3 <<= 1;
        }
        return n - n2;
    }

    private int nextCode(int n, int n2) {
        int n3 = ~n & (1 << n2) - 1;
        int n4 = Integer.highestOneBit(n3);
        return n & n4 - 1 | n4;
    }

    private static short[] readCodeLengths(LSBBitReader lSBBitReader, short[] sArray, int n, int n2) throws IOException {
        int n3;
        HuffmanTable huffmanTable = new HuffmanTable(sArray, n2);
        if (lSBBitReader.readBit() == 1) {
            int n4 = (int)(2L + 2L * lSBBitReader.readBits(3));
            n3 = (int)(2L + lSBBitReader.readBits(n4));
        } else {
            n3 = n;
        }
        short[] sArray2 = new short[n];
        short s = 8;
        for (int i = 0; i < n && n3 > 0; ++i, --n3) {
            int n5;
            int n6;
            short s2 = huffmanTable.readSymbol(lSBBitReader);
            if (s2 < 16) {
                sArray2[i] = s2;
                if (s2 == 0) continue;
                s = s2;
                continue;
            }
            short s3 = 0;
            switch (s2) {
                case 16: {
                    s3 = s;
                    n6 = 2;
                    n5 = 3;
                    break;
                }
                case 17: {
                    n6 = 3;
                    n5 = 3;
                    break;
                }
                case 18: {
                    n6 = 7;
                    n5 = 11;
                    break;
                }
                default: {
                    throw new IIOException("Huffman: Unreachable: Decoded Code Length > 18.");
                }
            }
            int n7 = (int)(lSBBitReader.readBits(n6) + (long)n5);
            if (i + n7 > n) {
                throw new IIOException(String.format("Huffman: Code length repeat count overflows alphabet: Start index: %d, count: %d, alphabet size: %d", i, n7, n));
            }
            Arrays.fill(sArray2, i, i + n7, s3);
            i += n7 - 1;
        }
        return sArray2;
    }

    public short readSymbol(LSBBitReader lSBBitReader) throws IOException {
        int n = (int)lSBBitReader.peekBits(8);
        int n2 = this.level1[n];
        int n3 = n2 >>> 16;
        if (n3 > 8) {
            lSBBitReader.readBits(8);
            int n4 = (int)lSBBitReader.peekBits(n3 - 8);
            n2 = this.level2.get(n2 & 0xFFFF)[n4];
            n3 = n2 >>> 16;
        }
        lSBBitReader.readBits(n3);
        return (short)(n2 & 0xFFFF);
    }
}

