/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.thumbsdb;

import com.twelvemonkeys.io.LittleEndianDataInputStream;
import com.twelvemonkeys.io.ole2.CompoundDocument;
import com.twelvemonkeys.lang.StringUtil;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;

public final class Catalog
implements Iterable<CatalogItem> {
    private final CatalogHeader header;
    private final CatalogItem[] items;

    Catalog(CatalogHeader catalogHeader, CatalogItem[] catalogItemArray) {
        this.header = catalogHeader;
        this.items = catalogItemArray;
    }

    public static Catalog read(InputStream inputStream) throws IOException {
        LittleEndianDataInputStream littleEndianDataInputStream = new LittleEndianDataInputStream(inputStream);
        return Catalog.read((DataInput)littleEndianDataInputStream);
    }

    public static Catalog read(DataInput dataInput) throws IOException {
        CatalogHeader catalogHeader = CatalogHeader.read(dataInput);
        CatalogItem[] catalogItemArray = new CatalogItem[catalogHeader.getThumbnailCount()];
        for (int i = 0; i < catalogHeader.getThumbnailCount(); ++i) {
            CatalogItem catalogItem;
            catalogItemArray[catalogItem.getItemId() - 1] = catalogItem = CatalogItem.read(dataInput);
        }
        return new Catalog(catalogHeader, catalogItemArray);
    }

    public final int getThumbnailCount() {
        return this.header.mThumbCount;
    }

    public final int getMaxThumbnailWidth() {
        return this.header.mThumbWidth;
    }

    public final int getMaxThumbnailHeight() {
        return this.header.mThumbHeight;
    }

    final CatalogItem getItem(int n) {
        return this.items[n];
    }

    final CatalogItem getItem(String string) {
        return this.items[this.getIndex(string)];
    }

    final int getItemId(int n) {
        return this.items[n].getItemId();
    }

    public final int getIndex(String string) {
        for (int i = 0; i < this.items.length; ++i) {
            CatalogItem catalogItem = this.items[i];
            if (!catalogItem.getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public final String getStreamName(int n) {
        return StringUtil.reverse((String)String.valueOf(this.getItemId(n)));
    }

    public final String getName(String string) {
        return this.getName(Integer.parseInt(StringUtil.reverse((String)string)));
    }

    final String getName(int n) {
        return this.items[n - 1].getName();
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.header);
    }

    @Override
    public Iterator<CatalogItem> iterator() {
        return new Iterator<CatalogItem>(){
            int mCurrentIdx;

            @Override
            public boolean hasNext() {
                return this.mCurrentIdx < Catalog.this.items.length;
            }

            @Override
            public CatalogItem next() {
                return Catalog.this.items[this.mCurrentIdx++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported");
            }
        };
    }

    public static final class CatalogItem {
        int mReserved1;
        int mItemId;
        String mFilename;
        short mReserved2;
        private long mLastModified;

        private static CatalogItem read(DataInput dataInput) throws IOException {
            char c;
            CatalogItem catalogItem = new CatalogItem();
            catalogItem.mReserved1 = dataInput.readInt();
            catalogItem.mItemId = dataInput.readInt();
            catalogItem.mLastModified = CompoundDocument.toJavaTimeInMillis((long)dataInput.readLong());
            char[] cArray = new char[256];
            int n = 0;
            while ((c = dataInput.readChar()) != '\u0000') {
                cArray[n++] = c;
            }
            String string = new String(cArray, 0, n);
            catalogItem.mFilename = StringUtil.getLastElement((String)string, (String)"\\");
            catalogItem.mReserved2 = dataInput.readShort();
            return catalogItem;
        }

        public String getName() {
            return this.mFilename;
        }

        public int getItemId() {
            return this.mItemId;
        }

        public long lastModified() {
            return this.mLastModified;
        }

        public String toString() {
            return String.format("%s: %d itemId: %d lastModified: %s fileName: %s %s", this.getClass().getSimpleName(), this.mReserved1, this.mItemId, new Date(this.mLastModified), this.mFilename, this.mReserved2);
        }
    }

    private static class CatalogHeader {
        short mReserved1;
        short mReserved2;
        int mThumbCount;
        int mThumbWidth;
        int mThumbHeight;

        CatalogHeader() {
        }

        public static CatalogHeader read(DataInput dataInput) throws IOException {
            CatalogHeader catalogHeader = new CatalogHeader();
            catalogHeader.mReserved1 = dataInput.readShort();
            catalogHeader.mReserved2 = dataInput.readShort();
            catalogHeader.mThumbCount = dataInput.readInt();
            catalogHeader.mThumbWidth = dataInput.readInt();
            catalogHeader.mThumbHeight = dataInput.readInt();
            return catalogHeader;
        }

        public int getThumbnailCount() {
            return this.mThumbCount;
        }

        public int getThumbHeight() {
            return this.mThumbHeight;
        }

        public int getThumbWidth() {
            return this.mThumbWidth;
        }

        public String toString() {
            return String.format("%s: %s %s thumbs: %d maxWidth: %d maxHeight: %d", this.getClass().getSimpleName(), this.mReserved1, this.mReserved2, this.mThumbCount, this.mThumbWidth, this.mThumbHeight);
        }
    }
}

