/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tga;

import com.twelvemonkeys.imageio.ImageWriterBase;
import com.twelvemonkeys.imageio.plugins.tga.TGAHeader;
import com.twelvemonkeys.imageio.plugins.tga.TGAMetadata;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import com.twelvemonkeys.lang.Validate;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;

final class TGAImageWriter
extends ImageWriterBase {
    TGAImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        TGAHeader tGAHeader = TGAHeader.from(imageTypeSpecifier.createBufferedImage(1, 1), imageWriteParam);
        return new TGAMetadata(tGAHeader, null);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public void setOutput(Object object) {
        super.setOutput(object);
        if (this.imageOutput != null) {
            this.imageOutput.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        }
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.assertOutput();
        if (iIOImage.hasRaster()) {
            throw new UnsupportedOperationException("Raster not supported");
        }
        RenderedImage renderedImage = iIOImage.getRenderedImage();
        TGAHeader tGAHeader = TGAHeader.from(renderedImage, imageWriteParam);
        tGAHeader.write(this.imageOutput);
        this.processImageStarted(0);
        WritableRaster writableRaster = tGAHeader.getPixelDepth() == 32 ? ImageTypeSpecifiers.createInterleaved((ColorSpace)ColorSpace.getInstance(1000), (int[])new int[]{2, 1, 0, 3}, (int)0, (boolean)true, (boolean)false).createBufferedImage(renderedImage.getWidth(), 1).getRaster() : (renderedImage.getSampleModel().getTransferType() == 3 ? ImageTypeSpecifiers.createInterleaved((ColorSpace)ColorSpace.getInstance(1000), (int[])new int[]{2, 1, 0}, (int)0, (boolean)false, (boolean)false).createBufferedImage(renderedImage.getWidth(), 1).getRaster() : ImageTypeSpecifier.createFromRenderedImage(renderedImage).createBufferedImage(renderedImage.getWidth(), 1).getRaster());
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        for (int i = 0; i < renderedImage.getNumYTiles(); ++i) {
            for (int j = 0; j < renderedImage.getNumXTiles() && !this.abortRequested(); ++j) {
                Raster raster = this.asByteRaster(renderedImage.getTile(j, i), renderedImage.getColorModel());
                for (int k = 0; k < raster.getHeight() && !this.abortRequested(); ++k) {
                    switch (dataBuffer.getDataType()) {
                        case 0: {
                            writableRaster.setDataElements(0, 0, raster.createChild(0, k, raster.getWidth(), 1, 0, 0, null));
                            this.imageOutput.write(((DataBufferByte)dataBuffer).getData());
                            break;
                        }
                        case 1: {
                            writableRaster.setDataElements(0, 0, raster.createChild(0, k, raster.getWidth(), 1, 0, 0, null));
                            short[] sArray = ((DataBufferUShort)dataBuffer).getData();
                            this.imageOutput.writeShorts(sArray, 0, sArray.length);
                            break;
                        }
                        default: {
                            throw new IIOException("Unsupported data");
                        }
                    }
                    this.processImageProgress((float)i * 100.0f / (float)renderedImage.getNumYTiles());
                }
            }
        }
        this.processImageComplete();
    }

    private Raster asByteRaster(Raster raster, ColorModel colorModel) {
        switch (raster.getTransferType()) {
            case 0: {
                return raster;
            }
            case 1: {
                return raster;
            }
            case 3: {
                final int n = colorModel.getNumComponents();
                final DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
                int n2 = raster.getWidth();
                int n3 = raster.getHeight();
                int n4 = dataBufferInt.getSize();
                return new Raster(new PixelInterleavedSampleModel(0, n2, n3, n, n2 * n, this.createBandOffsets(colorModel)), new DataBuffer(0, n4 * n){

                    @Override
                    public int getElem(int n5, int n2) {
                        int n3 = n2 / n;
                        int n4 = n2 % n * 8;
                        return dataBufferInt.getElem(n3) >>> n4 & 0xFF;
                    }

                    @Override
                    public void setElem(int n4, int n2, int n3) {
                        throw new UnsupportedOperationException("Wrapped buffer is read-only");
                    }
                }, new Point()){};
            }
        }
        throw new IllegalArgumentException(String.format("Raster type %d not supported", raster.getTransferType()));
    }

    private int[] createBandOffsets(ColorModel colorModel) {
        Validate.notNull((Object)colorModel, (String)"colorModel");
        if (colorModel instanceof DirectColorModel) {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            int[] nArray = directColorModel.getMasks();
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                int n2 = 0;
                if (n != 0) {
                    while ((n & 0xFF) == 0) {
                        n >>>= 8;
                        ++n2;
                    }
                }
                nArray2[i] = n2;
            }
            return nArray2;
        }
        throw new IllegalArgumentException(String.format("%s not supported", colorModel.getClass().getSimpleName()));
    }

    public static void main(String[] stringArray) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File(stringArray[0]));
        ImageIO.write((RenderedImage)bufferedImage, "TGA", new File("foo.tga"));
    }
}

