/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.sgi;

import com.twelvemonkeys.imageio.plugins.sgi.SGIHeader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

final class SGIMetadata
extends IIOMetadata {
    private final SGIHeader header;

    SGIMetadata(SGIHeader sGIHeader) {
        this.header = sGIHeader;
        this.standardFormatSupported = true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Node getAsTree(String string) {
        if ("javax_imageio_1.0".equals(string)) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Unsupported metadata format: " + string);
    }

    @Override
    public void mergeTree(String string, Node node) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("Metadata is read-only");
        }
    }

    @Override
    public void reset() {
        if (this.isReadOnly()) {
            throw new IllegalStateException("Metadata is read-only");
        }
    }

    @Override
    protected IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
        block0 : switch (this.header.getColorMode()) {
            case 0: {
                switch (this.header.getChannels()) {
                    case 1: 
                    case 2: {
                        iIOMetadataNode2.setAttribute("name", "GRAY");
                        break block0;
                    }
                    case 3: 
                    case 4: {
                        iIOMetadataNode2.setAttribute("name", "RGB");
                        break block0;
                    }
                }
                iIOMetadataNode2.setAttribute("name", Integer.toHexString(this.header.getChannels()).toUpperCase() + "CLR");
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                iIOMetadataNode2.setAttribute("name", "RGB");
            }
        }
        if (iIOMetadataNode2.getAttribute("name") != null) {
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("NumChannels");
        iIOMetadataNode3.setAttribute("value", Integer.toString(this.header.getChannels()));
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("BlackIsZero");
        iIOMetadataNode4.setAttribute("value", "TRUE");
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardCompressionNode() {
        if (this.header.getCompression() != 0) {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
            iIOMetadataNode2.setAttribute("value", this.header.getCompression() == 1 ? "RLE" : "Uknown");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("Lossless");
            iIOMetadataNode3.setAttribute("value", "TRUE");
            iIOMetadataNode.appendChild(iIOMetadataNode3);
            return iIOMetadataNode;
        }
        return null;
    }

    @Override
    protected IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("SampleFormat");
        iIOMetadataNode2.setAttribute("value", "UnsignedIntegral");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("BitsPerSample");
        iIOMetadataNode3.setAttribute("value", this.createListValue(this.header.getChannels(), Integer.toString(this.header.getBytesPerPixel() * 8)));
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("SignificantBitsPerSample");
        iIOMetadataNode4.setAttribute("value", this.createListValue(this.header.getChannels(), Integer.toString(this.computeSignificantBits())));
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("SampleMSB");
        iIOMetadataNode5.setAttribute("value", this.createListValue(this.header.getChannels(), "0"));
        return iIOMetadataNode;
    }

    private int computeSignificantBits() {
        int n = 0;
        int n2 = this.header.getMaxValue();
        while (n2 > 0) {
            n2 >>>= 1;
            ++n;
        }
        return n;
    }

    private String createListValue(int n, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(stringArray[i % stringArray.length]);
        }
        return stringBuilder.toString();
    }

    @Override
    protected IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
        iIOMetadataNode2.setAttribute("value", "FlipV");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardTextNode() {
        if (!this.header.getName().isEmpty()) {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Text");
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
            iIOMetadataNode2.setAttribute("keyword", "name");
            iIOMetadataNode2.setAttribute("value", this.header.getName());
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            return iIOMetadataNode;
        }
        return null;
    }

    @Override
    protected IIOMetadataNode getStandardTransparencyNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Transparency");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Alpha");
        iIOMetadataNode2.setAttribute("value", this.header.getChannels() == 1 || this.header.getChannels() == 3 ? "none" : "nonpremultiplied");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }
}

