/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.xmp.XMPReader;
import com.twelvemonkeys.imageio.plugins.psd.PSDImageResource;
import com.twelvemonkeys.imageio.stream.ByteArrayImageInputStream;
import com.twelvemonkeys.lang.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.imageio.stream.ImageInputStream;

final class PSDXMPData
extends PSDImageResource {
    protected byte[] data;
    Directory directory;

    PSDXMPData(short s, ImageInputStream imageInputStream) throws IOException {
        super(s, imageInputStream);
    }

    protected void readData(ImageInputStream imageInputStream) throws IOException {
        int n;
        this.data = new byte[(int)this.size];
        imageInputStream.readFully(this.data);
        for (n = this.data.length; n > 0 && this.data[n - 1] == 0; --n) {
        }
        this.directory = new XMPReader().read((ImageInputStream)new ByteArrayImageInputStream(this.data, 0, n));
    }

    public String toString() {
        StringBuilder stringBuilder = this.toStringBuilder();
        int n = Math.min(256, this.data.length);
        String string = StringUtil.decode((byte[])this.data, (int)0, (int)n, (String)"UTF-8").replace('\n', ' ').replaceAll("\\s+", " ");
        stringBuilder.append(", data: \"").append(string);
        if (n < this.data.length) {
            stringBuilder.append("...");
        }
        stringBuilder.append("\"]");
        return stringBuilder.toString();
    }

    public Reader getData() {
        return new InputStreamReader((InputStream)new ByteArrayInputStream(this.data), Charset.forName("UTF-8"));
    }
}

