/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDImageResource;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

final class PSDDisplayInfo
extends PSDImageResource {
    int colorSpace;
    short[] colors;
    short opacity;
    byte kind;

    PSDDisplayInfo(short s, ImageInputStream imageInputStream) throws IOException {
        super(s, imageInputStream);
    }

    protected void readData(ImageInputStream imageInputStream) throws IOException {
        if (this.size % 14L != 0L) {
            throw new IIOException("Display info length expected to be mod 14: " + this.size);
        }
        this.colorSpace = imageInputStream.readShort();
        this.colors = new short[4];
        this.colors[0] = imageInputStream.readShort();
        this.colors[1] = imageInputStream.readShort();
        this.colors[2] = imageInputStream.readShort();
        this.colors[3] = imageInputStream.readShort();
        this.opacity = imageInputStream.readShort();
        this.kind = imageInputStream.readByte();
        imageInputStream.readByte();
        imageInputStream.skipBytes(this.size - 14L);
    }

    public String toString() {
        StringBuilder stringBuilder = this.toStringBuilder();
        stringBuilder.append(", ColorSpace: ").append(this.colorSpace);
        stringBuilder.append(", Colors: {");
        stringBuilder.append(this.colors[0]);
        stringBuilder.append(", ");
        stringBuilder.append(this.colors[1]);
        stringBuilder.append(", ");
        stringBuilder.append(this.colors[2]);
        stringBuilder.append(", ");
        stringBuilder.append(this.colors[3]);
        stringBuilder.append("}, Opacity: ").append(this.opacity);
        stringBuilder.append(", Kind: ").append(this.kind(this.kind));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private String kind(byte by) {
        switch (by) {
            case 0: {
                return "selected";
            }
            case 1: {
                return "protected";
            }
        }
        return "unknown kind: " + Integer.toHexString(by & 0xFF);
    }
}

