/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDImageResource;
import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

final class PSDResolutionInfo
extends PSDImageResource {
    float hRes;
    short hResUnit;
    short widthUnit;
    float vRes;
    short vResUnit;
    short heightUnit;

    PSDResolutionInfo(short s, ImageInputStream imageInputStream) throws IOException {
        super(s, imageInputStream);
    }

    protected void readData(ImageInputStream imageInputStream) throws IOException {
        if (this.size != 16L) {
            throw new IIOException("Resolution info length expected to be 16: " + this.size);
        }
        this.hRes = PSDUtil.fixedPointToFloat(imageInputStream.readInt());
        this.hResUnit = imageInputStream.readShort();
        this.widthUnit = imageInputStream.readShort();
        this.vRes = PSDUtil.fixedPointToFloat(imageInputStream.readInt());
        this.vResUnit = imageInputStream.readShort();
        this.heightUnit = imageInputStream.readShort();
    }

    public String toString() {
        StringBuilder stringBuilder = this.toStringBuilder();
        stringBuilder.append(", hRes: ").append(this.hRes);
        stringBuilder.append(" ");
        stringBuilder.append(this.resUnit(this.hResUnit));
        stringBuilder.append(", width unit: ");
        stringBuilder.append(this.dimUnit(this.widthUnit));
        stringBuilder.append(", vRes: ").append(this.vRes);
        stringBuilder.append(" ");
        stringBuilder.append(this.resUnit(this.vResUnit));
        stringBuilder.append(", height unit: ");
        stringBuilder.append(this.dimUnit(this.heightUnit));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private String resUnit(short s) {
        switch (s) {
            case 1: {
                return "pixels/inch";
            }
            case 2: {
                return "pixels/cm";
            }
        }
        return "unknown unit " + s;
    }

    private String dimUnit(short s) {
        switch (s) {
            case 1: {
                return "in";
            }
            case 2: {
                return "cm";
            }
            case 3: {
                return "pt";
            }
            case 4: {
                return "pica";
            }
            case 5: {
                return "column";
            }
        }
        return "unknown unit " + s;
    }
}

