/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

class PSDLayerBlendMode {
    final int blendMode;
    final int opacity;
    final int clipping;
    final int flags;

    public PSDLayerBlendMode(ImageInputStream imageInputStream) throws IOException {
        int n = imageInputStream.readInt();
        if (n != 943868237) {
            throw new IIOException("Illegal PSD Blend Mode signature, expected 8BIM: " + PSDUtil.intToStr(n));
        }
        this.blendMode = imageInputStream.readInt();
        this.opacity = imageInputStream.readUnsignedByte();
        this.clipping = imageInputStream.readUnsignedByte();
        this.flags = imageInputStream.readUnsignedByte();
        imageInputStream.readByte();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append("[");
        stringBuilder.append("mode: \"").append(PSDUtil.intToStr(this.blendMode));
        stringBuilder.append("\", opacity: ").append(this.opacity);
        stringBuilder.append(", clipping: ").append(this.clipping);
        switch (this.clipping) {
            case 0: {
                stringBuilder.append(" (base)");
                break;
            }
            case 1: {
                stringBuilder.append(" (non-base)");
                break;
            }
            default: {
                stringBuilder.append(" (unknown)");
            }
        }
        stringBuilder.append(", flags: ").append(PSDLayerBlendMode.byteToBinary(this.flags));
        stringBuilder.append(" (");
        if ((this.flags & 1) != 0) {
            stringBuilder.append("Transp. protected, ");
        }
        if ((this.flags & 2) != 0) {
            stringBuilder.append("Hidden, ");
        }
        if ((this.flags & 4) != 0) {
            stringBuilder.append("Obsolete bit, ");
        }
        if ((this.flags & 8) != 0) {
            stringBuilder.append("PS 5.0 data present, ");
        }
        if ((this.flags & 0x10) != 0) {
            stringBuilder.append("Pixel data irrelevant, ");
        }
        if ((this.flags & 0x20) != 0) {
            stringBuilder.append("Unknown bit 5, ");
        }
        if ((this.flags & 0x40) != 0) {
            stringBuilder.append("Unknown bit 6, ");
        }
        if ((this.flags & 0x80) != 0) {
            stringBuilder.append("Unknown bit 7, ");
        }
        if (this.flags != 0) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        stringBuilder.append(")");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static String byteToBinary(int n) {
        String string = Integer.toBinaryString(n);
        string = "00000000".substring(string.length()) + string;
        return string;
    }
}

