/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pnm;

import com.twelvemonkeys.imageio.plugins.pnm.HeaderParser;
import com.twelvemonkeys.imageio.plugins.pnm.PNMHeader;
import com.twelvemonkeys.imageio.plugins.pnm.TupleType;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

final class PAMHeaderParser
extends HeaderParser {
    static final String ENDHDR = "ENDHDR";
    static final String WIDTH = "WIDTH";
    static final String HEIGHT = "HEIGHT";
    static final String MAXVAL = "MAXVAL";
    static final String DEPTH = "DEPTH";
    static final String TUPLTYPE = "TUPLTYPE";

    public PAMHeaderParser(ImageInputStream imageInputStream) {
        super(imageInputStream);
    }

    @Override
    public PNMHeader parse() throws IOException {
        String string;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        TupleType tupleType = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = this.input.readLine()) != null && !string.startsWith(ENDHDR)) {
            if ((string = string.trim()).isEmpty()) continue;
            if (string.startsWith(WIDTH)) {
                n = Integer.parseInt(string.substring(WIDTH.length() + 1));
                continue;
            }
            if (string.startsWith(HEIGHT)) {
                n2 = Integer.parseInt(string.substring(HEIGHT.length() + 1));
                continue;
            }
            if (string.startsWith(DEPTH)) {
                n3 = Integer.parseInt(string.substring(DEPTH.length() + 1));
                continue;
            }
            if (string.startsWith(MAXVAL)) {
                n4 = Integer.parseInt(string.substring(MAXVAL.length() + 1));
                continue;
            }
            if (string.startsWith(TUPLTYPE)) {
                tupleType = TupleType.valueOf(string.substring(TUPLTYPE.length() + 1));
                continue;
            }
            if (string.startsWith("#")) {
                arrayList.add(string.substring(1).trim());
                continue;
            }
            throw new IIOException("Unknown PAM header token: '" + string + "'");
        }
        if (tupleType == null) {
            // empty if block
        }
        return new PNMHeader(20535, tupleType, n, n2, n3, n4, arrayList);
    }
}

