/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pcx;

import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.plugins.pcx.BitRotator;
import com.twelvemonkeys.imageio.plugins.pcx.PCXHeader;
import com.twelvemonkeys.imageio.plugins.pcx.PCXMetadata;
import com.twelvemonkeys.imageio.plugins.pcx.RLEDecoder;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import com.twelvemonkeys.io.enc.Decoder;
import com.twelvemonkeys.io.enc.DecoderStream;
import com.twelvemonkeys.xml.XMLSerializer;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public final class PCXImageReader
extends ImageReaderBase {
    private static final ImageTypeSpecifier GRAYSCALE = ImageTypeSpecifiers.createGrayscale((int)8, (int)0);
    private PCXHeader header;
    private boolean readPalette;
    private IndexColorModel vgaPalette;

    public PCXImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    protected void resetMembers() {
        this.header = null;
        this.readPalette = false;
        this.vgaPalette = null;
    }

    public int getWidth(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return this.header.getWidth();
    }

    public int getHeight(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return this.header.getHeight();
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(n);
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        arrayList.add(imageTypeSpecifier);
        return arrayList.iterator();
    }

    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        int n2 = this.header.getChannels();
        int n3 = this.header.getPaletteInfo();
        ColorSpace colorSpace = n3 == 2 ? ColorSpace.getInstance(1003) : ColorSpace.getInstance(1000);
        switch (this.header.getBitsPerPixel()) {
            case 1: 
            case 2: 
            case 4: {
                return ImageTypeSpecifiers.createFromIndexColorModel((IndexColorModel)this.header.getEGAPalette());
            }
            case 8: {
                if (n2 == 1 && n3 != 2) {
                    IndexColorModel indexColorModel = this.getVGAPalette();
                    if (indexColorModel == null) {
                        throw new IIOException("Expected VGA palette not found");
                    }
                    return ImageTypeSpecifiers.createFromIndexColorModel((IndexColorModel)indexColorModel);
                }
                return ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])this.createIndices(n2, 1), (int[])this.createIndices(n2, 0), (int)0, (boolean)false, (boolean)false);
            }
            case 24: {
                return ImageTypeSpecifiers.createFromBufferedImageType((int)5);
            }
            case 32: {
                return ImageTypeSpecifiers.createFromBufferedImageType((int)6);
            }
        }
        throw new IIOException("Unknown number of bytes per pixel: " + this.header.getBitsPerPixel());
    }

    private int[] createIndices(int n, int n2) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i * n2;
        }
        return nArray;
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        Iterator<ImageTypeSpecifier> iterator = this.getImageTypes(n);
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(n);
        if (this.header.getPaletteInfo() != 1 && this.header.getPaletteInfo() != 2) {
            this.processWarningOccurred(String.format("Unsupported color mode: %d, colors may look incorrect", this.header.getPaletteInfo()));
        }
        int n2 = this.getWidth(n);
        int n3 = this.getHeight(n);
        BufferedImage bufferedImage = PCXImageReader.getDestination((ImageReadParam)imageReadParam, iterator, (int)n2, (int)n3);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        PCXImageReader.computeRegions((ImageReadParam)imageReadParam, (int)n2, (int)n3, (BufferedImage)bufferedImage, (Rectangle)rectangle, (Rectangle)rectangle2);
        WritableRaster writableRaster = this.clipToRect(bufferedImage.getRaster(), rectangle2, imageReadParam != null ? imageReadParam.getDestinationBands() : null);
        PCXImageReader.checkReadParamBandSettings((ImageReadParam)imageReadParam, (int)imageTypeSpecifier.getNumBands(), (int)writableRaster.getNumBands());
        int n4 = this.header.getCompression();
        DataInput dataInput = (DataInput)((Object)(n4 == 1 ? new DataInputStream((InputStream)new DecoderStream(IIOUtil.createStreamAdapter((ImageInputStream)this.imageInput), (Decoder)new RLEDecoder())) : this.imageInput));
        int n5 = imageReadParam != null ? imageReadParam.getSourceXSubsampling() : 1;
        int n6 = imageReadParam != null ? imageReadParam.getSourceYSubsampling() : 1;
        this.processImageStarted(n);
        if (imageTypeSpecifier.getColorModel() instanceof IndexColorModel && this.header.getChannels() > 1) {
            WritableRaster writableRaster2 = GRAYSCALE.createBufferedImage(this.header.getWidth(), 1).getRaster();
            Raster raster = this.clipRowToRect(writableRaster2, rectangle, imageReadParam != null ? imageReadParam.getSourceBands() : null, imageReadParam != null ? imageReadParam.getSourceXSubsampling() : 1);
            int n7 = this.header.getBytesPerLine();
            byte[] byArray = new byte[n7 * 8];
            byte[] byArray2 = ((DataBufferByte)writableRaster2.getDataBuffer()).getData();
            for (int i = 0; i < n3; ++i) {
                switch (this.header.getBitsPerPixel()) {
                    case 1: {
                        this.readRowByte(dataInput, rectangle, n5, n6, byArray, 0, n7 * this.header.getChannels(), writableRaster, raster, i);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                int n8 = 0;
                for (int j = 0; j < n7; ++j) {
                    BitRotator.bitRotateCW(byArray, j, n7, byArray2, n8, 1);
                    n8 += 8;
                }
                this.processImageProgress(100.0f * (float)i / (float)n3);
                if (i >= rectangle.y + rectangle.height) break;
                if (!this.abortRequested()) continue;
                this.processReadAborted();
                break;
            }
        } else if (this.header.getBitsPerPixel() == 24 || this.header.getBitsPerPixel() == 32) {
            int n9 = this.header.getBytesPerLine() * 8 / this.header.getBitsPerPixel();
            WritableRaster writableRaster3 = imageTypeSpecifier.createBufferedImage(n9, 1).getRaster();
            Raster raster = this.clipRowToRect(writableRaster3, rectangle, imageReadParam != null ? imageReadParam.getSourceBands() : null, imageReadParam != null ? imageReadParam.getSourceXSubsampling() : 1);
            for (int i = 0; i < n3; ++i) {
                byte[] byArray = ((DataBufferByte)writableRaster3.getDataBuffer()).getData();
                this.readRowByte(dataInput, rectangle, n5, n6, byArray, 0, byArray.length, writableRaster, raster, i);
                this.processImageProgress(100.0f * (float)i / (float)n3);
                if (i >= rectangle.y + rectangle.height) break;
                if (!this.abortRequested()) continue;
                this.processReadAborted();
                break;
            }
        } else {
            int n10 = this.header.getBytesPerLine() * 8 / this.header.getBitsPerPixel();
            WritableRaster writableRaster4 = imageTypeSpecifier.createBufferedImage(n10, 1).getRaster();
            Raster raster = this.clipRowToRect(writableRaster4, rectangle, imageReadParam != null ? imageReadParam.getSourceBands() : null, imageReadParam != null ? imageReadParam.getSourceXSubsampling() : 1);
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < this.header.getChannels(); ++j) {
                    WritableRaster writableRaster5 = writableRaster.createWritableChild(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight(), 0, 0, new int[]{j});
                    Raster raster2 = raster.createChild(raster.getMinX(), 0, raster.getWidth(), 1, 0, 0, new int[]{j});
                    switch (this.header.getBitsPerPixel()) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: {
                            byte[] byArray = ((DataBufferByte)writableRaster4.getDataBuffer()).getData(j);
                            this.readRowByte(dataInput, rectangle, n5, n6, byArray, 0, byArray.length, writableRaster5, raster2, i);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    if (this.abortRequested()) break;
                }
                this.processImageProgress(100.0f * (float)i / (float)n3);
                if (i >= rectangle.y + rectangle.height) break;
                if (!this.abortRequested()) continue;
                this.processReadAborted();
                break;
            }
        }
        this.processImageComplete();
        return bufferedImage;
    }

    private void readRowByte(DataInput dataInput, Rectangle rectangle, int n, int n2, byte[] byArray, int n3, int n4, WritableRaster writableRaster, Raster raster, int n5) throws IOException {
        int n6;
        if (n5 % n2 != 0 || n5 < rectangle.y || n5 >= rectangle.y + rectangle.height) {
            dataInput.skipBytes(n4);
            return;
        }
        dataInput.readFully(byArray, n3, n4);
        if (n != 1) {
            for (n6 = 0; n6 < rectangle.width / n; ++n6) {
                byArray[rectangle.x + n6] = byArray[rectangle.x + n6 * n];
            }
        }
        n6 = (n5 - rectangle.y) / n2;
        writableRaster.setDataElements(0, n6, raster);
    }

    private Raster clipRowToRect(Raster raster, Rectangle rectangle, int[] nArray, int n) {
        if (rectangle.contains(raster.getMinX(), 0, raster.getWidth(), 1) && n == 1 && nArray == null) {
            return raster;
        }
        return raster.createChild(rectangle.x / n, 0, rectangle.width / n, 1, 0, 0, nArray);
    }

    private WritableRaster clipToRect(WritableRaster writableRaster, Rectangle rectangle, int[] nArray) {
        if (rectangle.contains(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight()) && nArray == null) {
            return writableRaster;
        }
        return writableRaster.createWritableChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0, 0, nArray);
    }

    private void readHeader() throws IOException {
        if (this.header == null) {
            this.imageInput.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            this.header = PCXHeader.read(this.imageInput);
            this.imageInput.flushBefore(this.imageInput.getStreamPosition());
        }
        this.imageInput.seek(this.imageInput.getFlushedPosition());
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return new PCXMetadata(this.header, this.getVGAPalette());
    }

    private IndexColorModel getVGAPalette() throws IOException {
        if (!this.readPalette) {
            this.readHeader();
            this.readPalette = true;
            PCXImageReader.skipToEOF(this.imageInput);
            long l = this.imageInput.getStreamPosition() - 769L;
            if (l <= this.imageInput.getFlushedPosition()) {
                return null;
            }
            this.imageInput.seek(l);
            byte by = this.imageInput.readByte();
            if (by == 12) {
                byte[] byArray = new byte[768];
                this.imageInput.readFully(byArray);
                this.vgaPalette = new IndexColorModel(8, 256, byArray, 0, false);
                return this.vgaPalette;
            }
            return null;
        }
        return this.vgaPalette;
    }

    private static long skipToEOF(ImageInputStream imageInputStream) throws IOException {
        long l = imageInputStream.length();
        if (l > 0L) {
            imageInputStream.seek(l);
        } else {
            long l2 = imageInputStream.getStreamPosition();
            while (imageInputStream.skipBytes(1024L) > 0L && imageInputStream.read() != -1) {
                l2 = imageInputStream.getStreamPosition();
            }
            imageInputStream.seek(l2);
            while (imageInputStream.read() != -1) {
            }
        }
        return imageInputStream.getStreamPosition();
    }

    public static void main(String[] stringArray) throws IOException {
        PCXImageReader pCXImageReader = new PCXImageReader(null);
        for (String string : stringArray) {
            File file = new File(string);
            pCXImageReader.setInput(ImageIO.createImageInputStream(file));
            ImageReadParam imageReadParam = pCXImageReader.getDefaultReadParam();
            imageReadParam.setDestinationType(pCXImageReader.getImageTypes(0).next());
            System.err.println("header: " + pCXImageReader.header);
            BufferedImage bufferedImage = pCXImageReader.read(0, imageReadParam);
            System.err.println("image: " + bufferedImage);
            PCXImageReader.showIt((BufferedImage)bufferedImage, (String)file.getName());
            new XMLSerializer((OutputStream)System.out, System.getProperty("file.encoding")).serialize(pCXImageReader.getImageMetadata(0).getAsTree("javax_imageio_1.0"), false);
        }
    }
}

