/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.imageio.ImageWriterBase;
import com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageWriterSpi;
import com.twelvemonkeys.imageio.util.ProgressListenerBase;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteProgressListener;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPEGImageWriter
extends ImageWriterBase {
    private final ImageWriter delegate;
    private final ProgressDelegator progressDelegator;

    public JPEGImageWriter(JPEGImageWriterSpi jPEGImageWriterSpi, ImageWriter imageWriter) {
        super((ImageWriterSpi)jPEGImageWriterSpi);
        this.delegate = imageWriter;
        this.progressDelegator = new ProgressDelegator();
    }

    private void installListeners() {
        this.delegate.addIIOWriteProgressListener((IIOWriteProgressListener)((Object)this.progressDelegator));
        this.delegate.addIIOWriteWarningListener(this.progressDelegator);
    }

    protected void resetMembers() {
        this.installListeners();
    }

    public void setOutput(Object object) {
        super.setOutput(object);
        this.delegate.setOutput(object);
    }

    public Object getOutput() {
        return this.delegate.getOutput();
    }

    public Locale[] getAvailableLocales() {
        return this.delegate.getAvailableLocales();
    }

    public void setLocale(Locale locale) {
        this.delegate.setLocale(locale);
    }

    public Locale getLocale() {
        return this.delegate.getLocale();
    }

    public ImageWriteParam getDefaultWriteParam() {
        return this.delegate.getDefaultWriteParam();
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return this.delegate.getDefaultStreamMetadata(imageWriteParam);
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return this.delegate.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return this.delegate.convertStreamMetadata(iIOMetadata, imageWriteParam);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return this.delegate.convertImageMetadata(iIOMetadata, imageTypeSpecifier, imageWriteParam);
    }

    public int getNumThumbnailsSupported(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, IIOMetadata iIOMetadata, IIOMetadata iIOMetadata2) {
        return this.delegate.getNumThumbnailsSupported(imageTypeSpecifier, imageWriteParam, iIOMetadata, iIOMetadata2);
    }

    public Dimension[] getPreferredThumbnailSizes(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, IIOMetadata iIOMetadata, IIOMetadata iIOMetadata2) {
        return this.delegate.getPreferredThumbnailSizes(imageTypeSpecifier, imageWriteParam, iIOMetadata, iIOMetadata2);
    }

    public boolean canWriteRasters() {
        return this.delegate.canWriteRasters();
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.delegate.write(iIOMetadata, iIOImage, imageWriteParam);
    }

    public void write(IIOImage iIOImage) throws IOException {
        this.delegate.write(iIOImage);
    }

    public void write(RenderedImage renderedImage) throws IOException {
        this.delegate.write(renderedImage);
    }

    public boolean canWriteSequence() {
        return this.delegate.canWriteSequence();
    }

    public void prepareWriteSequence(IIOMetadata iIOMetadata) throws IOException {
        this.delegate.prepareWriteSequence(iIOMetadata);
    }

    public void writeToSequence(IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.delegate.writeToSequence(iIOImage, imageWriteParam);
    }

    public void endWriteSequence() throws IOException {
        this.delegate.endWriteSequence();
    }

    public boolean canReplaceStreamMetadata() throws IOException {
        return this.delegate.canReplaceStreamMetadata();
    }

    public void replaceStreamMetadata(IIOMetadata iIOMetadata) throws IOException {
        this.delegate.replaceStreamMetadata(iIOMetadata);
    }

    public boolean canReplaceImageMetadata(int n) throws IOException {
        return this.delegate.canReplaceImageMetadata(n);
    }

    public void replaceImageMetadata(int n, IIOMetadata iIOMetadata) throws IOException {
        this.delegate.replaceImageMetadata(n, iIOMetadata);
    }

    public boolean canInsertImage(int n) throws IOException {
        return this.delegate.canInsertImage(n);
    }

    public void writeInsert(int n, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.delegate.writeInsert(n, iIOImage, imageWriteParam);
    }

    public boolean canRemoveImage(int n) throws IOException {
        return this.delegate.canRemoveImage(n);
    }

    public void removeImage(int n) throws IOException {
        this.delegate.removeImage(n);
    }

    public boolean canWriteEmpty() throws IOException {
        return this.delegate.canWriteEmpty();
    }

    public void prepareWriteEmpty(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, int n, int n2, IIOMetadata iIOMetadata2, List<? extends BufferedImage> list, ImageWriteParam imageWriteParam) throws IOException {
        this.delegate.prepareWriteEmpty(iIOMetadata, imageTypeSpecifier, n, n2, iIOMetadata2, list, imageWriteParam);
    }

    public void endWriteEmpty() throws IOException {
        this.delegate.endWriteEmpty();
    }

    public boolean canInsertEmpty(int n) throws IOException {
        return this.delegate.canInsertEmpty(n);
    }

    public void prepareInsertEmpty(int n, ImageTypeSpecifier imageTypeSpecifier, int n2, int n3, IIOMetadata iIOMetadata, List<? extends BufferedImage> list, ImageWriteParam imageWriteParam) throws IOException {
        this.delegate.prepareInsertEmpty(n, imageTypeSpecifier, n2, n3, iIOMetadata, list, imageWriteParam);
    }

    public void endInsertEmpty() throws IOException {
        this.delegate.endInsertEmpty();
    }

    public boolean canReplacePixels(int n) throws IOException {
        return this.delegate.canReplacePixels(n);
    }

    public void prepareReplacePixels(int n, Rectangle rectangle) throws IOException {
        this.delegate.prepareReplacePixels(n, rectangle);
    }

    public void replacePixels(RenderedImage renderedImage, ImageWriteParam imageWriteParam) throws IOException {
        this.delegate.replacePixels(renderedImage, imageWriteParam);
    }

    public void replacePixels(Raster raster, ImageWriteParam imageWriteParam) throws IOException {
        this.delegate.replacePixels(raster, imageWriteParam);
    }

    public void endReplacePixels() throws IOException {
        this.delegate.endReplacePixels();
    }

    public void abort() {
        super.abort();
        this.delegate.abort();
    }

    public void reset() {
        super.reset();
        this.delegate.reset();
    }

    public void dispose() {
        super.dispose();
        this.delegate.dispose();
    }

    private class ProgressDelegator
    extends ProgressListenerBase
    implements IIOWriteWarningListener {
        private ProgressDelegator() {
        }

        public void imageComplete(ImageWriter imageWriter) {
            JPEGImageWriter.this.processImageComplete();
        }

        public void imageProgress(ImageWriter imageWriter, float f) {
            JPEGImageWriter.this.processImageProgress(f);
        }

        public void imageStarted(ImageWriter imageWriter, int n) {
            JPEGImageWriter.this.processImageStarted(n);
        }

        public void thumbnailComplete(ImageWriter imageWriter) {
            JPEGImageWriter.this.processThumbnailComplete();
        }

        public void thumbnailProgress(ImageWriter imageWriter, float f) {
            JPEGImageWriter.this.processThumbnailProgress(f);
        }

        public void thumbnailStarted(ImageWriter imageWriter, int n, int n2) {
            JPEGImageWriter.this.processThumbnailStarted(n, n2);
        }

        public void writeAborted(ImageWriter imageWriter) {
            JPEGImageWriter.this.processWriteAborted();
        }

        public void warningOccurred(ImageWriter imageWriter, int n, String string) {
            JPEGImageWriter.this.processWarningOccurred(n, string);
        }
    }
}

