/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.imageio.plugins.iff.IFFChunk;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.IIOException;

final class DPELChunk
extends IFFChunk {
    TypeDepth[] typeDepths;

    DPELChunk(int n) {
        super(1146111308, n);
    }

    @Override
    void readChunk(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (this.chunkLength != 4 + n * 4) {
            throw new IIOException("Unsupported DPEL chunk length: " + this.chunkLength);
        }
        this.typeDepths = new TypeDepth[n];
        for (int i = 0; i < n; ++i) {
            this.typeDepths[i] = new TypeDepth(dataInput.readUnsignedShort(), dataInput.readUnsignedShort());
        }
    }

    @Override
    void writeChunk(DataOutput dataOutput) {
        throw new InternalError("Not implemented: writeChunk()");
    }

    @Override
    public String toString() {
        return super.toString() + "{typeDepths=" + Arrays.toString(this.typeDepths) + '}';
    }

    public int bitsPerPixel() {
        int n = 0;
        for (TypeDepth typeDepth : this.typeDepths) {
            n += typeDepth.bitDepth;
        }
        return n;
    }

    static class TypeDepth {
        final int type;
        final int bitDepth;

        TypeDepth(int n, int n2) {
            this.type = n;
            this.bitDepth = n2;
        }

        public String toString() {
            return "TypeDepth{type=" + this.type + ", bits=" + this.bitDepth + '}';
        }
    }
}

