/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.imageio.plugins.iff.IFFChunk;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.imageio.IIOException;

final class GRABChunk
extends IFFChunk {
    Point2D point;

    protected GRABChunk(int n) {
        super(1196572994, n);
    }

    protected GRABChunk(Point2D point2D) {
        super(1196572994, 4);
        this.point = point2D;
    }

    void readChunk(DataInput dataInput) throws IOException {
        if (this.chunkLength != 4) {
            throw new IIOException("Unknown GRAB chunk size: " + this.chunkLength);
        }
        this.point = new Point(dataInput.readShort(), dataInput.readShort());
    }

    void writeChunk(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort((int)this.point.getX());
        dataOutput.writeShort((int)this.point.getY());
    }

    public String toString() {
        return super.toString() + " {point=" + this.point + "}";
    }
}

