/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.icns;

import com.twelvemonkeys.imageio.plugins.icns.ICNSUtil;
import com.twelvemonkeys.lang.Validate;
import java.awt.Dimension;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

final class IconResource {
    protected final long start;
    protected final int type;
    protected final int length;

    private IconResource(long l, int n, int n2) {
        this.validate(n, n2);
        this.start = l;
        this.type = n;
        this.length = n2;
    }

    public static IconResource read(ImageInputStream imageInputStream) throws IOException {
        return new IconResource(imageInputStream.getStreamPosition(), imageInputStream.readInt(), imageInputStream.readInt());
    }

    private void validate(int n, int n2) {
        switch (n) {
            case 1229147982: {
                this.validateLengthForType(n, n2, 128);
                break;
            }
            case 1229147683: {
                this.validateLengthForType(n, n2, 256);
                break;
            }
            case 1768123683: {
                this.validateLengthForType(n, n2, 48);
                break;
            }
            case 1768123700: {
                this.validateLengthForType(n, n2, 96);
                break;
            }
            case 1768123704: {
                this.validateLengthForType(n, n2, 192);
                break;
            }
            case 1768125219: {
                this.validateLengthForType(n, n2, 64);
                break;
            }
            case 1768125236: {
                this.validateLengthForType(n, n2, 128);
                break;
            }
            case 1768125240: 
            case 1933077867: {
                this.validateLengthForType(n, n2, 256);
                break;
            }
            case 1768123444: {
                this.validateLengthForType(n, n2, 512);
                break;
            }
            case 1768123448: 
            case 1815637355: {
                this.validateLengthForType(n, n2, 1024);
                break;
            }
            case 1768122403: {
                this.validateLengthForType(n, n2, 576);
                break;
            }
            case 1768122420: {
                this.validateLengthForType(n, n2, 1152);
                break;
            }
            case 1748528491: 
            case 1768122424: {
                this.validateLengthForType(n, n2, 2304);
                break;
            }
            case 1949855083: {
                this.validateLengthForType(n, n2, 16384);
                break;
            }
            case 1768108088: 
            case 1768108089: 
            case 1768108336: 
            case 1768436530: 
            case 1768698674: 
            case 1769157426: 
            case 1769222962: {
                if (n2 > 8) break;
                throw new IllegalArgumentException(String.format("Wrong combination of icon type '%s' and length: %d", ICNSUtil.intToStr(n), n2));
            }
            case 1768123990: {
                this.validateLengthForType(n, n2, 4);
                break;
            }
            default: {
                if (n2 > 8) break;
                throw new IllegalStateException(String.format("Unknown icon type: '%s' length: %d", ICNSUtil.intToStr(n), n2));
            }
        }
    }

    private void validateLengthForType(int n, int n2, int n3) {
        Validate.isTrue((n2 == n3 + 8 ? 1 : 0) != 0, (String)String.format("Wrong combination of icon type '%s' and length: %d (expected: %d)", ICNSUtil.intToStr(n), n2 - 8, n3));
    }

    public Dimension size() {
        switch (this.type) {
            case 1229147683: 
            case 1229147982: {
                return new Dimension(32, 32);
            }
            case 1768123683: 
            case 1768123700: 
            case 1768123704: {
                return new Dimension(16, 12);
            }
            case 1768125219: 
            case 1768125236: 
            case 1768125240: 
            case 1769157426: 
            case 1933077867: {
                return new Dimension(16, 16);
            }
            case 1768123444: 
            case 1768123448: 
            case 1768698674: 
            case 1815637355: {
                return new Dimension(32, 32);
            }
            case 1748528491: 
            case 1768122403: 
            case 1768122420: 
            case 1768122424: 
            case 1768436530: {
                return new Dimension(48, 48);
            }
            case 1769222962: 
            case 1949855083: {
                return new Dimension(128, 128);
            }
            case 1768108088: {
                return new Dimension(256, 256);
            }
            case 1768108089: {
                return new Dimension(512, 512);
            }
            case 1768108336: {
                return new Dimension(1024, 1024);
            }
        }
        throw new IllegalStateException(String.format("Unknown icon type: '%s'", ICNSUtil.intToStr(this.type)));
    }

    public int depth() {
        switch (this.type) {
            case 1229147683: 
            case 1229147982: 
            case 1768122403: 
            case 1768123683: 
            case 1768125219: {
                return 1;
            }
            case 1768122420: 
            case 1768123444: 
            case 1768123700: 
            case 1768125236: {
                return 4;
            }
            case 1748528491: 
            case 1768122424: 
            case 1768123448: 
            case 1768123704: 
            case 1768125240: 
            case 1815637355: 
            case 1933077867: 
            case 1949855083: {
                return 8;
            }
            case 1768108088: 
            case 1768108089: 
            case 1768108336: 
            case 1768436530: 
            case 1768698674: 
            case 1769157426: 
            case 1769222962: {
                return 32;
            }
        }
        throw new IllegalStateException(String.format("Unknown icon type: '%s'", ICNSUtil.intToStr(this.type)));
    }

    public boolean isUnknownType() {
        switch (this.type) {
            case 1229147683: 
            case 1229147982: 
            case 1748528491: 
            case 1768108088: 
            case 1768108089: 
            case 1768108336: 
            case 1768122403: 
            case 1768122420: 
            case 1768122424: 
            case 1768123444: 
            case 1768123448: 
            case 1768123683: 
            case 1768123700: 
            case 1768123704: 
            case 1768125219: 
            case 1768125236: 
            case 1768125240: 
            case 1768436530: 
            case 1768698674: 
            case 1769157426: 
            case 1769222962: 
            case 1815637355: 
            case 1933077867: 
            case 1949855083: {
                return false;
            }
        }
        return true;
    }

    public boolean hasMask() {
        switch (this.type) {
            case 1229147683: 
            case 1768122403: 
            case 1768123683: 
            case 1768125219: {
                return true;
            }
        }
        return false;
    }

    public boolean isMaskType() {
        switch (this.type) {
            case 1748528491: 
            case 1815637355: 
            case 1933077867: 
            case 1949855083: {
                return true;
            }
        }
        return false;
    }

    public boolean isCompressed() {
        switch (this.type) {
            case 1768436530: 
            case 1768698674: 
            case 1769157426: 
            case 1769222962: {
                Dimension dimension = this.size();
                if (this.length == dimension.width * dimension.height * this.depth() / 8 + 8) break;
                return true;
            }
        }
        return false;
    }

    public boolean isForeignFormat() {
        switch (this.type) {
            case 1768108088: 
            case 1768108089: 
            case 1768108336: {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return (int)this.start ^ this.type;
    }

    public boolean equals(Object object) {
        return object == this || object != null && object.getClass() == this.getClass() && this.isEqual((IconResource)object);
    }

    private boolean isEqual(IconResource iconResource) {
        return this.start == iconResource.start && this.type == iconResource.type && this.length == iconResource.length;
    }

    public String toString() {
        return String.format("%s['%s' start: %d, length: %d%s]", this.getClass().getSimpleName(), ICNSUtil.intToStr(this.type), this.start, this.length, this.isCompressed() ? " (compressed)" : "");
    }
}

