/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.hdr;

import com.twelvemonkeys.imageio.plugins.hdr.HDR;
import com.twelvemonkeys.imageio.plugins.hdr.HDRImageReader;
import com.twelvemonkeys.imageio.plugins.hdr.HDRProviderInfo;
import com.twelvemonkeys.imageio.spi.ImageReaderSpiBase;
import com.twelvemonkeys.imageio.spi.ReaderWriterProviderInfo;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public final class HDRImageReaderSpi
extends ImageReaderSpiBase {
    public HDRImageReaderSpi() {
        super((ReaderWriterProviderInfo)new HDRProviderInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDecodeInput(Object object) throws IOException {
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        imageInputStream.mark();
        try {
            byte[] byArray = new byte[HDR.RADIANCE_MAGIC.length];
            imageInputStream.readFully(byArray);
            boolean bl = Arrays.equals(HDR.RADIANCE_MAGIC, byArray) || Arrays.equals(HDR.RGBE_MAGIC, Arrays.copyOf(byArray, 6));
            return bl;
        }
        finally {
            imageInputStream.reset();
        }
    }

    public ImageReader createReaderInstance(Object object) throws IOException {
        return new HDRImageReader((ImageReaderSpi)((Object)this));
    }

    public String getDescription(Locale locale) {
        return "Radiance RGBE High Dynaimc Range (HDR) image reader";
    }
}

