/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.dds;

import com.twelvemonkeys.imageio.plugins.dds.DDSType;
import com.twelvemonkeys.imageio.plugins.dds.DX10DXGIFormat;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public final class DX10Header {
    final DX10DXGIFormat dxgiFormat;
    final int resourceDimension;
    final int miscFlag;
    final int arraySize;
    final int miscFlags2;

    private DX10Header(int n, int n2, int n3, int n4, int n5) {
        this.dxgiFormat = DX10DXGIFormat.getFormat(n);
        this.resourceDimension = n2;
        if (this.resourceDimension != 3) {
            throw new IllegalArgumentException("Resource dimension " + n2 + " is not supported, expected 3.");
        }
        this.miscFlag = n3;
        this.arraySize = n4;
        this.miscFlags2 = n5;
    }

    static DX10Header read(ImageInputStream imageInputStream) throws IOException {
        int n = imageInputStream.readInt();
        int n2 = imageInputStream.readInt();
        int n3 = imageInputStream.readInt();
        int n4 = imageInputStream.readInt();
        int n5 = imageInputStream.readInt();
        return new DX10Header(n, n2, n3, n4, n5);
    }

    DDSType getDDSType() {
        return this.dxgiFormat.getCorrespondingType();
    }
}

