/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.dds;

import com.twelvemonkeys.imageio.plugins.dds.DDSHeader;
import com.twelvemonkeys.imageio.plugins.dds.DDSType;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

final class DDSReader {
    static final Order ARGB_ORDER = new Order(16, 8, 0, 24);
    private final DDSHeader header;
    private static final int[] A1R5G5B5_MASKS = new int[]{31744, 992, 31, 32768};
    private static final int[] X1R5G5B5_MASKS = new int[]{31744, 992, 31, 0};
    private static final int[] A4R4G4B4_MASKS = new int[]{3840, 240, 15, 61440};
    private static final int[] X4R4G4B4_MASKS = new int[]{3840, 240, 15, 0};
    private static final int[] R5G6B5_MASKS = new int[]{63488, 2016, 31, 0};
    private static final int[] R8G8B8_MASKS = new int[]{0xFF0000, 65280, 255, 0};
    private static final int[] A8B8G8R8_MASKS = new int[]{255, 65280, 0xFF0000, -16777216};
    private static final int[] X8B8G8R8_MASKS = new int[]{255, 65280, 0xFF0000, 0};
    private static final int[] A8R8G8B8_MASKS = new int[]{0xFF0000, 65280, 255, -16777216};
    private static final int[] X8R8G8B8_MASKS = new int[]{0xFF0000, 65280, 255, 0};
    private static final int[] BIT5 = new int[]{0, 8, 16, 25, 33, 41, 49, 58, 66, 74, 82, 90, 99, 107, 115, 123, 132, 140, 148, 156, 165, 173, 181, 189, 197, 206, 214, 222, 230, 239, 247, 255};
    private static final int[] BIT6 = new int[]{0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 45, 49, 53, 57, 61, 65, 69, 73, 77, 81, 85, 89, 93, 97, 101, 105, 109, 113, 117, 121, 125, 130, 134, 138, 142, 146, 150, 154, 158, 162, 166, 170, 174, 178, 182, 186, 190, 194, 198, 202, 206, 210, 215, 219, 223, 227, 231, 235, 239, 243, 247, 251, 255};

    DDSReader(DDSHeader dDSHeader) {
        this.header = dDSHeader;
    }

    int[] read(ImageInputStream imageInputStream, int n) throws IOException {
        int n2;
        int n3;
        DDSType dDSType = this.getType();
        byte[] byArray = null;
        for (n3 = 0; n3 <= n; ++n3) {
            n2 = this.getLength(dDSType, n3);
            byArray = new byte[n2];
            imageInputStream.readFully(byArray);
        }
        n3 = this.header.getWidth(n);
        n2 = this.header.getHeight(n);
        switch (dDSType) {
            case DXT1: {
                return DDSReader.decodeDXT1(n3, n2, byArray);
            }
            case DXT2: {
                return DDSReader.decodeDXT2(n3, n2, byArray);
            }
            case DXT3: {
                return DDSReader.decodeDXT3(n3, n2, byArray);
            }
            case DXT4: {
                return DDSReader.decodeDXT4(n3, n2, byArray);
            }
            case DXT5: {
                return DDSReader.decodeDXT5(n3, n2, byArray);
            }
            case A1R5G5B5: {
                return DDSReader.readA1R5G5B5(n3, n2, byArray);
            }
            case X1R5G5B5: {
                return DDSReader.readX1R5G5B5(n3, n2, byArray);
            }
            case A4R4G4B4: {
                return DDSReader.readA4R4G4B4(n3, n2, byArray);
            }
            case X4R4G4B4: {
                return DDSReader.readX4R4G4B4(n3, n2, byArray);
            }
            case R5G6B5: {
                return DDSReader.readR5G6B5(n3, n2, byArray);
            }
            case R8G8B8: {
                return DDSReader.readR8G8B8(n3, n2, byArray);
            }
            case A8B8G8R8: {
                return DDSReader.readA8B8G8R8(n3, n2, byArray);
            }
            case X8B8G8R8: {
                return DDSReader.readX8B8G8R8(n3, n2, byArray);
            }
            case A8R8G8B8: {
                return DDSReader.readA8R8G8B8(n3, n2, byArray);
            }
            case X8R8G8B8: {
                return DDSReader.readX8R8G8B8(n3, n2, byArray);
            }
        }
        throw new IIOException("Unsupported type: " + (Object)((Object)dDSType));
    }

    private DDSType getType() throws IIOException {
        int n = this.header.getPixelFormatFlags();
        if ((n & 4) != 0) {
            int n2 = this.header.getFourCC();
            return DDSType.valueOf(n2);
        }
        if ((n & 0x40) != 0) {
            int n3;
            int n4 = this.header.getBitCount();
            int n5 = this.header.getRedMask();
            int n6 = this.header.getGreenMask();
            int n7 = this.header.getBlueMask();
            int n8 = n3 = (n & 1) != 0 ? this.header.getAlphaMask() : 0;
            if (n4 == 16) {
                if (n5 == A1R5G5B5_MASKS[0] && n6 == A1R5G5B5_MASKS[1] && n7 == A1R5G5B5_MASKS[2] && n3 == A1R5G5B5_MASKS[3]) {
                    return DDSType.A1R5G5B5;
                }
                if (n5 == X1R5G5B5_MASKS[0] && n6 == X1R5G5B5_MASKS[1] && n7 == X1R5G5B5_MASKS[2] && n3 == X1R5G5B5_MASKS[3]) {
                    return DDSType.X1R5G5B5;
                }
                if (n5 == A4R4G4B4_MASKS[0] && n6 == A4R4G4B4_MASKS[1] && n7 == A4R4G4B4_MASKS[2] && n3 == A4R4G4B4_MASKS[3]) {
                    return DDSType.A4R4G4B4;
                }
                if (n5 == X4R4G4B4_MASKS[0] && n6 == X4R4G4B4_MASKS[1] && n7 == X4R4G4B4_MASKS[2] && n3 == X4R4G4B4_MASKS[3]) {
                    return DDSType.X4R4G4B4;
                }
                if (n5 == R5G6B5_MASKS[0] && n6 == R5G6B5_MASKS[1] && n7 == R5G6B5_MASKS[2] && n3 == R5G6B5_MASKS[3]) {
                    return DDSType.R5G6B5;
                }
                throw new IIOException("Unsupported 16bit RGB image.");
            }
            if (n4 == 24) {
                if (n5 == R8G8B8_MASKS[0] && n6 == R8G8B8_MASKS[1] && n7 == R8G8B8_MASKS[2] && n3 == R8G8B8_MASKS[3]) {
                    return DDSType.R8G8B8;
                }
                throw new IIOException("Unsupported 24bit RGB image.");
            }
            if (n4 == 32) {
                if (n5 == A8B8G8R8_MASKS[0] && n6 == A8B8G8R8_MASKS[1] && n7 == A8B8G8R8_MASKS[2] && n3 == A8B8G8R8_MASKS[3]) {
                    return DDSType.A8B8G8R8;
                }
                if (n5 == X8B8G8R8_MASKS[0] && n6 == X8B8G8R8_MASKS[1] && n7 == X8B8G8R8_MASKS[2] && n3 == X8B8G8R8_MASKS[3]) {
                    return DDSType.X8B8G8R8;
                }
                if (n5 == A8R8G8B8_MASKS[0] && n6 == A8R8G8B8_MASKS[1] && n7 == A8R8G8B8_MASKS[2] && n3 == A8R8G8B8_MASKS[3]) {
                    return DDSType.A8R8G8B8;
                }
                if (n5 == X8R8G8B8_MASKS[0] && n6 == X8R8G8B8_MASKS[1] && n7 == X8R8G8B8_MASKS[2] && n3 == X8R8G8B8_MASKS[3]) {
                    return DDSType.X8R8G8B8;
                }
                throw new IIOException("Unsupported 32bit RGB image.");
            }
            throw new IIOException("Unsupported bit count: " + n4);
        }
        throw new IIOException("Unsupported YUV or LUMINANCE image.");
    }

    private int getLength(DDSType dDSType, int n) throws IIOException {
        int n2 = this.header.getWidth(n);
        int n3 = this.header.getHeight(n);
        switch (dDSType) {
            case DXT1: {
                return 8 * ((n2 + 3) / 4) * ((n3 + 3) / 4);
            }
            case DXT2: 
            case DXT3: 
            case DXT4: 
            case DXT5: {
                return 16 * ((n2 + 3) / 4) * ((n3 + 3) / 4);
            }
            case A1R5G5B5: 
            case X1R5G5B5: 
            case A4R4G4B4: 
            case X4R4G4B4: 
            case R5G6B5: 
            case R8G8B8: 
            case A8B8G8R8: 
            case X8B8G8R8: 
            case A8R8G8B8: 
            case X8R8G8B8: {
                return (dDSType.value() & 0xFF) * n2 * n3;
            }
        }
        throw new IIOException("Unknown type: " + Integer.toHexString(dDSType.value()));
    }

    private static int[] decodeDXT1(int n, int n2, byte[] byArray) {
        int[] nArray = new int[n * n2];
        int n3 = 0;
        int n4 = (n + 3) / 4;
        int n5 = (n2 + 3) / 4;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n6 = byArray[n3] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8;
                int n7 = byArray[n3 += 2] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8;
                n3 += 2;
                for (int k = 0; k < 4 && 4 * i + k < n2; ++k) {
                    int n8 = byArray[n3] & 3;
                    int n9 = (byArray[n3] & 0xC) >> 2;
                    int n10 = (byArray[n3] & 0x30) >> 4;
                    int n11 = (byArray[n3++] & 0xC0) >> 6;
                    nArray[4 * n * i + 4 * j + n * k] = DDSReader.getDXTColor(n6, n7, 255, n8);
                    if (4 * j + 1 >= n) continue;
                    nArray[4 * n * i + 4 * j + n * k + 1] = DDSReader.getDXTColor(n6, n7, 255, n9);
                    if (4 * j + 2 >= n) continue;
                    nArray[4 * n * i + 4 * j + n * k + 2] = DDSReader.getDXTColor(n6, n7, 255, n10);
                    if (4 * j + 3 >= n) continue;
                    nArray[4 * n * i + 4 * j + n * k + 3] = DDSReader.getDXTColor(n6, n7, 255, n11);
                }
            }
        }
        return nArray;
    }

    private static int[] decodeDXT2(int n, int n2, byte[] byArray) {
        return DDSReader.decodeDXT3(n, n2, byArray);
    }

    private static int[] decodeDXT3(int n, int n2, byte[] byArray) {
        int n3 = 0;
        int n4 = (n + 3) / 4;
        int n5 = (n2 + 3) / 4;
        int[] nArray = new int[n * n2];
        int[] nArray2 = new int[16];
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n6;
                int n7;
                int n8;
                for (n8 = 0; n8 < 4; ++n8) {
                    n7 = byArray[n3++] & 0xFF;
                    n6 = byArray[n3++] & 0xFF;
                    nArray2[4 * n8] = 17 * ((n7 & 0xF0) >> 4);
                    nArray2[4 * n8 + 1] = 17 * (n7 & 0xF);
                    nArray2[4 * n8 + 2] = 17 * ((n6 & 0xF0) >> 4);
                    nArray2[4 * n8 + 3] = 17 * (n6 & 0xF);
                }
                n8 = byArray[n3] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8;
                n7 = byArray[n3 += 2] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8;
                n3 += 2;
                for (n6 = 0; n6 < 4 && 4 * i + n6 < n2; ++n6) {
                    int n9 = byArray[n3] & 3;
                    int n10 = (byArray[n3] & 0xC) >> 2;
                    int n11 = (byArray[n3] & 0x30) >> 4;
                    int n12 = (byArray[n3++] & 0xC0) >> 6;
                    nArray[4 * n * i + 4 * j + n * n6] = DDSReader.getDXTColor(n8, n7, nArray2[4 * n6], n9);
                    if (4 * j + 1 >= n) continue;
                    nArray[4 * n * i + 4 * j + n * n6 + 1] = DDSReader.getDXTColor(n8, n7, nArray2[4 * n6 + 1], n10);
                    if (4 * j + 2 >= n) continue;
                    nArray[4 * n * i + 4 * j + n * n6 + 2] = DDSReader.getDXTColor(n8, n7, nArray2[4 * n6 + 2], n11);
                    if (4 * j + 3 >= n) continue;
                    nArray[4 * n * i + 4 * j + n * n6 + 3] = DDSReader.getDXTColor(n8, n7, nArray2[4 * n6 + 3], n12);
                }
            }
        }
        return nArray;
    }

    private static int[] decodeDXT4(int n, int n2, byte[] byArray) {
        return DDSReader.decodeDXT5(n, n2, byArray);
    }

    private static int[] decodeDXT5(int n, int n2, byte[] byArray) {
        int n3 = 0;
        int n4 = (n + 3) / 4;
        int n5 = (n2 + 3) / 4;
        int[] nArray = new int[n * n2];
        int[] nArray2 = new int[16];
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n6 = byArray[n3++] & 0xFF;
                int n7 = byArray[n3++] & 0xFF;
                int n8 = byArray[n3] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8 | (byArray[n3 + 2] & 0xFF) << 16;
                int n9 = byArray[n3 += 3] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8 | (byArray[n3 + 2] & 0xFF) << 16;
                n3 += 3;
                nArray2[0] = n8 & 7;
                nArray2[1] = n8 >> 3 & 7;
                nArray2[2] = n8 >> 6 & 7;
                nArray2[3] = n8 >> 9 & 7;
                nArray2[4] = n8 >> 12 & 7;
                nArray2[5] = n8 >> 15 & 7;
                nArray2[6] = n8 >> 18 & 7;
                nArray2[7] = n8 >> 21 & 7;
                nArray2[8] = n9 & 7;
                nArray2[9] = n9 >> 3 & 7;
                nArray2[10] = n9 >> 6 & 7;
                nArray2[11] = n9 >> 9 & 7;
                nArray2[12] = n9 >> 12 & 7;
                nArray2[13] = n9 >> 15 & 7;
                nArray2[14] = n9 >> 18 & 7;
                nArray2[15] = n9 >> 21 & 7;
                int n10 = byArray[n3] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8;
                int n11 = byArray[n3 += 2] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8;
                n3 += 2;
                for (int k = 0; k < 4 && 4 * i + k < n2; ++k) {
                    int n12 = byArray[n3] & 3;
                    int n13 = (byArray[n3] & 0xC) >> 2;
                    int n14 = (byArray[n3] & 0x30) >> 4;
                    int n15 = (byArray[n3++] & 0xC0) >> 6;
                    nArray[4 * n * i + 4 * j + n * k] = DDSReader.getDXTColor(n10, n11, DDSReader.getDXT5Alpha(n6, n7, nArray2[4 * k]), n12);
                    if (4 * j + 1 >= n) continue;
                    nArray[4 * n * i + 4 * j + n * k + 1] = DDSReader.getDXTColor(n10, n11, DDSReader.getDXT5Alpha(n6, n7, nArray2[4 * k + 1]), n13);
                    if (4 * j + 2 >= n) continue;
                    nArray[4 * n * i + 4 * j + n * k + 2] = DDSReader.getDXTColor(n10, n11, DDSReader.getDXT5Alpha(n6, n7, nArray2[4 * k + 2]), n14);
                    if (4 * j + 3 >= n) continue;
                    nArray[4 * n * i + 4 * j + n * k + 3] = DDSReader.getDXTColor(n10, n11, DDSReader.getDXT5Alpha(n6, n7, nArray2[4 * k + 3]), n15);
                }
            }
        }
        return nArray;
    }

    private static int[] readA1R5G5B5(int n, int n2, byte[] byArray) {
        int n3 = 0;
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2 * n; ++i) {
            int n4 = byArray[n3] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8;
            n3 += 2;
            int n5 = BIT5[(n4 & A1R5G5B5_MASKS[0]) >> 10];
            int n6 = BIT5[(n4 & A1R5G5B5_MASKS[1]) >> 5];
            int n7 = BIT5[n4 & A1R5G5B5_MASKS[2]];
            int n8 = 255 * ((n4 & A1R5G5B5_MASKS[3]) >> 15);
            nArray[i] = n8 << DDSReader.ARGB_ORDER.alphaShift | n5 << DDSReader.ARGB_ORDER.redShift | n6 << DDSReader.ARGB_ORDER.greenShift | n7 << DDSReader.ARGB_ORDER.blueShift;
        }
        return nArray;
    }

    private static int[] readX1R5G5B5(int n, int n2, byte[] byArray) {
        int n3 = 0;
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2 * n; ++i) {
            int n4 = byArray[n3] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8;
            n3 += 2;
            int n5 = BIT5[(n4 & X1R5G5B5_MASKS[0]) >> 10];
            int n6 = BIT5[(n4 & X1R5G5B5_MASKS[1]) >> 5];
            int n7 = BIT5[n4 & X1R5G5B5_MASKS[2]];
            int n8 = 255;
            nArray[i] = n8 << DDSReader.ARGB_ORDER.alphaShift | n5 << DDSReader.ARGB_ORDER.redShift | n6 << DDSReader.ARGB_ORDER.greenShift | n7 << DDSReader.ARGB_ORDER.blueShift;
        }
        return nArray;
    }

    private static int[] readA4R4G4B4(int n, int n2, byte[] byArray) {
        int n3 = 0;
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2 * n; ++i) {
            int n4 = byArray[n3] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8;
            n3 += 2;
            int n5 = 17 * ((n4 & A4R4G4B4_MASKS[0]) >> 8);
            int n6 = 17 * ((n4 & A4R4G4B4_MASKS[1]) >> 4);
            int n7 = 17 * (n4 & A4R4G4B4_MASKS[2]);
            int n8 = 17 * ((n4 & A4R4G4B4_MASKS[3]) >> 12);
            nArray[i] = n8 << DDSReader.ARGB_ORDER.alphaShift | n5 << DDSReader.ARGB_ORDER.redShift | n6 << DDSReader.ARGB_ORDER.greenShift | n7 << DDSReader.ARGB_ORDER.blueShift;
        }
        return nArray;
    }

    private static int[] readX4R4G4B4(int n, int n2, byte[] byArray) {
        int n3 = 0;
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2 * n; ++i) {
            int n4 = byArray[n3] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8;
            n3 += 2;
            int n5 = 17 * ((n4 & A4R4G4B4_MASKS[0]) >> 8);
            int n6 = 17 * ((n4 & A4R4G4B4_MASKS[1]) >> 4);
            int n7 = 17 * (n4 & A4R4G4B4_MASKS[2]);
            int n8 = 255;
            nArray[i] = n8 << DDSReader.ARGB_ORDER.alphaShift | n5 << DDSReader.ARGB_ORDER.redShift | n6 << DDSReader.ARGB_ORDER.greenShift | n7 << DDSReader.ARGB_ORDER.blueShift;
        }
        return nArray;
    }

    private static int[] readR5G6B5(int n, int n2, byte[] byArray) {
        int n3 = 0;
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2 * n; ++i) {
            int n4 = byArray[n3] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8;
            n3 += 2;
            int n5 = BIT5[(n4 & R5G6B5_MASKS[0]) >> 11];
            int n6 = BIT6[(n4 & R5G6B5_MASKS[1]) >> 5];
            int n7 = BIT5[n4 & R5G6B5_MASKS[2]];
            int n8 = 255;
            nArray[i] = n8 << DDSReader.ARGB_ORDER.alphaShift | n5 << DDSReader.ARGB_ORDER.redShift | n6 << DDSReader.ARGB_ORDER.greenShift | n7 << DDSReader.ARGB_ORDER.blueShift;
        }
        return nArray;
    }

    private static int[] readR8G8B8(int n, int n2, byte[] byArray) {
        int n3 = 0;
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2 * n; ++i) {
            int n4 = byArray[n3++] & 0xFF;
            int n5 = byArray[n3++] & 0xFF;
            int n6 = byArray[n3++] & 0xFF;
            int n7 = 255;
            nArray[i] = n7 << DDSReader.ARGB_ORDER.alphaShift | n6 << DDSReader.ARGB_ORDER.redShift | n5 << DDSReader.ARGB_ORDER.greenShift | n4 << DDSReader.ARGB_ORDER.blueShift;
        }
        return nArray;
    }

    private static int[] readA8B8G8R8(int n, int n2, byte[] byArray) {
        int n3 = 0;
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2 * n; ++i) {
            int n4 = byArray[n3++] & 0xFF;
            int n5 = byArray[n3++] & 0xFF;
            int n6 = byArray[n3++] & 0xFF;
            int n7 = byArray[n3++] & 0xFF;
            nArray[i] = n7 << DDSReader.ARGB_ORDER.alphaShift | n4 << DDSReader.ARGB_ORDER.redShift | n5 << DDSReader.ARGB_ORDER.greenShift | n6 << DDSReader.ARGB_ORDER.blueShift;
        }
        return nArray;
    }

    private static int[] readX8B8G8R8(int n, int n2, byte[] byArray) {
        int n3 = 0;
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2 * n; ++i) {
            int n4 = byArray[n3++] & 0xFF;
            int n5 = byArray[n3++] & 0xFF;
            int n6 = byArray[n3++] & 0xFF;
            int n7 = 255;
            ++n3;
            nArray[i] = n7 << DDSReader.ARGB_ORDER.alphaShift | n4 << DDSReader.ARGB_ORDER.redShift | n5 << DDSReader.ARGB_ORDER.greenShift | n6 << DDSReader.ARGB_ORDER.blueShift;
        }
        return nArray;
    }

    private static int[] readA8R8G8B8(int n, int n2, byte[] byArray) {
        int n3 = 0;
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2 * n; ++i) {
            int n4 = byArray[n3++] & 0xFF;
            int n5 = byArray[n3++] & 0xFF;
            int n6 = byArray[n3++] & 0xFF;
            int n7 = byArray[n3++] & 0xFF;
            nArray[i] = n7 << DDSReader.ARGB_ORDER.alphaShift | n6 << DDSReader.ARGB_ORDER.redShift | n5 << DDSReader.ARGB_ORDER.greenShift | n4 << DDSReader.ARGB_ORDER.blueShift;
        }
        return nArray;
    }

    private static int[] readX8R8G8B8(int n, int n2, byte[] byArray) {
        int n3 = 0;
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2 * n; ++i) {
            int n4 = byArray[n3++] & 0xFF;
            int n5 = byArray[n3++] & 0xFF;
            int n6 = byArray[n3++] & 0xFF;
            int n7 = 255;
            ++n3;
            nArray[i] = n7 << DDSReader.ARGB_ORDER.alphaShift | n6 << DDSReader.ARGB_ORDER.redShift | n5 << DDSReader.ARGB_ORDER.greenShift | n4 << DDSReader.ARGB_ORDER.blueShift;
        }
        return nArray;
    }

    private static int getDXTColor(int n, int n2, int n3, int n4) {
        switch (n4) {
            case 0: {
                return DDSReader.getDXTColor1(n, n3);
            }
            case 1: {
                return DDSReader.getDXTColor1(n2, n3);
            }
            case 2: {
                return n > n2 ? DDSReader.getDXTColor2_1(n, n2, n3) : DDSReader.getDXTColor1_1(n, n2, n3);
            }
            case 3: {
                return n > n2 ? DDSReader.getDXTColor2_1(n2, n, n3) : 0;
            }
        }
        return 0;
    }

    private static int getDXTColor2_1(int n, int n2, int n3) {
        int n4 = (2 * BIT5[(n & 0xFC00) >> 11] + BIT5[(n2 & 0xFC00) >> 11]) / 3;
        int n5 = (2 * BIT6[(n & 0x7E0) >> 5] + BIT6[(n2 & 0x7E0) >> 5]) / 3;
        int n6 = (2 * BIT5[n & 0x1F] + BIT5[n2 & 0x1F]) / 3;
        return n3 << DDSReader.ARGB_ORDER.alphaShift | n4 << DDSReader.ARGB_ORDER.redShift | n5 << DDSReader.ARGB_ORDER.greenShift | n6 << DDSReader.ARGB_ORDER.blueShift;
    }

    private static int getDXTColor1_1(int n, int n2, int n3) {
        int n4 = (BIT5[(n & 0xFC00) >> 11] + BIT5[(n2 & 0xFC00) >> 11]) / 2;
        int n5 = (BIT6[(n & 0x7E0) >> 5] + BIT6[(n2 & 0x7E0) >> 5]) / 2;
        int n6 = (BIT5[n & 0x1F] + BIT5[n2 & 0x1F]) / 2;
        return n3 << DDSReader.ARGB_ORDER.alphaShift | n4 << DDSReader.ARGB_ORDER.redShift | n5 << DDSReader.ARGB_ORDER.greenShift | n6 << DDSReader.ARGB_ORDER.blueShift;
    }

    private static int getDXTColor1(int n, int n2) {
        int n3 = BIT5[(n & 0xFC00) >> 11];
        int n4 = BIT6[(n & 0x7E0) >> 5];
        int n5 = BIT5[n & 0x1F];
        return n2 << DDSReader.ARGB_ORDER.alphaShift | n3 << DDSReader.ARGB_ORDER.redShift | n4 << DDSReader.ARGB_ORDER.greenShift | n5 << DDSReader.ARGB_ORDER.blueShift;
    }

    private static int getDXT5Alpha(int n, int n2, int n3) {
        if (n > n2) {
            switch (n3) {
                case 0: {
                    return n;
                }
                case 1: {
                    return n2;
                }
                case 2: {
                    return (6 * n + n2) / 7;
                }
                case 3: {
                    return (5 * n + 2 * n2) / 7;
                }
                case 4: {
                    return (4 * n + 3 * n2) / 7;
                }
                case 5: {
                    return (3 * n + 4 * n2) / 7;
                }
                case 6: {
                    return (2 * n + 5 * n2) / 7;
                }
                case 7: {
                    return (n + 6 * n2) / 7;
                }
            }
        } else {
            switch (n3) {
                case 0: {
                    return n;
                }
                case 1: {
                    return n2;
                }
                case 2: {
                    return (4 * n + n2) / 5;
                }
                case 3: {
                    return (3 * n + 2 * n2) / 5;
                }
                case 4: {
                    return (2 * n + 3 * n2) / 5;
                }
                case 5: {
                    return (n + 4 * n2) / 5;
                }
                case 6: {
                    return 0;
                }
                case 7: {
                    return 255;
                }
            }
        }
        return 0;
    }

    private static final class Order {
        public int redShift;
        public int greenShift;
        public int blueShift;
        public int alphaShift;

        Order(int n, int n2, int n3, int n4) {
            this.redShift = n;
            this.greenShift = n2;
            this.blueShift = n3;
            this.alphaShift = n4;
        }
    }
}

