/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.dds;

import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.plugins.dds.DDSHeader;
import com.twelvemonkeys.imageio.plugins.dds.DDSMetadata;
import com.twelvemonkeys.imageio.plugins.dds.DDSReader;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;

public final class DDSImageReader
extends ImageReaderBase {
    private DDSHeader header;

    public DDSImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    protected void resetMembers() {
        this.header = null;
    }

    public int getWidth(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return this.header.getWidth(n);
    }

    public int getHeight(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return this.header.getHeight(n);
    }

    public int getNumImages(boolean bl) throws IOException {
        this.assertInput();
        this.readHeader();
        return this.header.getMipMapCount();
    }

    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return ImageTypeSpecifiers.createFromBufferedImageType((int)2);
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        return Collections.singletonList(this.getRawImageType(n)).iterator();
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        this.processImageStarted(n);
        DDSReader dDSReader = new DDSReader(this.header);
        int[] nArray = dDSReader.read(this.imageInput, n);
        int n2 = this.getWidth(n);
        int n3 = this.getHeight(n);
        BufferedImage bufferedImage = DDSImageReader.getDestination((ImageReadParam)imageReadParam, this.getImageTypes(n), (int)n2, (int)n3);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        DDSImageReader.computeRegions((ImageReadParam)imageReadParam, (int)n2, (int)n3, (BufferedImage)bufferedImage, (Rectangle)rectangle, (Rectangle)rectangle2);
        int n4 = imageReadParam != null ? imageReadParam.getSourceXSubsampling() : 1;
        int n5 = imageReadParam != null ? imageReadParam.getSourceYSubsampling() : 1;
        int n6 = rectangle.y + rectangle.height;
        int n7 = 0;
        int n8 = rectangle.y;
        int n9 = rectangle2.y;
        while (n8 < n6) {
            int n10 = n2 * n8 + rectangle.x;
            IIOUtil.subsampleRow((int[])nArray, (int)n10, (int)n2, (int[])nArray, (int)n10, (int)4, (int)8, (int)n4);
            bufferedImage.setRGB(rectangle2.x, n9, rectangle2.width, 1, nArray, n10, n2);
            if (this.abortRequested()) {
                this.processReadAborted();
                break;
            }
            this.processImageProgress(100.0f * (float)n7 / (float)rectangle2.height);
            ++n7;
            n8 += n5;
            ++n9;
        }
        this.processImageComplete();
        return bufferedImage;
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(n);
        return new DDSMetadata(imageTypeSpecifier, this.header);
    }

    private void readHeader() throws IOException {
        if (this.header == null) {
            this.imageInput.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            this.header = DDSHeader.read(this.imageInput);
            this.imageInput.flushBefore(this.imageInput.getStreamPosition());
        }
        this.imageInput.seek(this.imageInput.getFlushedPosition());
    }

    public static void main(String[] stringArray) throws IOException {
        for (String string : stringArray) {
            File file = new File(string);
            BufferedImage bufferedImage = ImageIO.read(file);
            DDSImageReader.showIt((BufferedImage)bufferedImage, (String)file.getName());
        }
    }
}

