/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.imageio.util.IndexedImageTypeSpecifier;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import org.junit.Assert;
import org.junit.Test;

public class IndexedImageTypeSpecifierTest {
    @Test
    public void testEquals() {
        IndexColorModel indexColorModel = new IndexColorModel(1, 2, new int[]{0xFFFFFF, 0}, 0, false, -1, 0);
        IndexedImageTypeSpecifier indexedImageTypeSpecifier = new IndexedImageTypeSpecifier((ColorModel)indexColorModel);
        IndexedImageTypeSpecifier indexedImageTypeSpecifier2 = new IndexedImageTypeSpecifier((ColorModel)indexColorModel);
        IndexedImageTypeSpecifier indexedImageTypeSpecifier3 = new IndexedImageTypeSpecifier((ColorModel)new IndexColorModel(2, 2, new int[]{0xFF00FF, 0, 0xFF00FF, 0}, 0, false, -1, 0));
        Assert.assertEquals((Object)indexedImageTypeSpecifier, (Object)indexedImageTypeSpecifier2);
        Assert.assertEquals((Object)indexedImageTypeSpecifier2, (Object)indexedImageTypeSpecifier);
        Assert.assertEquals((long)indexedImageTypeSpecifier.hashCode(), (long)indexedImageTypeSpecifier2.hashCode());
        Assert.assertNotEquals((Object)indexedImageTypeSpecifier2, (Object)indexedImageTypeSpecifier3);
    }

    @Test
    public void testHashCode() {
        IndexColorModel indexColorModel = new IndexColorModel(1, 2, new int[]{0xFFFFFF, 0}, 0, false, -1, 0);
        IndexedImageTypeSpecifier indexedImageTypeSpecifier = new IndexedImageTypeSpecifier((ColorModel)indexColorModel);
        IndexedImageTypeSpecifier indexedImageTypeSpecifier2 = new IndexedImageTypeSpecifier((ColorModel)indexColorModel);
        IndexedImageTypeSpecifier indexedImageTypeSpecifier3 = new IndexedImageTypeSpecifier((ColorModel)new IndexColorModel(2, 2, new int[]{0xFF00FF, 0, 0xFF00FF, 0}, 0, false, -1, 0));
        Assert.assertEquals((long)indexedImageTypeSpecifier.hashCode(), (long)indexedImageTypeSpecifier2.hashCode());
        Assert.assertNotEquals((long)indexedImageTypeSpecifier.hashCode(), (long)indexedImageTypeSpecifier3.hashCode());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateNull() {
        new IndexedImageTypeSpecifier(null);
    }

    @Test
    public void testCreateBufferedImageBinary() {
        IndexColorModel indexColorModel = new IndexColorModel(1, 2, new int[]{0xFFFFFF, 0}, 0, false, -1, 0);
        IndexedImageTypeSpecifier indexedImageTypeSpecifier = new IndexedImageTypeSpecifier((ColorModel)indexColorModel);
        BufferedImage bufferedImage = indexedImageTypeSpecifier.createBufferedImage(2, 2);
        Assert.assertNotNull((Object)bufferedImage);
        Assert.assertEquals((long)12L, (long)bufferedImage.getType());
        Assert.assertEquals((Object)indexColorModel, (Object)bufferedImage.getColorModel());
    }

    @Test
    public void testCreateBufferedImageIndexed() {
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, new int[256], 0, false, -1, 0);
        IndexedImageTypeSpecifier indexedImageTypeSpecifier = new IndexedImageTypeSpecifier((ColorModel)indexColorModel);
        BufferedImage bufferedImage = indexedImageTypeSpecifier.createBufferedImage(2, 2);
        Assert.assertNotNull((Object)bufferedImage);
        Assert.assertEquals((long)13L, (long)bufferedImage.getType());
        Assert.assertEquals((Object)indexColorModel, (Object)bufferedImage.getColorModel());
    }
}

