/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.imageio.util.IIOUtil;
import org.junit.Assert;
import org.junit.Test;

public class IIOUtilTest {
    @Test
    public void subsampleRowPeriod2Byte() {
        int n = 2;
        byte[] byArray = new byte[]{-1, 0, -86, 0, -1};
        byte[] byArray2 = new byte[this.divCeil(byArray.length, n)];
        byte[] byArray3 = new byte[]{-1, -86, -1};
        IIOUtil.subsampleRow((byte[])byArray, (int)0, (int)byArray.length, (byte[])byArray2, (int)0, (int)1, (int)8, (int)n);
        Assert.assertArrayEquals((byte[])byArray3, (byte[])byArray2);
    }

    @Test
    public void subsampleRowPeriod2ByteStride3() {
        int n = 2;
        byte[] byArray = new byte[]{-1, -1, -1, 0, 0, 0, -86, -86, -86, 0, 0, 0, -1, -1, -1};
        byte[] byArray2 = new byte[9];
        byte[] byArray3 = new byte[]{-1, -1, -1, -86, -86, -86, -1, -1, -1};
        IIOUtil.subsampleRow((byte[])byArray, (int)0, (int)(byArray.length / 3), (byte[])byArray2, (int)0, (int)3, (int)8, (int)n);
        Assert.assertArrayEquals((byte[])byArray3, (byte[])byArray2);
    }

    @Test
    public void subsampleRowPeriod2Byte1() {
        int n = 2;
        byte[] byArray = new byte[]{-86, -86, -86};
        byte[] byArray2 = new byte[this.divCeil(byArray.length, n)];
        byte[] byArray3 = new byte[]{-1, -16};
        IIOUtil.subsampleRow((byte[])byArray, (int)0, (int)(byArray.length * 8), (byte[])byArray2, (int)0, (int)1, (int)1, (int)n);
        Assert.assertArrayEquals((byte[])byArray3, (byte[])byArray2);
    }

    @Test
    public void subsampleRowPeriod3_1Bit() {
        int n = 3;
        byte[] byArray = new byte[]{-110, 73, 36};
        byte[] byArray2 = new byte[this.divCeil(byArray.length, n)];
        byte[] byArray3 = new byte[]{-1};
        IIOUtil.subsampleRow((byte[])byArray, (int)0, (int)(byArray.length * 8), (byte[])byArray2, (int)0, (int)1, (int)1, (int)n);
        Assert.assertArrayEquals((byte[])byArray3, (byte[])byArray2);
    }

    @Test
    public void subsampleRowPeriod2_2Bit() {
        int n = 2;
        byte[] byArray = new byte[]{-52, -52, -52};
        byte[] byArray2 = new byte[this.divCeil(byArray.length, n)];
        byte[] byArray3 = new byte[]{-1, -16};
        IIOUtil.subsampleRow((byte[])byArray, (int)0, (int)(byArray.length * 4), (byte[])byArray2, (int)0, (int)1, (int)2, (int)n);
        Assert.assertArrayEquals((byte[])byArray3, (byte[])byArray2);
    }

    @Test
    public void subsampleRowPeriod2_4Bit() {
        int n = 2;
        byte[] byArray = new byte[]{-16, -16, -16};
        byte[] byArray2 = new byte[this.divCeil(byArray.length, n)];
        byte[] byArray3 = new byte[]{-1, -16};
        IIOUtil.subsampleRow((byte[])byArray, (int)0, (int)(byArray.length * 2), (byte[])byArray2, (int)0, (int)1, (int)4, (int)n);
        Assert.assertArrayEquals((byte[])byArray3, (byte[])byArray2);
    }

    @Test
    public void subsampleRowPeriod2_1Bit2Samples() {
        int n = 2;
        byte[] byArray = new byte[]{-52, -52, -52};
        byte[] byArray2 = new byte[this.divCeil(byArray.length, n)];
        byte[] byArray3 = new byte[]{-1, -16};
        IIOUtil.subsampleRow((byte[])byArray, (int)0, (int)(byArray.length * 4), (byte[])byArray2, (int)0, (int)2, (int)1, (int)n);
        Assert.assertArrayEquals((byte[])byArray3, (byte[])byArray2);
    }

    @Test
    public void subsampleRowPeriod2_2Bit2Samples() {
        int n = 2;
        byte[] byArray = new byte[]{-16, -16, -16};
        byte[] byArray2 = new byte[this.divCeil(byArray.length, n)];
        byte[] byArray3 = new byte[]{-1, -16};
        IIOUtil.subsampleRow((byte[])byArray, (int)0, (int)(byArray.length * 2), (byte[])byArray2, (int)0, (int)2, (int)2, (int)n);
        Assert.assertArrayEquals((byte[])byArray3, (byte[])byArray2);
    }

    @Test
    public void subsampleRowPeriod2_4Bit2Samples() {
        int n = 2;
        byte[] byArray = new byte[]{-1, 0, -86, 0, -1};
        byte[] byArray2 = new byte[this.divCeil(byArray.length, n)];
        byte[] byArray3 = new byte[]{-1, -86, -1};
        IIOUtil.subsampleRow((byte[])byArray, (int)0, (int)byArray.length, (byte[])byArray2, (int)0, (int)2, (int)4, (int)n);
        Assert.assertArrayEquals((byte[])byArray3, (byte[])byArray2);
    }

    @Test
    public void subsampleRowPeriod2_1BitOffset1() {
        int n = 2;
        byte[] byArray = new byte[]{-86, -86, -86};
        byte[] byArray2 = new byte[this.divCeil(byArray.length, n)];
        byte[] byArray3 = new byte[]{-1, -16};
        IIOUtil.subsampleRow((byte[])byArray, (int)1, (int)(byArray.length * 8), (byte[])byArray2, (int)0, (int)1, (int)1, (int)n);
        Assert.assertArrayEquals((byte[])byArray3, (byte[])byArray2);
    }

    private int divCeil(int n, int n2) {
        return (n + n2 - 1) / n2;
    }
}

