/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.imageio.util.IIOOutputStreamAdapter;
import com.twelvemonkeys.io.OutputStreamAbstractTest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class IIOOutputStreamAdapterTest
extends OutputStreamAbstractTest {
    protected OutputStream makeObject() {
        return new IIOOutputStreamAdapter((ImageOutputStream)new MemoryCacheImageOutputStream(new ByteArrayOutputStream()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateNull() {
        new IIOOutputStreamAdapter(null);
    }

    @Test
    public void testFlushOnAdapterDoesNotMoveFlushedPositionInBacking() throws IOException {
        MemoryCacheImageOutputStream memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(new ByteArrayOutputStream());
        IIOOutputStreamAdapter iIOOutputStreamAdapter = new IIOOutputStreamAdapter((ImageOutputStream)memoryCacheImageOutputStream);
        Assert.assertEquals((long)0L, (long)memoryCacheImageOutputStream.getFlushedPosition());
        iIOOutputStreamAdapter.write(202);
        iIOOutputStreamAdapter.write(new byte[8]);
        iIOOutputStreamAdapter.write(254);
        iIOOutputStreamAdapter.flush();
        Assert.assertEquals((long)10L, (long)memoryCacheImageOutputStream.length());
        Assert.assertEquals((long)10L, (long)memoryCacheImageOutputStream.getStreamPosition());
        Assert.assertEquals((long)0L, (long)memoryCacheImageOutputStream.getFlushedPosition());
        memoryCacheImageOutputStream.seek(0L);
        Assert.assertEquals((long)0L, (long)memoryCacheImageOutputStream.getStreamPosition());
        Assert.assertEquals((long)202L, (long)memoryCacheImageOutputStream.read());
        Assert.assertEquals((long)8L, (long)memoryCacheImageOutputStream.skipBytes(8));
        Assert.assertEquals((long)254L, (long)memoryCacheImageOutputStream.read());
    }
}

