/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.imageio.stream.SubImageInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.junit.Assert;
import org.junit.Test;

public class SubImageInputStreamTest {
    private final Random random = new Random(837468L);

    private ImageInputStream createStream(final int n) {
        byte[] byArray = new byte[n];
        this.random.nextBytes(byArray);
        return new MemoryCacheImageInputStream(new ByteArrayInputStream(byArray)){

            @Override
            public long length() {
                return n;
            }
        };
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateNullStream() throws IOException {
        new SubImageInputStream(null, 1L);
        Assert.fail((String)"Expected IllegalArgumentException with null stream");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateNegativeLength() throws IOException {
        new SubImageInputStream(this.createStream(0), -1L);
        Assert.fail((String)"Expected IllegalArgumentException with negative length");
    }

    @Test
    public void testCreate() throws IOException {
        SubImageInputStream subImageInputStream = new SubImageInputStream(this.createStream(11), 7L);
        Assert.assertEquals((long)0L, (long)subImageInputStream.getStreamPosition());
        Assert.assertEquals((long)7L, (long)subImageInputStream.length());
    }

    @Test
    public void testWraphBeyondWrappedLength() throws IOException {
        SubImageInputStream subImageInputStream = new SubImageInputStream(this.createStream(5), 6L);
        Assert.assertEquals((long)5L, (long)subImageInputStream.length());
    }

    @Test
    public void testWrapUnknownLength() throws IOException {
        SubImageInputStream subImageInputStream = new SubImageInputStream((ImageInputStream)new ImageInputStreamImpl(){

            @Override
            public int read() throws IOException {
                throw new UnsupportedOperationException("Method read not implemented");
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                throw new UnsupportedOperationException("Method read not implemented");
            }

            @Override
            public long length() {
                return -1L;
            }
        }, 6L);
        Assert.assertEquals((long)-1L, (long)subImageInputStream.length());
    }

    @Test
    public void testRead() throws IOException {
        ImageInputStream imageInputStream = this.createStream(42);
        imageInputStream.skipBytes(13);
        SubImageInputStream subImageInputStream = new SubImageInputStream(imageInputStream, 27L);
        Assert.assertEquals((long)0L, (long)subImageInputStream.getStreamPosition());
        Assert.assertEquals((long)27L, (long)subImageInputStream.length());
        subImageInputStream.read();
        Assert.assertEquals((long)1L, (long)subImageInputStream.getStreamPosition());
        Assert.assertEquals((long)27L, (long)subImageInputStream.length());
        subImageInputStream.readFully(new byte[11]);
        Assert.assertEquals((long)12L, (long)subImageInputStream.getStreamPosition());
        Assert.assertEquals((long)27L, (long)subImageInputStream.length());
        Assert.assertEquals((long)25L, (long)imageInputStream.getStreamPosition());
    }

    @Test
    public void testReadResetRead() throws IOException {
        SubImageInputStream subImageInputStream = new SubImageInputStream(this.createStream(32), 16L);
        subImageInputStream.mark();
        byte[] byArray = new byte[16];
        subImageInputStream.readFully(byArray);
        subImageInputStream.reset();
        byte[] byArray2 = new byte[16];
        subImageInputStream.readFully(byArray2);
        Assert.assertTrue((boolean)Arrays.equals(byArray, byArray2));
    }

    @Test
    public void testSeekNegative() throws IOException {
        SubImageInputStream subImageInputStream = new SubImageInputStream(this.createStream(7), 5L);
        try {
            subImageInputStream.seek(-2L);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Assert.assertTrue((boolean)indexOutOfBoundsException.getMessage().contains("pos"));
        }
        Assert.assertEquals((long)0L, (long)subImageInputStream.getStreamPosition());
    }

    @Test
    public void testSeekBeforeFlushedPos() throws IOException {
        SubImageInputStream subImageInputStream = new SubImageInputStream(this.createStream(7), 5L);
        subImageInputStream.seek(3L);
        subImageInputStream.flushBefore(3L);
        Assert.assertEquals((long)3L, (long)subImageInputStream.getStreamPosition());
        try {
            subImageInputStream.seek(0L);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Assert.assertTrue((boolean)indexOutOfBoundsException.getMessage().contains("pos"));
        }
        Assert.assertEquals((long)3L, (long)subImageInputStream.getStreamPosition());
    }

    @Test
    public void testSeekAfterEOF() throws IOException {
        SubImageInputStream subImageInputStream = new SubImageInputStream(this.createStream(7), 5L);
        subImageInputStream.seek(6L);
        Assert.assertEquals((long)-1L, (long)subImageInputStream.read());
    }

    @Test
    public void testSeek() throws IOException {
        SubImageInputStream subImageInputStream = new SubImageInputStream(this.createStream(7), 5L);
        subImageInputStream.seek(5L);
        Assert.assertEquals((long)5L, (long)subImageInputStream.getStreamPosition());
        subImageInputStream.seek(1L);
        Assert.assertEquals((long)1L, (long)subImageInputStream.getStreamPosition());
    }
}

