/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.imageio.stream.BufferedImageInputStream;
import com.twelvemonkeys.imageio.stream.ByteArrayImageInputStream;
import com.twelvemonkeys.io.ole2.CompoundDocument;
import com.twelvemonkeys.io.ole2.Entry;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Random;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BufferedImageInputStreamTest {
    private final Random random = new Random(3450972865211L);

    @Test
    public void testCreate() throws IOException {
        new BufferedImageInputStream((ImageInputStream)new ByteArrayImageInputStream(new byte[0]));
    }

    @Test
    public void testCreateNull() throws IOException {
        try {
            new BufferedImageInputStream(null);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertNotNull((String)"Null exception message", (Object)illegalArgumentException.getMessage());
            String string = illegalArgumentException.getMessage().toLowerCase();
            Assert.assertTrue((String)"Exception message does not contain parameter name", (boolean)string.contains("stream"));
            Assert.assertTrue((String)"Exception message does not contain null", (boolean)string.contains("null"));
        }
    }

    @Test
    public void testReadBit() throws IOException {
        byte[] byArray = new byte[]{-16, 15};
        BufferedImageInputStream bufferedImageInputStream = new BufferedImageInputStream((ImageInputStream)new ByteArrayImageInputStream(byArray));
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)2L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)3L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)4L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)5L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)6L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)7L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.getStreamPosition());
        bufferedImageInputStream.seek(0L);
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.getStreamPosition());
        bufferedImageInputStream.seek(0L);
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.readBit());
        bufferedImageInputStream.setBitOffset(0);
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readBit());
        bufferedImageInputStream.setBitOffset(3);
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getStreamPosition());
        bufferedImageInputStream.setBitOffset(6);
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)2L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)3L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)4L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)5L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)6L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)7L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.readBit());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)2L, (long)bufferedImageInputStream.getStreamPosition());
    }

    @Test
    public void testReadBits() throws IOException {
        byte[] byArray = new byte[]{-16, -52, -86};
        BufferedImageInputStream bufferedImageInputStream = new BufferedImageInputStream((ImageInputStream)new ByteArrayImageInputStream(byArray));
        Assert.assertEquals((long)3L, (long)bufferedImageInputStream.readBits(2));
        Assert.assertEquals((long)2L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)3L, (long)bufferedImageInputStream.readBits(2));
        Assert.assertEquals((long)4L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readBits(2));
        Assert.assertEquals((long)6L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readBits(2));
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)3L, (long)bufferedImageInputStream.readBits(2));
        Assert.assertEquals((long)2L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readBits(2));
        Assert.assertEquals((long)4L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)3L, (long)bufferedImageInputStream.readBits(2));
        Assert.assertEquals((long)6L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readBits(2));
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)2L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)2L, (long)bufferedImageInputStream.readBits(2));
        Assert.assertEquals((long)2L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)2L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)2L, (long)bufferedImageInputStream.readBits(2));
        Assert.assertEquals((long)4L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)2L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)2L, (long)bufferedImageInputStream.readBits(2));
        Assert.assertEquals((long)6L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)2L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)2L, (long)bufferedImageInputStream.readBits(2));
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)3L, (long)bufferedImageInputStream.getStreamPosition());
        bufferedImageInputStream.seek(0L);
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)7L, (long)bufferedImageInputStream.readBits(3));
        Assert.assertEquals((long)3L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)8L, (long)bufferedImageInputStream.readBits(4));
        Assert.assertEquals((long)7L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)12L, (long)bufferedImageInputStream.readBits(5));
        Assert.assertEquals((long)4L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)50L, (long)bufferedImageInputStream.readBits(6));
        Assert.assertEquals((long)2L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)2L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)42L, (long)bufferedImageInputStream.readBits(6));
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)3L, (long)bufferedImageInputStream.getStreamPosition());
        bufferedImageInputStream.seek(0L);
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)3852L, (long)bufferedImageInputStream.readBits(12));
        Assert.assertEquals((long)4L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)1L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)3242L, (long)bufferedImageInputStream.readBits(12));
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)3L, (long)bufferedImageInputStream.getStreamPosition());
        bufferedImageInputStream.seek(0L);
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getBitOffset());
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.getStreamPosition());
        Assert.assertEquals((long)15781034L, (long)bufferedImageInputStream.readBits(24));
    }

    @Test
    public void testReadBitsRandom() throws IOException {
        long l = this.random.nextLong();
        byte[] byArray = new byte[8];
        ByteBuffer.wrap(byArray).putLong(l);
        BufferedImageInputStream bufferedImageInputStream = new BufferedImageInputStream((ImageInputStream)new ByteArrayImageInputStream(byArray));
        for (int i = 1; i < 64; ++i) {
            bufferedImageInputStream.seek(0L);
            Assert.assertEquals((String)(i + " bits differ"), (long)(l >>> (int)(64L - (long)i)), (long)bufferedImageInputStream.readBits(i));
        }
    }

    @Test
    public void testClose() throws IOException {
        ImageInputStream imageInputStream = (ImageInputStream)Mockito.mock(ImageInputStream.class);
        BufferedImageInputStream bufferedImageInputStream = new BufferedImageInputStream(imageInputStream);
        bufferedImageInputStream.close();
        ((ImageInputStream)Mockito.verify((Object)imageInputStream, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void testArrayIndexOutOfBoundsBufferedReadBug() throws IOException {
        BufferedImageInputStream bufferedImageInputStream = new BufferedImageInputStream((ImageInputStream)new MemoryCacheImageInputStream(this.getClass().getResourceAsStream("/Thumbs-camera.db")));
        bufferedImageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        Entry entry = new CompoundDocument((ImageInputStream)bufferedImageInputStream).getRootEntry();
        Entry entry2 = entry.getChildEntry("Catalog");
        Assert.assertNotNull((String)"Catalog should not be null", (Object)entry2);
        Assert.assertNotNull((String)"Input stream can never be null", (Object)entry2.getInputStream());
    }

    @Test
    public void testReadResetReadDirectBufferBug() throws IOException {
        int n = 8192;
        byte[] byArray = new byte[n * 2];
        this.random.nextBytes(byArray);
        BufferedImageInputStream bufferedImageInputStream = new BufferedImageInputStream((ImageInputStream)new ByteArrayImageInputStream(byArray));
        bufferedImageInputStream.readLong();
        bufferedImageInputStream.seek(0L);
        byte[] byArray2 = new byte[n];
        bufferedImageInputStream.readFully(byArray2);
        Assert.assertTrue((boolean)BufferedImageInputStreamTest.rangeEquals(byArray, 0, byArray2, 0, n));
        bufferedImageInputStream.readFully(byArray2);
        Assert.assertTrue((boolean)BufferedImageInputStreamTest.rangeEquals(byArray, n, byArray2, 0, n));
    }

    @Test
    public void testBufferPositionCorrect() throws IOException {
        byte[] byArray = new byte[1024];
        this.random.nextBytes(byArray);
        ByteArrayImageInputStream byteArrayImageInputStream = new ByteArrayImageInputStream(byArray);
        byteArrayImageInputStream.readByte();
        byteArrayImageInputStream.readByte();
        byteArrayImageInputStream.skipBytes(124);
        byteArrayImageInputStream.readByte();
        byteArrayImageInputStream.readByte();
        Assert.assertEquals((long)128L, (long)byteArrayImageInputStream.getStreamPosition());
        BufferedImageInputStream bufferedImageInputStream = new BufferedImageInputStream((ImageInputStream)byteArrayImageInputStream);
        Assert.assertEquals((long)byteArrayImageInputStream.getStreamPosition(), (long)bufferedImageInputStream.getStreamPosition());
        bufferedImageInputStream.skipBytes(128);
        Assert.assertEquals((long)256L, (long)bufferedImageInputStream.getStreamPosition());
        bufferedImageInputStream.seek(1020L);
        Assert.assertEquals((long)1020L, (long)bufferedImageInputStream.getStreamPosition());
    }

    @Test
    public void testReadIntegralOnBufferBoundary() throws IOException {
        int n = 8192;
        byte[] byArray = new byte[n * 2];
        Arrays.fill(byArray, n - 4, n + 4, (byte)-1);
        BufferedImageInputStream bufferedImageInputStream = new BufferedImageInputStream((ImageInputStream)new ByteArrayImageInputStream(byArray));
        Assert.assertEquals((long)0L, (long)bufferedImageInputStream.readInt());
        bufferedImageInputStream.seek((long)(n - 3));
        Assert.assertEquals((long)-1L, (long)bufferedImageInputStream.readInt());
        Assert.assertEquals((long)(n + 1), (long)bufferedImageInputStream.getStreamPosition());
    }

    public static boolean rangeEquals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (byArray == byArray2 && n == n2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length < n + n3 || byArray2.length < n2 + n3) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            if (byArray[n + i] == byArray2[n2 + i]) continue;
            return false;
        }
        return true;
    }
}

